
! Copyright (C) 2017 T. Mueller, J. K. Dewhurst, S. Sharma and E. K. U. Gross.
! This file is distributed under the terms of the GNU General Public License.
! See the file COPYING for license details.

module modulr

!-----------------------------!
!     ultracell variables     !
!-----------------------------!
! ultracell lattice vectors stored column-wise
real(8) avecu(3,3)
! ultracell reciprocal lattice vectors
real(8) bvecu(3,3)
! ultracell volume and Brillouin zone volume
real(8) omegau,omegabzu
! original number of k-points
integer nkpt0
! original k-point weights
real(8), allocatable :: wkpt0(:)
! kappa-point grid sizes
integer ngridkpa(3)
! integer grid intervals for the kappa-points
integer intkpa(2,3)
! number of kappa-points
integer nkpa
! R-vectors in Cartesian coordinates spanning the ultracell
real(8), allocatable :: vrcu(:,:)
! ultracell effective valence charge
real(8) chgvalu

!------------------------------!
!     G+Q-vector variables     !
!------------------------------!
! G+Q-vectors in Cartesian coordinates
real(8), allocatable :: vgqc(:,:,:)
! |G+Q| for all G+Q-vectors
real(8), allocatable :: gqc(:,:)
! Coulomb Green's function in G+Q-space = 4 pi / |G+Q|^2
real(8), allocatable :: gclgq(:,:)
! spherical Bessel functions j_l(|G+Q|R_mt)
real(8), allocatable :: jlgqrmt(:,:,:,:)
! spherical harmonics of the G+Q-vectors
complex(8), allocatable :: ylmgq(:,:,:)
! structure factors for the G+Q-vectors
complex(8), allocatable :: sfacgq(:,:,:)
! phase factor functions exp(iQ.r) in each muffin-tin
complex(8), allocatable :: expqmt(:,:,:)

!---------------------------------------------------!
!     ultra long-range densities and potentials     !
!---------------------------------------------------!
! R-dependent external Coulomb potential
real(8), allocatable :: vclru(:)
! R-dependent external magnetic field
real(8), allocatable :: bfcru(:,:)
! R-dependent external muffin-tin magnetic fields
real(8), allocatable :: bfcmtru(:,:,:)
! R-dependent density and magnetisation
real(8), allocatable :: rhormt(:,:,:),rhorir(:,:)
real(8), allocatable :: magrmt(:,:,:,:),magrir(:,:,:)
! muffin-tin moments averaged over the ultracell
real(8), allocatable :: mommtu(:,:)
! muffin-tin moments for each R-vector
real(8), allocatable :: mommtru(:,:,:)
! Q-dependent density and magnetisation
complex(8), allocatable :: rhoqmt(:,:,:),rhoqir(:,:)
complex(8), allocatable :: magqmt(:,:,:,:),magqir(:,:,:)
! Q-dependent Kohn-Sham potential and magnetic field
complex(8), allocatable :: vsqmt(:,:,:),vsqir(:,:)
complex(8), allocatable :: bsqmt(:,:,:,:),bsqir(:,:,:)
! random amplitude used for initialising the long-range potentials and fields
real(8) rndulr

!----------------------------------------------!
!     eigenvalue and eigenvector variables     !
!----------------------------------------------!
! number of ultra long-range states
integer nstulr
! long-range eigenvalues
real(8), allocatable :: evalu(:,:)
! long-range occupation numbers
real(8), allocatable :: occulr(:,:)

end module

