/*
                              MIME Types Fetching
 */

#ifndef EDVMIMETYPESGET_H
#define EDVMIMETYPESGET_H

#include <sys/stat.h>
#include <glib.h>
#include "edvmimetypes.h"
#include "edvcontext.h"


/*
 *	Returns a list of MIME Types.
 *
 *	The returned list must not be modified or deleted.
 */
extern edv_mimetype_struct **EDVMimeTypeList(
	edv_context_struct *ctx, gint *total
);

/*
 *	Matches the object specified by path and lstat_buf with a
 *	MIME Type.
 *
 *	Returns the matched MIME Type or NULL on error, the returned
 *	MIME Type must not be modified or deleted.
 */
extern edv_mimetype_struct *EDVMimeTypeMatch(
	edv_context_struct *ctx,
	const gchar *path, const struct stat *lstat_buf
);

/*
 *	Matches the MIME Type by the specified type string.
 *
 *	Returns the matched MIME Type or NULL on error, the returned
 *	MIME Type must not be modified or deleted.
 */
extern edv_mimetype_struct *EDVMimeTypeMatchType(
	edv_context_struct *ctx,
	const gchar *type
);


#endif	/* EDVMIMETYPESGET_H */
