/*
 * Copyright (C) 2002,2003 Daniel Heck
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *  
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: video.hh,v 1.3 2003/06/18 18:19:20 dheck Exp $
 */

#ifndef VIDEO_HH_INCLUDED
#define VIDEO_HH_INCLUDED

#include "SDL.h"
#include "px/pxfwd.hh"

namespace video
{

    enum VideoModes {
        VM_640x480,
        VM_640x512,
        VM_COUNT
    };

    struct VMInfo {
        int width, height;
        const char *name;
    };


    void Init();
    void Shutdown();

    px::Screen *GetScreen();

    const VMInfo *GetInfo (VideoModes vm);

    /* The backbuffer is surface that has the same size and pixel
       format as the screen.  This surface is used by ShowScreen() and
       FX_* functions below. */
    px::Surface *BackBuffer();

    void ToggleInputgrab();

    /* Switch between windowed and fullscreen mode. Return true if fullscreen 
     * mode is active afterwards. */
    bool ToggleFullscreen();
    
    void SetCaption(const char *str);
    void SetPalette(const char *palname);

    /* Return the number of bits per pixel in the current video mode. */
    int GetColorDepth();

    //
    // Mouse cursor
    // 
    void SetMouseCursor(px::Surface *s, int hotx, int hoty);
    void HideMouse();
    void ShowMouse();
    int Mousex();
    int Mousey();

    //
    // Visual effects
    //
    enum FadeMode { FADEIN, FADEOUT };
    void FX_Fade(FadeMode mode);
    void FX_Fly (px::Surface *newscr, int originx, int originy);

    enum TransitionModes
    {
	TM_RANDOM,
	TM_FADEOUTIN,
	TM_SQUARES,
	TM_FLY_N, TM_FLY_S, TM_FLY_W, TM_FLY_E,
	TM_FLY_NW, TM_FLY_NE, TM_FLY_SE, TM_FLY_SW,
        TM_PUSH_RANDOM, TM_PUSH_N, TM_PUSH_S, TM_PUSH_W, TM_PUSH_E
    };
    void ShowScreen (TransitionModes tm, px::Surface *newscr);
    
    void Screenshot(const char *fname);
}

#endif
