#------------------------------------------------------------------------------
# Copyright (c) 2005, Enthought, Inc.
# All rights reserved.
# 
# This software is provided without warranty under the terms of the BSD
# license included in enthought/LICENSE.txt and may be redistributed only
# under the conditions described in the aforementioned license.  The license
# is also available online at http://www.enthought.com/licenses/BSD.txt
# Thanks for using Enthought open source!
# 
# Author: Enthought, Inc.
# Description: <Enthought pyface package component>
#------------------------------------------------------------------------------
""" A dialog that allows the user to browse for a directory. """


# Major package imports.
import wx

# Enthought library imports.
from enthought.traits.api import Bool, Str, Trait

# Local imports.
from dialog import Dialog


class DirectoryDialog(Dialog):
    """ A dialog that allows the user to browse for a directory. """

    #### 'DirectoryDialog' interface ##########################################

    # The 'action' that the user is peforming on the directory.
    #
    # fixme: Support something other than 'open'!
    action = Trait('open', 'open')

    # The default path.
    default_path = Str
    
    # True iff the dialog should include a button that allows the user to
    # create a new directory.
    new_directory = Bool(True)

    # The message to display in the dialog.
    message = Str('Choose a directory')

    # The path of the chosen directory.
    path = Str

    ###########################################################################
    # 'Window' interface.
    ###########################################################################

    def close(self):
        """ Closes the window. """

        # Get the path of the chosen directory.
        self.path = self.control.GetPath()

        # Let the window close as normal.
        super(DirectoryDialog, self).close()

        return
    
    ###########################################################################
    # Protected 'Window' interface.
    ###########################################################################

    def _create_control(self, parent):
        """ Create the toolkit-specific control that represents the window. """

        # The default style.
        style = wx.OPEN | wx.HIDE_READONLY
        
        # Create the wx style depending on which buttons are required etc.
        if self.new_directory:
            style = style | wx.DD_NEW_DIR_BUTTON

        # Create the actual dialog.
        dialog = wx.DirDialog(
            parent,
            message     = self.message,
            defaultPath = self.default_path,
            style       = style
        )
        
        return dialog

    def _create_contents(self, parent):
        """ Creates the window contents. """

        # In this case, wx does it all for us in 'wx.DirDialog'.
        pass
    
#### EOF ######################################################################
