#------------------------------------------------------------------------------
# Copyright (c) 2005, Enthought, Inc.
# All rights reserved.
# 
# This software is provided without warranty under the terms of the BSD
# license included in enthought/LICENSE.txt and may be redistributed only
# under the conditions described in the aforementioned license.  The license
# is also available online at http://www.enthought.com/licenses/BSD.txt
# Thanks for using Enthought open source!
# 
# Author: Enthought, Inc.
# Description: <Enthought pyface package component>
#------------------------------------------------------------------------------
""" The abstract base class for all Pyface widgets. """


# Enthought library imports.
from enthought.traits.api import Any, HasPrivateTraits

# Local imports.
from gui import GUI


class Widget(HasPrivateTraits):
    """ The abstract base class for all Pyface widgets.

    Pyface widgets delegate to a toolkit-specific control.

    """

    # The toolkit-specific control that represents the widget.
    control = Any

    ###########################################################################
    # 'Widget' interface.
    ###########################################################################

    def invoke_later(self, callable, *args, **kw):
        """ Invokes a callable in the main GUI thread. """
        
        GUI.invoke_later(callable, *args, **kw)

        return
    
    def set_trait_later(self, obj, trait_name, new):
        """ Sets a trait in the main GUI thread. """

        GUI.set_trait_later(callable, *args, **kw)
        
        return

#### EOF ######################################################################
