from setuptools import setup, find_packages


# Function to convert simple ETS project names and versions to a requirements
# spec that works for both development builds and stable builds.  Allows
# a caller to specify a max version, which is intended to work along with
# Enthought's standard versioning scheme -- see the following write up:
#    https://svn.enthought.com/enthought/wiki/EnthoughtVersionNumbers
def etsdep(p, min, max=None, literal=False):
    require = '%s >=%s.dev' % (p, min)
    if max is not None:
        if literal is False:
            require = '%s, <%sa' % (require, max)
        else:
            require = '%s, <%s' % (require, max)
    return require


# Declare our ETS project dependencies.
#DEBUG -- all imports in try...except so not needed
#DEVELOPER -- all imports in try...except so not needed
#IO -- all imports in try...except so not needed
#NAMING -- all imports in try...except so not needed
PYFACE_DOCK = etsdep('enthought.pyface[dock]', '2.0.4', '3.0')
TRAITS_UI = etsdep('enthought.traits[ui]', '2.0.5', '3.0')
UTIL = etsdep('enthought.util', '2.0.4', '3.0')


setup(
    author = 'David C. Morrill',
    author_email = 'dmorrill@enthought.com',
    dependency_links = [
        'http://code.enthought.com/enstaller/eggs/source',
        ],
    description = 'WxPython backend for enthought.traits',
    extras_require = {
        # All non-ets dependencies should be in this extra to ensure users can
        # decide whether to require them or not.
        'nonets': [
            ],
        },
    include_package_data = True,
    install_requires = [
        PYFACE_DOCK,
        TRAITS_UI,
        UTIL,
        ],
    license = 'BSD',
    name = 'enthought.traits.ui.wx',
    namespace_packages = [
        "enthought",
        "enthought.traits",
        "enthought.traits.ui",
        ],
    packages = find_packages(),
    tests_require = [
        'nose >= 0.9',
        ],
    test_suite = 'nose.collector',
    url = 'http://code.enthought.com/traits',
    version = '2.0.5',
    zip_safe = False,
    )
