#include <gtk/gtk.h>
#include <stdlib.h>
#include "entity.h"
#include "gtk-common.h"
#include "gtk-widget-attr.h"

/*--element

Element Name: <arrow>

Creates a new gtkarrow at the appropriate place in the tree.

*/


static void
rendgtk_arrow_onclick_callback (GtkWidget * widget, gpointer user_data)
{
    ENode *node = user_data;
    gchar *function = NULL;

    function = enode_attrib_str (node, "onclick", NULL);

    enode_call_ignore_return (node, function, "");
}

static gint
rendgtk_arrow_onclick_attr_set (ENode * node, EBuf * attr, EBuf * value)
{
    GtkWidget *arrow;

    arrow = enode_get_kv (node, "top-widget");

    return (TRUE);
}

static gint
set_arrow_position (ENode * node, EBuf * attr, EBuf * value)
{
    int position = 0;
    GtkWidget *arrow;
    gchar *text_position = enode_attrib_str (node, "position", NULL);

    position = atoi (text_position);

    arrow = enode_get_kv (node, "top-widget");

    EDEBUG (("arrow-renderer", "setting arrow position to %d", position));

    switch (position) {
    case 0:
    case 360:
	gtk_arrow_set ((GtkArrow *) arrow, GTK_ARROW_UP, GTK_SHADOW_OUT);
	break;

    case 90:
	gtk_arrow_set ((GtkArrow *) arrow, GTK_ARROW_RIGHT, GTK_SHADOW_OUT);
	break;

    case 180:
	gtk_arrow_set ((GtkArrow *) arrow, GTK_ARROW_DOWN, GTK_SHADOW_OUT);
	break;

    case 270:
	gtk_arrow_set ((GtkArrow *) arrow, GTK_ARROW_LEFT, GTK_SHADOW_OUT);
	break;
    };

    return TRUE;
}

static void
rendgtk_arrow_render (ENode * node)
{
    GtkWidget *arrow;

    EDEBUG (("arrow-renderer", "in rendgtk_arrow_render"));

    arrow = gtk_arrow_new (GTK_ARROW_UP, GTK_SHADOW_OUT);

    enode_set_kv (node, "top-widget", arrow);
    enode_set_kv (node, "bottom-widget", arrow);

    gtk_signal_connect (GTK_OBJECT (arrow), "button_press_event",
			rendgtk_arrow_onclick_callback, node);

    enode_attribs_sync (node);

    rendgtk_show_cond (node, arrow);
}


void
arrow_renderer_register (void)
{
    Element *element;
    ElementAttr *e_attr;

    element = g_new0 (Element, 1);
    element->render_func = rendgtk_arrow_render;
    element->destroy_func = rendgtk_element_destroy;
    element->parent_func = rendgtk_box_pack;
    element->tag = "arrow";
    element->description = "Create a new arrow widget";
    element_register (element);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "onclick";
    e_attr->description = "Sets up a handler for click events.";
    e_attr->value_desc = "function";
    e_attr->possible_values = "(calling_node)";
    e_attr->set_attr_func = rendgtk_arrow_onclick_attr_set;
    element_register_attrib (element, e_attr);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "position";
    e_attr->description = "Direction Arrow points in 90 degree increments";
    e_attr->value_desc = "integer";
    e_attr->set_attr_func = set_arrow_position;
    element_register_attrib (element, e_attr);

    rendgtk_widget_attr_register (element, GTK_TYPE_ARROW);
}
