#!/usr/bin/env entity

<object default-lang="tcl">
  <?tcl proc quit {node args} { if {"q" == [lindex $args 0]} { $node entity:exit } } ?>
  
  <window onkeypress = "quit" ondelete = "entity:exit" 
   title = "Arc Test (q to quit)" width = "400" height = "400">
    
    <object expand = "true" fill = "true" dragable="true" 
     default-lang = "tcl" tooltip = "drag me with the left button">
      
       <graph name="graph-data"
             selectable = "false"
             expand="true"
             fill="true"
             zoomable = "true"
             cross = "false"
             xmin = "-10" xmax = "10" ymin = "-10" ymax = "10"
             onmousemotion = "motion">
        <!-- the point attributes x and y are unset initially
             and are calculated using the motion routine which
             uses the point data
         -->
        <!-- front -->
        <graph-line linewidth = "3" type = "line" color = "#0000ff">
          <graph-point>-4 -4  6</graph-point>
          <graph-point>-4  4  6</graph-point>
          <graph-point> 4  4  6</graph-point>
          <graph-point> 4 -4  6</graph-point>
          <graph-point>-4 -4  6</graph-point>
        </graph-line>
        <!-- back -->
        <graph-line linewidth = "3" type = "line" color = "#0000ff">
          <graph-point>-4 -4 -6</graph-point>
          <graph-point>-4  4 -6</graph-point>
          <graph-point> 4  4 -6</graph-point>
          <graph-point> 4 -4 -6</graph-point>
          <graph-point>-4 -4 -6</graph-point>
        </graph-line>
        <!-- top -->
        <graph-line linewidth = "3" type = "line" color = "#0000ff">
          <graph-point>-4  6 -4</graph-point>
          <graph-point>-4  6  4</graph-point>
          <graph-point> 4  6  4</graph-point>
          <graph-point> 4  6 -4</graph-point>
          <graph-point>-4  6 -4</graph-point>
        </graph-line>
        <!-- bottom -->
        <graph-line linewidth = "3" type = "line" color = "#0000ff">
          <graph-point>-4 -6 -4</graph-point>
          <graph-point>-4 -6  4</graph-point>
          <graph-point> 4 -6  4</graph-point>
          <graph-point> 4 -6 -4</graph-point>
          <graph-point>-4 -6 -4</graph-point>
        </graph-line>
        <!-- left -->
        <graph-line linewidth = "3" type = "line" color = "#0000ff">
          <graph-point>-6 -4 -4</graph-point>
          <graph-point>-6 -4  4</graph-point>
          <graph-point>-6  4  4</graph-point>
          <graph-point>-6  4 -4</graph-point>
          <graph-point>-6 -4 -4</graph-point>
        </graph-line>
        <!-- right -->
        <graph-line linewidth = "3" type = "line" color = "#0000ff">
          <graph-point> 6 -4 -4</graph-point>
          <graph-point> 6 -4  4</graph-point>
          <graph-point> 6  4  4</graph-point>
          <graph-point> 6  4 -4</graph-point>
          <graph-point> 6 -4 -4</graph-point>
        </graph-line>
      </graph>
      <?tcl

        set X -1
        set Y -1
        set RX 30
        set RY 30

        proc motion {node button x y} {
          global X Y RX RY
          if {1 == $button && $X >= 0} {
            set dx [expr $x - $X]
            set dy [expr $y - $Y]
            set RX [expr $RX + $dx]
            set RY [expr $RY + $dy]
            foreach point [$node children graph-point] {
              rotate_point $point $RX $RY
            }
          }
          set X $x
          set Y $y
        }

        proc sind alpha {
          return [expr sin($alpha * 0.0174533)]
        }

        proc cosd alpha {
          return [expr cos($alpha * 0.0174533)]
        }

        proc rotate_point {point rx ry} {
          set data [$point get_data]
          set x [lindex $data 0]
          set y [lindex $data 1]
          set z [lindex $data 2]

          set tmp [expr  [cosd $rx] * $x + [sind $rx] * $z]
          set z   [expr -[sind $rx] * $x + [cosd $rx] * $z]
          set x $tmp

          set tmp [expr  [cosd $ry] * $y - [sind $ry] * $z]
          set z   [expr  [sind $ry] * $y + [cosd $ry] * $z]
          set y $tmp

          $point attrib x $x y $y
        }

        # initialize point attributes
        set object [enode object]
        foreach point [$object children graph-point] {
          rotate_point $point $RX $RY
        }

      ?>
    </object>
  </window>
</object>
