# -*- coding: utf-8 -*-

# Copyright (c) 2004 - 2005 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing a splashscreen for eric3.
"""

import os.path

from qt import QApplication, QPixmap, QVBox, Qt, QLabel, QFrame, QPoint, qApp

from eric3config import getConfig

class SplashScreen(QVBox):
    """
    Class implementing a splashscreen for eric3.
    """
    def __init__(self):
        """
        Constructor
        """
        QVBox.__init__(self, None, "splash", 
            Qt.WDestructiveClose | Qt.WStyle_Customize | Qt.WStyle_NoBorder |\
            Qt.WX11BypassWM | Qt.WStyle_StaysOnTop)
        self.setFrameStyle(QFrame.Plain)
        ericPic = QPixmap(os.path.join(getConfig('ericPixDir'), 'eric.png'))
        pic = QLabel(self, "splashpic")
        pic.setPixmap(ericPic)
        self.msg = QLabel(self)
        self.msg.setIndent(6)
        self.msg.setPaletteBackgroundColor(Qt.black)
        self.msg.setPaletteForegroundColor(Qt.white)
        self.msg.setFrameStyle(QFrame.Plain)
        self.adjustSize()
        screen = QApplication.desktop().screenGeometry()
        self.move(QPoint(screen.center().x() - self.width()/2, 
                         screen.center().y() - self.height()/2))
        self.show()
        qApp.processEvents()
        
    def message(self, msg):
        """
        Public method to show a message in the bottom part of the splashscreen.
        
        @param msg message to be shown (string or QString)
        """
        self.msg.setText(msg)
        qApp.processEvents()

class NoneSplashScreen:
    """
    Class implementing a "None" splashscreen for eric3.
    
    This class implements the same interface as the real splashscreen,
    but simply does nothing.
    """
    def __init__(self):
        """
        Constructor
        """
        pass
        
    def message(self, msg):
        """
        Public method to show a message in the bottom part of the splashscreen.
        
        @param msg message to be shown (string or QString)
        """
        pass
