# -*- coding: utf-8 -*-

# Copyright (c) 2003 - 2005 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing a dialog to enter the data for a merge operation.
"""

from qt import *

from MergeForm import MergeForm

class SvnMergeDialog(MergeForm):
    """
    Class implementing a dialog to enter the data for a merge operation.
    """
    def __init__(self, mergelist1, mergelist2, targetlist, parent = None):
        """
        Constructor
        
        @param mergelist1 list of previously entered URLs/revisions (QStringList)
        @param mergelist2 list of previously entered URLs/revisions (QStringList)
        @param targetlist list of previously entered targets (QStringList)
        @param parent parent widget (QWidget)
        """
        MergeForm.__init__(self, parent, None, 1)
       
        dummy = self.trUtf8('dummy')
        
        self.rx_url = QRegExp('(?:file:|svn:|svn+ssh:|http:|https:)//.+')
        self.rx_rev = QRegExp('\\d+')
        
        self.tag1Combo.clear()
        self.tag1Combo.insertStringList(mergelist1)
        self.tag2Combo.clear()
        self.tag2Combo.insertStringList(mergelist2)
        self.targetCombo.clear()
        self.targetCombo.insertStringList(targetlist)
        
    def enableOkButton(self, text):
        """
        Private method used to enable/disable the OK-button.
        
        @param text ignored
        """
        self.okButton.setDisabled(
            self.tag1Combo.currentText().isEmpty() or \
            self.tag2Combo.currentText().isEmpty() or \
            not ((self.rx_url.exactMatch(self.tag1Combo.currentText()) and \
                  self.rx_url.exactMatch(self.tag2Combo.currentText())) or \
                 (self.rx_rev.exactMatch(self.tag1Combo.currentText()) and \
                  self.rx_rev.exactMatch(self.tag2Combo.currentText()))
                )
            )
    
    def getParameters(self):
        """
        Public method to retrieve the tag data.
        
        @return tuple naming two tag names or two revisions (QString, QString)
        """
        return (self.tag1Combo.currentText(), 
                self.tag2Combo.currentText(),
                self.targetCombo.currentText())
