# -*- coding: utf-8 -*-

# Copyright (c) 2005 - 2006 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing a TabWidget class substituting QTabWidget.
"""

from qt import QTabWidget

class E3TabWidget(QTabWidget):
    """
    Class implementing a TabWidget class substituting QTabWidget.
    
    It provides slots to show the previous and next tab and give
    them the input focus.
    """
    def nextTab(self):
        """
        Public slot used to show the next tab.
        """
        ind = self.currentPageIndex() + 1
        if ind == self.count():
            ind = 0
            
        twidget = self.page(ind)
        self.showPage(twidget)
        twidget.setFocus()

    def prevTab(self):
        """
        Public slot used to show the previous tab.
        """
        ind = self.currentPageIndex() - 1
        if ind == -1:
            ind = self.count() - 1
            
        twidget = self.page(ind)
        self.showPage(twidget)
        twidget.setFocus()
