# -*- coding: utf-8 -*-

# Copyright (c) 2006 - 2008 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing the VCS configuration page.
"""

from ConfigurationPageBase import ConfigurationPageBase
from Ui_VcsPage import Ui_VcsPage

import Preferences

class VcsPage(ConfigurationPageBase, Ui_VcsPage):
    """
    Class implementing the VCS configuration page.
    """
    def __init__(self):
        """
        Constructor
        """
        ConfigurationPageBase.__init__(self)
        self.setupUi(self)
        self.setObjectName("VcsPage")
        
        # set initial values
        self.vcsAutoCloseCheckBox.setChecked(Preferences.getVCS("AutoClose"))
        self.vcsAutoSaveCheckBox.setChecked(Preferences.getVCS("AutoSaveFiles"))
        self.vcsAutoSaveProjectCheckBox.setChecked(\
            Preferences.getVCS("AutoSaveProject"))
        self.vcsStatusMonitorIntervalSpinBox.setValue(\
            Preferences.getVCS("StatusMonitorInterval"))
        self.vcsMonitorLocalStatusCheckBox.setChecked(\
            Preferences.getVCS("MonitorLocalStatus"))
        
    def save(self):
        """
        Public slot to save the VCS configuration.
        """
        Preferences.setVCS("AutoClose",
            int(self.vcsAutoCloseCheckBox.isChecked()))
        Preferences.setVCS("AutoSaveFiles",
            int(self.vcsAutoSaveCheckBox.isChecked()))
        Preferences.setVCS("AutoSaveProject",
            int(self.vcsAutoSaveProjectCheckBox.isChecked()))
        Preferences.setVCS("StatusMonitorInterval",
            self.vcsStatusMonitorIntervalSpinBox.value())
        Preferences.setVCS("MonitorLocalStatus", 
            int(self.vcsMonitorLocalStatusCheckBox.isChecked()))
    
def create(dlg):
    """
    Module function to create the configuration page.
    
    @param dlg reference to the configuration dialog
    """
    page = VcsPage()
    return page
