"""

This is the main part of ERoaster

"""

# ----------------------------------------------------------------------
# Import functions I need 

from os import environ

if (not environ.has_key("DISPLAY")):              # This happens when started in a console
    raise ImportError, "DISPLAY environment variable not set"

from os import popen, system, unlink
from socket import socket, SOCK_STREAM, AF_INET, error
from string import strip, find, split, lower, rjust, atoi, atof, replace, digits, zfill, join
from sys import exit, argv
from types import StringType
from log4py import Logger
from re import sub, match
from lame import lame
from bchunk import bchunk

import sys
import getopt
import log4py
import cdrtools

sys_argv = sys.argv
sys.argv = [argv[0]]                              # remove all arguments, so gnome_init remains silent

try:
    from gtk import GtkVBox, GtkNotebook, GtkFrame, GtkLabel, GtkHBox, GtkTable
except (RuntimeError, TypeError, NameError), detail:
    cat = Logger().get_instance()
    cat.error("An error occured: %s" % detail)
    exit(1)

from gtk import GtkEntry, GtkCList, GtkScrolledWindow, GtkButton, GtkRadioButton
from gtk import GtkCheckButton, GtkSpinButton, GtkAdjustment, GtkProgressBar, GtkText
from gtk import GtkHScrollbar, GtkVScrollbar, GtkToolbar, GtkStatusbar
from gtk import GtkOptionMenu, GtkMenu, GtkRadioMenuItem, GtkWindow

from gtk import rc_parse, mainloop, mainquit, timeout_add, timeout_remove
from gtk import events_pending, mainiteration

from gtk import SHADOW_ETCHED_OUT, FILL, EXPAND, DEST_DEFAULT_DROP, DEST_DEFAULT_MOTION, SELECTION_EXTENDED
from gtk import JUSTIFY_RIGHT, TRUE, FALSE, POLICY_AUTOMATIC, SHRINK, ORIENTATION_HORIZONTAL
from gtk import TOOLBAR_BOTH, JUSTIFY_LEFT, POLICY_ALWAYS, SHADOW_NONE, SELECTION_SINGLE, TOOLBAR_ICONS

from gnome.ui import GnomeApp, GnomeFileEntry, GnomeErrorDialog, GnomeAbout, GnomeOkDialog, GnomeQuestionDialog
from gnome.ui import STOCK_MENU_QUIT, STOCK_MENU_REDO, STOCK_MENU_UNDO, STOCK_MENU_ABOUT, STOCK_MENU_OPEN, STOCK_MENU_SAVE
from gnome.ui import UIINFO_ITEM_STOCK, UIINFO_SUBTREE, STOCK_MENU_CLOSE, UIINFO_SEPARATOR, STOCK_MENU_NEW
from gnome.ui import DOCK_TOP, DOCK_ITEM_BEH_EXCLUSIVE, GnomeEntry, UIINFO_ITEM, YES, NO

from ConfigParser import ConfigParser
from select import select
from time import sleep, time, asctime, localtime
from tempfile import mktemp

from tools import bool2str, str2bool, striplist, nicetime, du, cmdoutput, TRUE, FALSE
from tools import cleanlist, which, filecopy, mkdirtree, touch, listmatch, rm, escapedfilename

try:
    from gnome.tools import GnomeFileSelection, GnomeProgressBar, GnomePixmap, GnomePixmapWithLabel, GnomePopupQuestionDialog
    from gnome.tools import GnomeOptionMenu
    from gnome.tools import EROASTER_PROJECTS, ALL_FILES, AUDIO_FILES, ISO_IMAGES, XMMS_PLAYLISTS, CUE_SHEETS, BIN_FILES
    from gnome.tools import hex2gdkcolor, get_file_icon, targets
except:
    from gnometools import GnomeFileSelection, GnomeProgressBar, GnomePixmap, GnomePixmapWithLabel, GnomePopupQuestionDialog
    from gnometools import GnomeOptionMenu
    from gnometools import EROASTER_PROJECTS, ALL_FILES, AUDIO_FILES, ISO_IMAGES, XMMS_PLAYLISTS, CUE_SHEETS, BIN_FILES
    from gnometools import hex2gdkcolor, get_file_icon, targets

from constants import title, version, frames, datacd, audiocd, imagecd, options, special, readcd, copycd
from constants import iconpath, deffile, ecat, modeFixateCD, playerFreeAmp, waitreload, eraCDImage
from constants import DataCD, modeDataCDImage, AudioCD, ImageCD, modeCopyCD, modeReadCD, modeReadAudioCD
from constants import socketport, year, deviceRecorder, deviceReader, playerMpg123, playerXMMS
from constants import BlankCDAll, BlankCDMinimal, BlankCDLast, audioinfostring, cdrSize650, cdrSize700
from constants import shortcutfile, systemshortcutfile, configdirectory, eraDataCD, eraAudioCD, eraCopyCD

import GDK
import os
import popen2
import re
import copy
import wave
import mp3info
import cPickle

try:
    import DiscID
    import CDDB
    cddb_available = TRUE
except ImportError:
    cddb_available = FALSE
    cat = Logger().get_instance()
    cat.warn("Python CDDB support not available")

lockfile = "%s/.eroaster.lock" % (os.path.dirname(mktemp()))

# -----------------------------------------------------------------------------
# Project Class

class Project:

    def __init__(self):
        self.Filename = ""
        self.DataFiles = []
        self.DataVolumeID = ""
        self.DataSize = ""
        self.AudioFiles = []
        self.AudioVolumeID = ""
        self.AudioSize = ""
        self.OtherInfo = None
        self.CancelPressed = FALSE
        self.__busy__ = FALSE

    def New(self):
        self.filedialog = GnomeFileSelection(multiselection = FALSE, filetypes = [EROASTER_PROJECTS, ALL_FILES], icondir = iconpath)
        self.filedialog.use_lastdirectory("%s/%s/lastdirectory.project" % (environ["HOME"], configdirectory))
        self.filedialog.load_shortcuts_from_file("%s/%s/%s" % (environ["HOME"], configdirectory, shortcutfile))
        self.filedialog.ok_button.connect("clicked", self.SetNewFilename)
        self.filedialog.close_button.connect("clicked", self.CloseFileDialog)
        self.filedialog.show()
        self.CancelPressed = FALSE
        self.__busy__ = TRUE
        while (self.__busy__ == TRUE):
            while events_pending():
                mainiteration()
            sleep(0.01)

    def SetNewFilename(self, args):
        self.__init__()
        self.Filename = "%s/%s" % (self.filedialog.get_directory(), self.filedialog.get_filenames())
        self.filedialog.destroy()
        self.__busy__ = FALSE

    def CloseFileDialog(self, args):
        self.filedialog.destroy()
        self.CancelPressed = TRUE
        self.__busy__ = FALSE

    def Close(self):
        self.__init__()

    def Clear(self):
        self.__init__()

    def Open(self):
        self.filedialog = GnomeFileSelection(multiselection = FALSE, filetypes = [EROASTER_PROJECTS, ALL_FILES], icondir = iconpath)
        self.filedialog.use_lastdirectory("%s/%s/lastdirectory.project" % (environ["HOME"], configdirectory))
        self.filedialog.load_shortcuts_from_file("%s/%s/%s" % (environ["HOME"], configdirectory, shortcutfile))
        self.filedialog.ok_button.connect("clicked", self.OpenSetFilename)
        self.filedialog.close_button.connect("clicked", self.CloseFileDialog)
        self.filedialog.show()
        self.CancelPressed = FALSE
        self.__busy__ = TRUE
        while (self.__busy__ == TRUE):
            while events_pending():
                mainiteration()
            sleep(0.01)

    def OpenSetFilename(self, args):
        filename = "%s/%s" % (self.filedialog.get_directory(), self.filedialog.get_filenames())
        if ((os.path.isfile(filename)) and (not os.path.islink(filename))):
            self.filedialog.destroy()
            self.Filename = filename
            file = open(self.Filename, "r")
            try:
                pickler = cPickle.Unpickler(file)
                dict = pickler.load()
                self.DataFiles = dict["DataFiles"]
                self.DataVolumeID = dict["DataVolumeID"]
                self.DataSize = dict["DataSize"]
                self.AudioFiles = dict["AudioFiles"]
                self.AudioVolumeID = dict["AudioVolumeID"]
                self.AudioSize = dict["AudioSize"]
                self.OtherInfo = dict["OtherInfo"]
            except:
                GnomeErrorDialog("Invalid ERoaster Project file !")
            file.close()
            self.__busy__ = FALSE

    def Save(self):
        if (self.Filename == ""):
            self.filedialog = GnomeFileSelection(multiselection = FALSE, filetypes = [EROASTER_PROJECTS, ALL_FILES], icondir = iconpath, windowtitle = "Save File")
            self.filedialog.use_lastdirectory("%s/%s/lastdirectory.project" % (environ["HOME"], configdirectory))
            self.filedialog.load_shortcuts_from_file("%s/%s/%s" % (environ["HOME"], configdirectory, shortcutfile))
            self.filedialog.ok_button.connect("clicked", self.SaveProjectWithFileSelection)
            self.filedialog.close_button.connect("clicked", self.filedialog.destroy)
            self.filedialog.show()
        else:
            self.SaveProject()

    def SaveProjectWithFileSelection(self,args):
        self.Filename = "%s/%s" % (self.filedialog.get_directory(), self.filedialog.get_filenames())
        self.filedialog.destroy()
        self.SaveProject()

    def SaveProject(self):
        dict = {}
        dict["DataFiles"] = self.DataFiles
        dict["DataVolumeID"] = self.DataVolumeID
        dict["DataSize"] = self.DataSize
        dict["AudioFiles"] = self.AudioFiles
        dict["AudioVolumeID"] = self.AudioVolumeID
        dict["AudioSize"] = self.AudioSize
        dict["OtherInfo"] = self.OtherInfo
        file = open(self.Filename, "w")
        pickler = cPickle.Pickler(file)
        pickler.dump(dict)
        file.close()

# -----------------------------------------------------------------------------
# Main Object

class Application:

    def __init__(self):

        # Some necessary Variables
        self.parser = ConfigParser()                        # The Configuration File Parser
        self.project = Project()
        self.writermode = None                              # Data CD or Audio CD
        self.InitVariables()
        self.burnwindow = None                              # There's no burn window at the beginning
        self.cat = Logger().get_instance(self)

        self.parsecmdline()

        self.formataudio = re.compile("Track [ \d]+: [ \d]+ of [ \d]+ MB written.$")
        self.formataudiolong = re.compile("Track [ \d]+: [ \d]+ of [ \d]+ MB written \(fifo [ \d]+%\).$")
        self.formatdata = re.compile("Track [ \d]+: [ \d]+ MB written.$")
        self.formatdatalong = re.compile("Track [ \d]+: [ \d]+ MB written. [ \d\.]+% done, estimate finish")
        self.formatdatalongfifo = re.compile("Track [ \d]+: [ \d]+ MB written \(fifo [ \d]+%\). [ \d\.]+% done, estimate finish")
        self.formatdatafifo = re.compile("Track [ \d]+: [ \d]+ MB written \(fifo [ \d]+%\).")
        self.formatignore = re.compile("[\d\.]+% done, estimate|.*\d second")
        self.formatimage = re.compile("[\d\.]+% done, estimate finish")
        self.formatreadimage = re.compile("addr: [ \d]+ cnt: \d+")
        self.formatreadimageend = re.compile("end: [ \d]+")
        self.formatreadaudio = re.compile("[ \d]+%")
        self.formatignorecopy = re.compile("Track [ \d]+: [ \d]+ MB written.addr")
        self.formatreadaudioinfo = re.compile(audioinfostring)

        self.filemenu = [ UIINFO_ITEM_STOCK('New Project', None, self.ProjectNew, STOCK_MENU_NEW),
                          UIINFO_ITEM_STOCK('Open Project', None, self.ProjectOpen, STOCK_MENU_OPEN),
                          UIINFO_ITEM_STOCK('Save Project', None, self.ProjectSave, STOCK_MENU_SAVE),
                          UIINFO_ITEM_STOCK('Close Project', None, self.ProjectClose, STOCK_MENU_CLOSE),
                          UIINFO_SEPARATOR,
                          UIINFO_ITEM_STOCK('Exit', None, self.Destroy, STOCK_MENU_QUIT)]
        self.editmenu = [ UIINFO_ITEM('Select all', None, self.SelectAll),
                          UIINFO_ITEM('Unselect all', None, self.UnSelectAll) ]
        self.helpmenu = [ UIINFO_ITEM_STOCK('About ...', None, self.About, STOCK_MENU_ABOUT),]
        self.menus = [ UIINFO_SUBTREE('File', self.filemenu),
                       UIINFO_SUBTREE('Edit', self.editmenu),
                       UIINFO_SUBTREE('Help', self.helpmenu)]

        # Initialize the window
        self.window = GnomeApp("ERoaster", "%s %s" % (title, version))
        self.window.connect("destroy", self.Destroy)
        self.window.set_border_width(1)

        # Initialize the Main Box
        self.metabox = GtkVBox()
        self.metabox.show()
        self.window.set_contents(self.metabox)

        # Create the menu bar
        self.window.create_menus(self.menus)

        # Create the toolbar
        self.toolbar =  GtkToolbar(ORIENTATION_HORIZONTAL, TOOLBAR_BOTH)
        self.toolbar.append_item("Create Image", "Create Image", "", GnomePixmap(self.window, "%s/createimage.xpm" % iconpath).get_pixmap(), self.CreateImage)
        self.toolbar.append_item("Burn CD", "Burn CD", "", GnomePixmap(self.window, "%s/burn.xpm" % iconpath).get_pixmap(), self.BurnCD)
        self.toolbar.append_space()
        self.toolbar.append_item("Select All", "Select All", "", GnomePixmap(self.window, "%s/select.xpm" % iconpath).get_pixmap(), self.SelectAll)
        self.toolbar.append_item("Unselect All", "Unselect All", "", GnomePixmap(self.window, "%s/unselect.xpm" % iconpath).get_pixmap(), self.UnSelectAll)
        self.toolbar.append_space()
        self.toolbar.append_item("Quit", "Quit ECLiPt Roaster", "", GnomePixmap(self.window, "%s/quit.xpm" % iconpath).get_pixmap(), self.Destroy)
        self.toolbar.show()
        self.window.add_toolbar(self.toolbar, "My Toolbar", DOCK_ITEM_BEH_EXCLUSIVE, DOCK_TOP, 1, 1, 0)

        # Create a status bar
        self.statusbar = GtkStatusbar()
        self.statusbar.show()
        self.window.set_statusbar(self.statusbar)
        self.statusbar.push(self.statusbar.get_context_id("main"), " Welcome to the %s %s (c) %s by Martin Preishuber" % (title, version, year))
        
        # Box which holds the tabs
        self.mainbox = GtkVBox(spacing = 5)
        self.mainbox.set_border_width(5)
        self.metabox.pack_start(self.mainbox)
        self.mainbox.show()

        self.notebook = GtkNotebook()
        self.mainbox.pack_start(self.notebook)
        self.notebook.show()

        self.setstatustip = FALSE
        self.notebook.connect("switch_page", self.ShowStatusbarTips)

        # Create the Frames:
        for i in range(len(frames)):
            self.CreateFrame(frames[i])

        # Define entry fields & stuff which gets set per default
        self.LoadOptions()
        self.handle_startup_files()
        self.setstatustip = TRUE

    def InitVariables(self):
        self.totalaudiosize = 0L                            # Total size of audio tracks
        self.totaltracklength = 0                           # Total length of audio tracks
        self.tracklength = {}                               # Dictionary containing the length of tracks
        self.tracksize = {}                                 # Dictionary containing the size of tracks
        self.datafilesize = {}                              # Dictionary containing the size of data files
        self.totaldatasize = 0L                             # Total size of data files
        self.selecteddatasize = 0L                          # Size of selected data files
        self.nraudiotracks = 0                              # Number of audio tracks

    def handle_startup_files(self):
        if (self.startup_burnmode == eraAudioCD):
            self.notebook.set_page(1)
            for i in range(len(self.startup_burnfiles)):
                self.AddFileToList(self.startup_burnfiles[i])
            self.BurnCD(None)
        elif (self.startup_burnmode == eraDataCD):
            self.notebook.set_page(0)
            for i in range(len(self.startup_burnfiles)):
                self.AddDataFileToList(self.startup_burnfiles[i])
            self.CalculateOptimize(None)
            self.BurnCD(None)
        elif (self.startup_burnmode == eraCopyCD):
            self.notebook.set_page(4)
            self.BurnCD(None)
        elif (self.startup_burnmode == eraCDImage):
            self.notebook.set_page(2)
            self.cdimage.gtk_entry().set_text(self.startup_burnfiles[0])
            self.ImageInfo(None)
            self.BurnCD(None)
            # self.window.show()
        else:
            self.window.show()

    def ProjectNew(self, args):
        self.project.New()
        if (self.project.CancelPressed == FALSE):
            self.ClearLists()

    def ProjectOpen(self, args):
        self.project.Open()
        if (self.project.CancelPressed == FALSE):
            self.ClearLists()
            self.volumeidaudio.set_text(self.project.AudioVolumeID)
            self.volumeid.set_text(self.project.DataVolumeID)
            self.songlist.freeze()
            for i in range(len(self.project.AudioFiles)):
                self.songlist.append(self.project.AudioFiles[i])
                self.songlist.set_pixmap(i, 0, get_file_icon(self.project.AudioFiles[i][2], self.window, iconpath))
            self.ColorizeCList(self.songlist)
            self.songlist.thaw()
            self.datafiles.freeze()
            for i in range(len(self.project.DataFiles)):
                self.datafiles.append(self.project.DataFiles[i])
                self.datafiles.set_pixmap(i, 0, get_file_icon(self.project.DataFiles[i][1], self.window, iconpath))
            self.ColorizeCList(self.datafiles)
            self.datafiles.thaw()
            self.audiosize.set_text(self.project.AudioSize)
            self.datasize.set_text(self.project.DataSize)
            self.totalaudiosize, self.totaltracklength, self.tracklength, self.tracksize, self.datafilesize, self.totaldatasize, self.nraudiotracks = self.project.OtherInfo

    def ProjectClose(self, args):
        self.project.Close()
        self.ClearLists()

    def ProjectSave(self, args):
        self.project.Clear()
        self.project.AudioVolumeID = self.volumeidaudio.get_text()
        self.project.DataVolumeID = self.volumeid.get_text()
        self.project.AudioSize = self.audiosize.get_text()
        self.project.DataSize = self.datasize.get_text()
        self.project.OtherInfo = (self.totalaudiosize, self.totaltracklength, self.tracklength,
                                  self.tracksize, self.datafilesize, self.totaldatasize, self.nraudiotracks)
        for i in range(self.datafiles.rows):
            name, size, mdtm = (self.datafiles.get_text(i, 1), self.datafiles.get_text(i, 2), self.datafiles.get_text(i, 3))
            self.project.DataFiles.append(["", name, size, mdtm])
        for i in range(self.songlist.rows):
            number, name, length = (self.songlist.get_text(i, 1), self.songlist.get_text(i, 2), self.songlist.get_text(i, 3))
            self.project.AudioFiles.append(["", number, name, length])
        self.project.Save()

    def ClearLists(self):
        self.songlist.clear()
        self.volumeidaudio.set_text("")
        self.datafiles.clear()
        self.volumeid.set_text("")
        self.audiosize.set_text("00:00")
        self.datasize.set_text("0 MB")
        self.datasizesel.set_text("0 MB")
        self.InitVariables()

    # Set tips in the status bar
    def ShowStatusbarTips(self, notebook, object, index):
        if (self.setstatustip == TRUE):
            if (index == 0):
                message = "Drag & drop some files to the \"Files / Directories\"-list and click AutoSelect"
            elif (index == 1):
                message = "Drag & drop wave-, mp3- or ogg-files to the list and order it via Drag & Drop"
            elif (index == 2):
                message = "Select an image and click on \"Image info\" for checking"
            elif (index == 3):
                message = "Read the a CD image"
            elif (index == 4):
                message = "Copy a CD"
            elif (index == 5):
                message = "Perform special operations on CDs"
            elif (index == 6):
                message = "Set the general preferences"

            self.statusbar.push(self.statusbar.get_context_id("main"), " %s" % message)

    # Define a About Box
    def About(self, args):
        description = 'ERoaster is a GNOME frontend for writing, copying and grabbing data and audio CDs using cdrecord, mkisofs and some other tools.'
        description = "%s\nAvailable from:\n     http://www.eclipt.at\n     http://www.its4you.at\n     http://eroaster.sourceforge.net" % description
        description = "%s\nSend comments, bug reports or any other to the e-mail address above." % description
        GnomeAbout(title, version, 'May be distributed under the terms of the GPL2', ['Martin Preishuber (Martin.Preishuber@eclipt.at)'], description).show()

    # Create the various frames
    def CreateFrame(self, name):

        frame = GtkFrame(name)
        frame.set_border_width(5)
        frame.set_shadow_type(SHADOW_ETCHED_OUT)
        frame.show()

        if (name == datacd):
            box = GnomePixmapWithLabel(self.window, "%s/master.xpm" % iconpath, name).get_hbox()
            self.BurnData(frame)
        elif (name == audiocd):
            box = GnomePixmapWithLabel(self.window, "%s/audio.xpm" % iconpath, name).get_hbox()
            self.BurnAudio(frame)
        elif (name == imagecd):
            box = GnomePixmapWithLabel(self.window, "%s/iso.xpm" % iconpath, name).get_hbox()
            self.BurnImage(frame)
        elif (name == readcd):
            box = GnomePixmapWithLabel(self.window, "%s/read.xpm" % iconpath, name).get_hbox()
            self.ReadCDFrame(frame)
        elif (name == copycd):
            box = GnomePixmapWithLabel(self.window, "%s/copy.xpm" % iconpath, name).get_hbox()
            self.CopyCDFrame(frame)
        elif (name == special):
            box = GnomePixmapWithLabel(self.window, "%s/iso.xpm" % iconpath, name).get_hbox()
            self.SpecialOperation(frame)
        elif (name == options):
            box = GnomePixmapWithLabel(self.window, "%s/options.xpm" % iconpath, name).get_hbox()
            self.Options(frame)

        self.notebook.append_page(frame, box)

    # Burn CD (menu entry)
    def BurnCD(self, args):
        if (self.burnwindow != None):
            GnomeErrorDialog("Close the output window first !")
            return FALSE
        page = self.notebook.get_current_page()

        if ((frames[page] == options) or (frames[page] == readcd) or (frames[page] == special)):
            GnomeErrorDialog("You can't burn a CD at this point !")
            return FALSE

        result = TRUE

        if (frames[page] == datacd):
            self.writermode = DataCD
            if (len(self.datafiles.selection)) == 0:
                GnomeErrorDialog("You have to select files & directories first.")
                return FALSE

            selectedsize = atoi(self.datasizesel.get_text()[:-3])
            if (self.cdsize650.active):
                cdsize = 650
            elif (self.cdsize700.active):
                cdsize = 700

            if (selectedsize > cdsize):
                gnomequestiondialog = GnomePopupQuestionDialog("Warning: You selected %s MB which is larger then your selected CD size (%s MB).\nAre you sure you want to continue ?" % (selectedsize, cdsize))
                result = gnomequestiondialog.get_result()

        elif (frames[page] == audiocd):
            self.writermode = AudioCD
            if (self.songlist.rows == 0):
                GnomeErrorDialog("You have to select some audio files first.")
                return FALSE

        elif (frames[page] == imagecd):
            self.writermode = ImageCD
        elif (frames[page] == copycd):
            self.writermode = modeCopyCD

        if (result == TRUE):
            self.SelectWritingOptions()

    # --------------------------------------------------------------------------
    # Open a window asking some questions about the CD creation
    def SelectWritingOptions(self):

        self.woptwindow = GnomeApp("ERoasterOptions", "CD-R/RW Options")
        self.woptwindow.set_border_width(1)
        self.woptwindow.show()

        vbox = GtkVBox(spacing = 3)
        vbox.set_border_width(0)
        vbox.show()

        infoframe = GtkFrame(" Summary ")
        infoframe.set_border_width(3)
        infoframe.set_shadow_type(SHADOW_ETCHED_OUT)
        infoframe.show()

        infotable = GtkTable(3,2)
        modeLabel = GtkLabel("Mode: ")
        modeLabel.set_alignment(1.0, 0.5)
        modeLabel.show()
        if (self.dummy.active):
            currentMode = GtkLabel("%s (Dummy Mode)" % self.writermode)
        else:
            currentMode = GtkLabel(self.writermode)
        currentMode.set_alignment(0.0, 0.5)
        currentMode.show()
        speedLabel = GtkLabel("Speed: ")
        speedLabel.set_alignment(1.0, 0.5)
        speedLabel.show()
        speeds = GtkLabel("%dx (CD-W) %dx (CD-RW)" % (self.speed.get_value_as_int(), self.speedRW.get_value_as_int()))
        speeds.set_alignment(0.0, 0.5)
        speeds.show()

        volumeIDLabel = GtkLabel("CD Info: ")
        volumeIDLabel.set_alignment(1.0, 0.5)
        volumeIDLabel.show()

        volumeID = ""
        discSize = ""

        if (self.writermode == DataCD):
            volumeID = self.volumeid.get_text()
            discSize = self.datasizesel.get_text()
        elif (self.writermode == AudioCD):
            volumeID = self.volumeidaudio.get_text()
            discSize = self.audiosize.get_text()
        elif (self.writermode == ImageCD):
            if (self.volidtext.get_text() != ""):
                volumeID = self.volidtext.get_text()
            else:
                volumeID = "<unknown>"
            if (self.volsizetext.get_text != ""):
                if (self.volsizetext.get_text() != ""):
                    discSize = (atoi(self.volsizetext.get_text()) * 2) / 1024
                    discSize = "%d MB" % discSize
        else:
            volumeID = "<unknown>"

        if (volumeID == ""):
            volumeID = "<none>"
        if (discSize == ""):
            discSize = "<unknown>"

        discInfo = GtkLabel("%s (%s)" % (volumeID, discSize))
        discInfo.set_alignment(0.0, 0.5)
        discInfo.show()

        infotable.attach(modeLabel, 0, 1, 0, 1, FILL, 0, 5)
        infotable.attach(currentMode, 1, 2, 0, 1, FILL, 0, 5)
        infotable.attach(speedLabel, 0, 1, 1, 2, FILL, 0, 5)
        infotable.attach(speeds, 1, 2, 1, 2, FILL, 0, 5)
        infotable.attach(volumeIDLabel, 0, 1, 2, 3, FILL, 0, 5)
        infotable.attach(discInfo, 1, 2, 2, 3, FILL, 0, 5)
        infotable.show()
        infoframe.add(infotable)

        woptframe = GtkFrame(" Settings ")
        woptframe.set_border_width(3)
        woptframe.set_shadow_type(SHADOW_ETCHED_OUT)

        self.formatCDR = GtkRadioButton(None, "CD-R")
        self.formatCDR.show()
        self.formatCDRW = GtkRadioButton(self.formatCDR, "CD-RW")
        self.formatCDRW.show()
        if (self.tw_mode == 0):
            self.formatCDR.set_active(1)
        elif (self.tw_mode == 1):
            self.formatCDRW.set_active(1)

        self.fixate = GtkCheckButton("fixate CD when done")
        self.fixate.set_active(self.tw_fixate)
        if (self.writermode == modeCopyCD):
            self.fixate.set_sensitive(FALSE)
        else:
            self.fixate.set_sensitive(TRUE)            
        self.fixate.show()

        self.multisession = GtkCheckButton("multisession CD")
        self.multisession.set_active(self.tw_multisession)
        if (self.writermode == modeCopyCD):
            self.multisession.set_sensitive(FALSE)
        else:
            self.multisession.set_sensitive(TRUE)
        self.multisession.show()

        wopttable = GtkTable(2, 3)
        wopttable.attach(self.formatCDR, 0, 1, 0, 1, 0, 0, 5)
        wopttable.attach(self.formatCDRW, 1, 2, 0, 1, 0, 0, 5)
        wopttable.attach(self.fixate, 0, 2, 1, 2, FILL, 0, 5)
        wopttable.attach(self.multisession, 2, 3, 1, 2, FILL, 0, 5)
        wopttable.show()

        woptframe.add(wopttable)
        woptframe.show()

        goBtn = GtkButton(" Burn ")
        goBtn.set_usize(75, -1)
        goBtn.connect('clicked', self.BurnWriterOptions)
        goBtn.show()
        cancelBtn = GtkButton(" Close ")
        cancelBtn.set_usize(75, -1)
        cancelBtn.connect('clicked', self.CloseWriterOptions)
        cancelBtn.show()

        labLeft = GtkLabel()
        labLeft.show()

        buttontab = GtkTable(1, 4)
        buttontab.attach(labLeft, 0, 1, 0, 1, EXPAND, 0, 5, 5)
        buttontab.attach(goBtn, 1, 2, 0, 1, 0, 0, 5, 5)
        buttontab.attach(cancelBtn, 2, 3, 0, 1, 0, 0, 5, 5)
        buttontab.show()

        vbox.pack_start(infoframe, expand = FALSE)
        vbox.pack_start(woptframe, expand = FALSE)
        vbox.pack_start(buttontab)

        self.woptwindow.set_contents(vbox)

    # Close the writer options window and start burnin'
    def BurnWriterOptions(self, args):
        if (self.formatCDR.active):
            self.tw_mode = 0
        elif (self.formatCDRW.active):
            self.tw_mode = 1
        self.tw_fixate = self.fixate.active
        self.tw_multisession = self.multisession.active
        self.woptwindow.destroy()
        self.woptwindow = None

        successfull = TRUE

        if (frames[self.notebook.get_current_page()] == audiocd):
            successfull = self.ConvertMp3ToWav()
            if (successfull):
                successfull = self.Normalize()

        if (successfull):
            self.BurnCDNow()

    # Close the writer options window
    def CloseWriterOptions(self, args):
        self.woptwindow.destroy()
        self.woptwindow = None
        if (self.startup_burnmode != None):
            self.Destroy(None)

    # --------------------------------------------------------------------------
    # Create Image (menu entry)

    def CreateImage(self, args):
        if (self.imageentry.gtk_entry().get_text() == ""):
            GnomeErrorDialog("Please select a image path in the preferences tab first !")
            return
        if (not os.path.isdir(self.imageentry.gtk_entry().get_text())):
            GnomeErrorDialog("Error: \"%s\" is not a valid directory !" % self.imageentry.gtk_entry().get_text())
            return
        if (self.burnwindow != None):
            GnomeErrorDialog("Close the output window first !")
            return
        page = self.notebook.get_current_page()
        if (frames[page] == datacd):
            self.writermode = modeDataCDImage
        elif (frames[page] == imagecd) or (frames[page] == audiocd) or (frames[page] == options) or (frames[page] == readcd) or (frames[page] == special) or (frames[page] == copycd):
            GnomeErrorDialog("You can't create any image at this point !")
            return

        if (len(self.datafiles.selection)) == 0:
            GnomeErrorDialog("You have to select files & directories first.")
            return

        self.filenamewindow = GnomeApp("ERoasterFileName", "Enter Filename")
        self.filenamewindow.set_border_width(1)
        self.filenamewindow.show()

        vbox = GtkVBox(spacing = 5)
        vbox.set_border_width(0)
        vbox.show()

        fileframe = GtkFrame(" Filename ")
        fileframe.set_border_width(5)
        fileframe.set_shadow_type(SHADOW_ETCHED_OUT)
        fileframe.show()

        fileLabel = GtkLabel("Filename: ")
        fileLabel.show()

        self.imagefilename = GnomeFileEntry("imagename")
        self.imagefilename.set_usize(350, -1)
        self.imagefilename.show()

        if (self.volumeid.get_text() != ""):
            isofilename = self.volumeid.get_text()
        else:
            isofilename = "ECLiPt Roaster - %s" % asctime(localtime(time()))

        imagepath = self.imageentry.gtk_entry().get_text()
        if imagepath[-1] == "/":
            isofilename = "%s%s.iso" % (imagepath, isofilename)
        else:
            isofilename = "%s/%s.iso" % (imagepath, isofilename)

        self.imagefilename.gtk_entry().set_text(isofilename)

        filetab = GtkTable(1, 2)
        filetab.attach(fileLabel, 0, 1, 0, 1, 0, 0, 5, 5)
        filetab.attach(self.imagefilename, 1, 2, 0, 1, 0, 0, 5, 5)
        filetab.show()

        okBtn = GtkButton()
        box = GnomePixmapWithLabel(self.window, "%s/ok.xpm" % iconpath, " OK ").get_hbox()
        okBtn.add(box)
        okBtn.connect('clicked', self.CreateImageOK)
        okBtn.show()
        cancelBtn = GtkButton()
        box = GnomePixmapWithLabel(self.window, "%s/cancel.xpm" % iconpath, " Cancel ").get_hbox()
        cancelBtn.add(box)
        cancelBtn.connect('clicked', self.CreateImageCancel)
        cancelBtn.show()

        labLeft = GtkLabel()
        labLeft.show()
        labRight = GtkLabel()
        labRight.show()

        buttontab = GtkTable(1, 4)
        buttontab.attach(labLeft, 0, 1, 0, 1, EXPAND, 0, 5, 5)
        buttontab.attach(okBtn, 1, 2, 0, 1, 0, 0, 5, 5)
        buttontab.attach(cancelBtn, 2, 3, 0, 1, 0, 0, 5, 5)
        buttontab.attach(labRight, 3, 4, 0, 1, EXPAND, 0, 5, 5)
        buttontab.show()

        fileframe.add(filetab)

        vbox.pack_start(fileframe, expand = FALSE)
        vbox.pack_start(buttontab)

        self.filenamewindow.set_contents(vbox)
                        
    # Create the CD Image (OK button pressed)
    def CreateImageOK(self, args):
        self.fileNameCDImage = self.imagefilename.gtk_entry().get_text()
        self.filenamewindow.destroy()
        self.filenamewindow = None
        self.BurnCDNow()

    # Create the CD Image (Cancel button pressed)
    def CreateImageCancel(self, args):
        self.filenamewindow.destroy()
        self.filenamewindow = None

    # Burn Image
    def BurnImageNow(self, args):
        if (self.burnwindow != None):
            GnomeErrorDialog("Close the output window first !")
            return

        self.writermode = ImageCD
        self.BurnCDNow()

    # Burn CD depending of which type
    def BurnCDNow(self):

        if (self.tw_mode == 0):
            speed = self.speed.get_value_as_int()
        else:
            speed = self.speedRW.get_value_as_int()

        channel = self.channel.get_text()
        id = self.id.get_text()
        lun = self.lun.get_text()

        if (channel == "") or (id == "") or (lun == ""):
            GnomeErrorDialog("Invalid recorder settings !")
            return FALSE

        cdrecord = cdrtools.cdrecord(channel, id, lun, self.devWriter.get_text())
        if (self.writermode == DataCD) or (self.writermode == modeDataCDImage):

            mkisofs = cdrtools.mkisofs()
            mkisofs.gui_behaviour(TRUE)
            mkisofs.verbose_mode(TRUE)
            mkisofs.disable_deep_relocation(self.diralloc.active)
            mkisofs.full_iso9660_filenames(self.fullchar.active)
            mkisofs.allow_leading_dots(self.allowdots.active)
            mkisofs.follow_links(self.followlinks.active)
            if (self.joliet.active): mkisofs.joliet_charset(self.jolietCharSets.get_active_item())
            if (self.tw_multisession == TRUE):
                previous_session = cdrecord.previous_session()
                mkisofs.multi_session(previous_session, cdrecord.device())
            mkisofs.rational_rock(self.ratrock.active)
            if (self.rockridge.active) or (self.tw_multisession == TRUE): mkisofs.rock_ridge(TRUE)
            mkisofs.omit_trailing_periods(self.periods.active)
            mkisofs.volume_id(self.volumeid.get_text())
            if (self.writermode == modeDataCDImage):
                mkisofs.output_file(self.fileNameCDImage)
            if (self.makebootable.active):
                mkisofs.boot_catalog(self.bootcatalog.get_text())
                mkisofs.boot_image(self.bootimage.get_text())
            for i in range(len(self.datafiles.selection)):
                filename = self.datafiles.get_text(self.datafiles.selection[i], 1)
                mkisofs.add_file(filename)

            if (self.writermode == DataCD):
                cdrecord.verbose_mode(TRUE)
                cdrecord.burnfree(self.burnproof.active)
                cdrecord.overburn(self.overburn.active)
                cdrecord.fixate(self.tw_fixate)
                cdrecord.multisession(self.tw_multisession)
                cdrecord.dummy_mode(self.dummy.active)
                cdrecord.eject(self.eject.active)
                cdrecord.fifosize(self.fifosize.get_value_as_int() * 1024 * 1024)
                cdrecord.speed(speed)
                cdrecord.pad_tracks(TRUE)
                cdrecord.track_mode(cdrtools.TRACK_MODE_DATA)
                cdrecord.add_track(cdrtools.TRACK_STDIN)
                command = "(%s | %s) 2>&1 | %s" % (mkisofs.command_line(), cdrecord.command_line(), ecat)
            elif (self.writermode == modeDataCDImage):
                command = "%s 2>&1 | %s" % (mkisofs.command_line, ecat)

        elif (self.writermode == AudioCD):

            cdrecord.verbose_mode(TRUE)
            cdrecord.track_mode(cdrtools.TRACK_MODE_AUDIO)
            cdrecord.burnfree(self.burnproof.active)
            if (self.dao.active): cdrecord.write_mode(cdrtools.WRITE_MODE_DAO)
            cdrecord.fixate(self.tw_fixate)
            cdrecord.multisession(self.tw_multisession)
            cdrecord.dummy_mode(self.dummy.active)
            cdrecord.eject(self.eject.active)
            cdrecord.fifosize(self.fifosize.get_value_as_int() * 1024 * 1024)
            cdrecord.speed(speed)
            cdrecord.swap_audio_tracks(self.swab.active)
            cdrecord.pad_tracks(self.pad.active)

            line = 0
            try:
                filename = self.songlist.get_text(line, 2)
            except:
                filename = None
            while (filename != None):
                cdrecord.add_track(escapedfilename(filename))
                self.nraudiotracks = line + 1                                   # Numbers don't start at 0 !
                line = line + 1
                try:
                    filename = self.songlist.get_text(line, 2)
                except:
                    filename = None
            command = "%s 2>&1 | %s" % (cdrecord.command_line(), ecat)

        elif (self.writermode == ImageCD):

            image = self.cdimage.gtk_entry().get_text()
            if (image == "") or (os.path.isdir(image)):
                GnomeErrorDialog("The image file \"%s\" is not valid." % image)
                return

            cdrecord.verbose_mode(TRUE)
            cdrecord.burnfree(self.burnproof.active)
            cdrecord.overburn(self.overburn.active)
            cdrecord.fixate(self.tw_fixate)
            cdrecord.multisession(self.tw_multisession)
            cdrecord.dummy_mode(self.dummy.active)
            cdrecord.eject(self.eject.active)
            cdrecord.fifosize(self.fifosize.get_value_as_int() * 1024 * 1024)
            cdrecord.speed(speed)
            cdrecord.add_track(image)
            command = "%s 2>&1 | %s" % (cdrecord.command_line(), ecat)

        elif (self.writermode == modeCopyCD):
            read_cd = cdrtools.readcd(self.channelReader.get_text(), self.idReader.get_text(), self.lunReader.get_text())
            read_cd.filename = "/dev/stdout"
            cdrecord.verbose_mode(TRUE)
            cdrecord.burnfree(self.burnproof.active)
            cdrecord.dummy_mode(self.dummy.active)
            cdrecord.eject(self.eject.active)
            cdrecord.fifosize(self.fifosize.get_value_as_int() * 1024 * 1024)
            cdrecord.speed(speed)
            cdrecord.pad_tracks(TRUE)
            cdrecord.track_mode(cdrtools.TRACK_MODE_DATA)
            cdrecord.add_track(cdrtools.TRACK_STDIN)
            command = "(%s | %s) 2>&1 | %s" % (read_cd.command_line(), cdrecord.command_line(), ecat)

        elif (self.writermode == BlankCDAll) or (self.writermode == BlankCDMinimal) or (self.writermode == BlankCDLast):

            speed = self.speedRW.get_value_as_int()
            cdrecord.verbose_mode(TRUE)
            if (self.writermode == BlankCDAll):
                cdrecord.blank_mode(cdrtools.BLANK_MODE_DISC)
            elif (self.writermode == BlankCDMinimal):
                cdrecord.blank_mode(cdrtools.BLANK_MODE_FAST)
            elif (self.writermode == BlankCDLast):
                cdrecord.blank_mode(cdrtools.BLANK_MODE_SESSION)
            cdrecord.burnfree(self.burnproof.active)
            cdrecord.dummy_mode(self.dummy.active)
            cdrecord.eject(self.eject.active)
            cdrecord.fifosize(self.fifosize.get_value_as_int() * 1024 * 1024)
            cdrecord.speed(speed)
            command = "%s 2>&1 | %s" % (cdrecord.command_line(), ecat)

        elif (self.writermode == modeFixateCD):

            speed = self.speedRW.get_value_as_int()

            command = "cdrecord -v"
            # FIXME: if (self.burnproof.active): command = "%s %s" % (command, cdrecord.burnfree())
            if (self.dummy.active): command = "%s -dummy" % command
            if (self.eject.active): command = "%s -eject" % command
            command = "%s fs=%d" % (command, self.fifosize.get_value_as_int() * 1024 * 1024)
            command = "%s dev=%s,%s,%s speed=%s -fix 2>&1 | %s" % (command, channel, id, lun, speed, ecat)

        self.cat.debug("Executing: %s" % command)
        self.BurnWindow(command)

    # Open a new window which contains the cdrecord & mkisofs output
    def BurnWindow(self, command):

        self.burnwindow = GnomeApp("ERoasterOutput", "%s Output" % title)
        self.burnwindow.connect("delete_event", self.BurnWindowDontKill)
        self.burnwindow.connect("destroy", self.BurnWindowDontKill)
        self.burnwindow.set_border_width(1)

        self.burnbox = GtkVBox(spacing = 5)
        self.burnbox.set_border_width(5)
        self.burnbox.show()

        # Create a frame containing tracknumber & progress bar
        frame = GtkFrame(label = " Progress Bar ")
        frame.set_border_width(3)
        frame.set_shadow_type(SHADOW_ETCHED_OUT)
        frame.show()

        table = GtkTable(1, 7)

        label = GtkLabel("Track#:")
        label.show()

        self.track = GtkEntry()
        self.track.set_usize(55, -1)
        self.track.set_editable(FALSE)
        self.track.show()

        self.progressbar = GtkProgressBar()
        self.progressbar.set_usize(180, -1)
        self.progressbar.set_format_string("")
        self.progressbar.set_show_text(TRUE)
        self.progressbar.show()

        fifolabel = GtkLabel("FIFO:")
        fifolabel.show()

        self.fifo = GtkEntry()
        self.fifo.set_usize(40, -1)
        self.fifo.set_editable(FALSE)
        self.fifo.show()

        donelabel = GtkLabel("Done:")
        donelabel.show()

        self.estimate = GtkEntry()
        self.estimate.set_usize(160, -1)
        self.estimate.set_editable(FALSE)
        self.estimate.set_text("(not estimated)")
        self.estimate.show()

        table.attach(label, 0, 1, 0, 1, 0, 0, 5, 5)
        table.attach(self.track, 1, 2, 0, 1, 0, 0, 5, 5)
        table.attach(self.progressbar, 2, 3, 0, 1, 0, 0, 5, 5)
        table.attach(fifolabel, 3, 4, 0, 1, 0, 0, 5, 5)
        table.attach(self.fifo, 4, 5, 0, 1, 0, 0, 5, 5)
        table.attach(donelabel, 5, 6, 0, 1, 0, 0, 5, 5)
        table.attach(self.estimate, 6, 7, 0, 1, 0, 0, 5, 5)

        table.show()

        frame.add(table)

        self.burnbox.pack_start(frame, expand = FALSE)

        # Creata frame containing the rest of the output
        outputframe = GtkFrame(label = " CDRecord & MkIsoFS Output ")
        outputframe.set_border_width(3)
        outputframe.set_shadow_type(SHADOW_ETCHED_OUT)
        outputframe.show()

        table = GtkTable(2, 2)
        table.set_border_width(10)
        table.set_row_spacing(0, 2)
        table.set_col_spacing(0, 2)
        table.show()

        outputframe.add(table)

        self.cdtext = GtkText()
        self.cdtext.set_usize(585, 250)
        self.cdtext.set_editable(FALSE)
        self.cdtext.set_word_wrap(FALSE)
        table.attach(self.cdtext, 0, 1, 0, 1, 0, 0)
        self.cdtext.show()

        hscrollbar = GtkHScrollbar(self.cdtext.get_hadjustment())
        table.attach(hscrollbar, 0, 1, 1, 2, FILL, 0)
        hscrollbar.show()

        vscrollbar = GtkVScrollbar(self.cdtext.get_vadjustment())
        table.attach(vscrollbar, 1, 2, 0, 1, 0, FILL)
        vscrollbar.show()

        self.burnbox.pack_start(outputframe)

        # Insert a table with one button to close the window
        closeframe = GtkFrame()
        closeframe.set_border_width(3)
        closeframe.set_shadow_type(SHADOW_ETCHED_OUT)
        closeframe.show()

        buttontab = GtkTable(1, 3)

        dummylabel = GtkLabel()
        dummylabel.show()
        buttontab.attach(dummylabel, 0, 1, 0, 1, FILL|EXPAND, 0, 5)

        self.closebutton = GtkButton()
        self.closebox = GnomePixmapWithLabel(self.window, "%s/close.xpm" % iconpath, " Close Window ").get_hbox()
        self.closebutton.add(self.closebox)
        self.closebutton.set_sensitive(FALSE)
        self.closebutton.show()
        buttontab.attach(self.closebutton, 1, 2, 0, 1, 0, 0, 0, 5)

        dummylabel = GtkLabel()
        dummylabel.show()
        buttontab.attach(dummylabel, 2, 3, 0, 1, FILL|EXPAND, 0, 5)

        buttontab.show()

        closeframe.add(buttontab)

        self.burnbox.pack_start(closeframe, expand = FALSE)

        self.burnwindow.set_contents(self.burnbox)
        self.burnwindow.show()

        imagepath = self.imageentry.gtk_entry().get_text()

        self.pid = os.fork()
        if (self.pid == 0):
            connected = FALSE
            while (connected == FALSE):
                try:
                    self.client = socket(AF_INET, SOCK_STREAM)
                    self.client.connect(("127.0.0.1", socketport))
                    connected = TRUE
                except error:
                    sleep(0.1)
            sys.stderr = sys.stdout
            if (self.writermode == modeReadAudioCD):
                fileList = []
                for i in range(len(self.audiotracklist)):
                    if self.audiotracklist[i].active:
                        fileList.append(i + 1)
            else:
                fileList = ["dummy"]

            originalCommand = command
            for i in range(len(fileList)):
                command = originalCommand
                if (self.writermode == modeReadAudioCD):
                    if (self.cddb_info.has_key(fileList[i])):
                        cdtitle = sub("\/", r"\\", self.cddb_title.get_text())
                        if (cdtitle == ""):
                            trackname = self.cddb_info[fileList[i]]
                        else:
                            trackname = "%s - %s" % (cdtitle, self.cddb_info[fileList[i]])
                        trackname = sub("\/", r"\\", trackname)
                        trackname = sub("\"", "'", trackname)
                        command = sub("Track-%d", "%s. %s" % (zfill(fileList[i], 2), trackname), command)
                        fullcommand = command % (fileList[i], fileList[i], imagepath)
                    else:
                        fullcommand = command % (fileList[i], fileList[i], imagepath, fileList[i])
                    self.cat.debug("Executing %s" % fullcommand)
                    pipe = popen2.popen2(fullcommand)
                    fileString = "%s %d of %d\n" % (audioinfostring, i + 1, len(fileList))
                    self.client.send(rjust(str(len(fileString)), 4))
                    self.client.send(fileString)
                else:
                    self.cat.debug("Executing %s" % command)
                    pipe = popen2.popen2(command)
                line = None
                sendreturn = FALSE
                while (line != ""):
                    line = pipe[0].readline()
                    if (sendreturn == TRUE):          # ignore the empty line resulting from the <CR>
                        line = None
                    sendreturn = FALSE
                    if (line != "") and (line != None):
                        if (find(line, "Re-load disk and hit <CR>") != -1):
                            sendreturn = TRUE
                        self.client.send(rjust(str(len(line)), 4))
                        self.client.send(line)
                        if (sendreturn == TRUE):
                            saveline = line
                            sleep(0.5)
                            while (os.path.exists(lockfile)):
                                sleep(0.25)
                            pipe[1].write("\n")
                            pipe[1].flush()
                pipe[0].close()
                pipe[1].close()
                pipe = None
            self.client.close()
            os._exit(0)
        else:
            self.server = socket(AF_INET, SOCK_STREAM)
            self.server.bind(("127.0.0.1", socketport))
            self.server.listen(1)
            self.connection, self.address = self.server.accept()

        self.delhandler = timeout_add(250, self.TimeOutHandler)

    # Handler to check the pipe output
    def TimeOutHandler(self):
        while 1:
            [iwtd, owtd, ewtd] = select([self.connection], [], [], 0)
            if (len(iwtd) == 0):
                return TRUE
            else:
                packet = self.connection.recv(4)
                if (packet == ""):
                    self.closebutton.set_sensitive(TRUE)
                    self.closebutton.connect("pressed", self.BurnWindowDestroy)
                    timeout_remove(self.delhandler)
                    return TRUE
                length = atoi(packet)
                packet = self.connection.recv(length)
                if (not packet): return FALSE
                splitted = split(packet, "\n")
                for i in range(len(splitted)):
                    line = strip(splitted[i])
                    if (line != ""):

                        if (find(line, "Re-load disk and hit <CR>") != -1):
                            touch(lockfile)
                            cmdoutput(waitreload)
                            unlink(lockfile)

                        # Format lines for writing audio CDs
                        elif (self.writermode == AudioCD):

                            if self.formataudio.match(line):
                                self.track.set_text("%s of %s" % (str(atoi(line[6:8])), str(self.nraudiotracks)))
                                formatstr = "%s of %sMB (Total %d MB)" % (strip(line[10:13]), strip(line[17:20]), round(float(self.totalaudiosize) / (1024 * 1024)))
                                if (atof(line[10:13]) <= atof(line[17:20])):
                                    self.progressbar.set_format_string(formatstr)
                                    if atof(line[17:20]) > 0:
                                        self.progressbar.update(atof(line[10:13]) / atof(line[17:20]))
                            elif self.formataudiolong.match(line):
                                self.track.set_text("%s of %s" % (str(atoi(line[6:8])), str(self.nraudiotracks)))
                                formatstr = "%s of %sMB (Total %d MB)" % (strip(line[10:13]), strip(line[17:20]), round(float(self.totalaudiosize) / (1024 * 1024)))
                                if (atof(line[10:13]) <= atof(line[17:20])):
                                    self.progressbar.set_format_string(formatstr)
                                    if atof(line[17:20]) > 0:
                                        self.progressbar.update(atof(line[10:13]) / atof(line[17:20]))
                                self.fifo.set_text("%s%%" % strip(line[38:41]))
                            elif (not self.formatignore.match(line)):
                                self.cdtext.insert_defaults("%s\n" % line)

                        # Format lines for reading CDs
                        elif (self.writermode == modeReadCD):

                            if self.formatreadimage.match(line):
                                cursize = atoi(strip(line[6:14])) * 2
                                formatstr = "%p%% (" + str(cursize / 1024) + " of " + str(self.tmpimagesize / 1024) + "MB)"
                                self.progressbar.set_format_string(formatstr)
                                if (float(self.tmpimagesize) / 1024) > 0:
                                    self.progressbar.update((float(cursize) / 1024) / (float(self.tmpimagesize) / 1024))
                            elif self.formatreadimageend.match(line):
                                self.tmpimagesize = atoi(strip(line[5:])) * 2
                                formatstr = "%p%% (0 of " + str(self.tmpimagesize / 1024) + "MB)"
                                self.progressbar.set_format_string(formatstr)
                            elif (not self.formatignore.match(line)):
                                self.cdtext.insert_defaults("%s\n" % line)

                        # Format lines for reading audio CDs
                        elif (self.writermode == modeReadAudioCD):

                            if self.formatreadaudio.match(line):
                                percent = atof(line[:find(line, "%")])
                                formatstr = "%p%% (File " + self.filenumber + ")"
                                self.progressbar.set_format_string(formatstr)
                                self.progressbar.update(percent / 100)
                            elif self.formatreadaudioinfo.match(line):
                                self.filenumber = line[len(audioinfostring) + 1:]
                            elif (not self.formatignore.match(line)):
                                self.cdtext.insert_defaults("%s\n" % line)

                        # Format lines for writing data CDs
                        elif (self.writermode == DataCD):

                            if self.formatdata.match(line):
                                self.track.set_text(str(atoi(line[6:8])))
                                formatstr = "%p%% (" + strip(line[9:13]) + " of " + str(int(round(float(self.selecteddatasize) / 1024))) + " MB)"
                                if (atof(strip(line[9:13])) <= round(float(self.selecteddatasize) / 1024)):
                                    self.progressbar.set_format_string(formatstr)
                                    if round(float(self.selecteddatasize) / 1024) > 0:
                                        self.progressbar.update(atof(strip(line[9:13])) / round(float(self.selecteddatasize) / 1024))
                            elif self.formatdatalongfifo.match(line):
                                self.track.set_text(str(atoi(line[6:8])))
                                formatstr = "%p%% (" + strip(line[9:13]) + " of " + str(int(round(float(self.selecteddatasize) / 1024))) + " MB)"
                                if (atof(strip(line[9:13])) <= round(float(self.selecteddatasize) / 1024)):
                                    self.progressbar.set_format_string(formatstr)
                                    if round(float(self.selecteddatasize) / 1024) > 0:
                                        self.progressbar.update(atof(strip(line[9:13])) / round(float(self.selecteddatasize) / 1024))
                                self.fifo.set_text("%s%%" % strip(line[31:34]))
                                self.estimate.set_text(line[67:])
                            elif self.formatdatafifo.match(line):
                                self.track.set_text(str(atoi(line[6:8])))
                                formatstr = "%p%% (" + strip(line[9:13]) + " of " + str(int(round(float(self.selecteddatasize) / 1024))) + " MB)"
                                if (atof(strip(line[9:13])) <= round(float(self.selecteddatasize) / 1024)):
                                    self.progressbar.set_format_string(formatstr)
                                    if round(float(self.selecteddatasize) / 1024) > 0:
                                        self.progressbar.update(atof(strip(line[9:13])) / round(float(self.selecteddatasize) / 1024))
                                self.fifo.set_text("%s%%" % strip(line[31:34]))
                            elif self.formatdatalong.match(line):
                                self.track.set_text(str(atoi(line[6:8])))
                                formatstr = "%p%% (" + strip(line[9:13]) + " of " + str(int(round(float(self.selecteddatasize) / 1024))) + " MB)"
                                if (atof(strip(line[9:13])) <= round(float(self.selecteddatasize) / 1024)):
                                    self.progressbar.set_format_string(formatstr)
                                    if round(float(self.selecteddatasize) / 1024) > 0:
                                        self.progressbar.update(atof(strip(line[9:13])) / round(float(self.selecteddatasize) / 1024))
                                self.estimate.set_text(line[55:])
                            elif (not self.formatignore.match(line)):
                                self.cdtext.insert_defaults("%s\n" % line)

                        # Format lines for formatting CDs
                        elif (self.writermode == BlankCDAll) or (self.writermode == BlankCDMinimal) or (self.writermode == BlankCDLast) or (self.writermode == modeFixateCD):
                            if (not self.formatignore.match(line)):
                                self.cdtext.insert_defaults("%s\n" % line)

                        # Format lines for copying CDs
                        elif (self.writermode == modeCopyCD):
                            if self.formatreadimageend.match(line):
                                self.tmpimagesize = atoi(strip(line[5:])) * 2
                                formatstr = "%p%% (0 of " + str(self.tmpimagesize / 1024) + "MB)"
                                self.progressbar.set_format_string(formatstr)
                            elif (self.formatdatafifo.match(line)):
                                self.track.set_text(str(atoi(line[6:8])))
                                formatstr = "%p%% (" + strip(line[9:13]) + " of " + str(int(round(float(self.tmpimagesize) / 1024))) + " MB)"
                                self.progressbar.set_format_string(formatstr)
                                if round(float(self.tmpimagesize) / 1024) > 0:
                                    self.progressbar.update(atof(strip(line[9:13])) / round(float(self.tmpimagesize) / 1024))
                                self.fifo.set_text("%s%%" % strip(line[31:34]))
                            elif (not self.formatignorecopy.match(line)) and (not self.formatreadimage.match(line)) and (not self.formatignore.match(line)):
                                self.cdtext.insert_defaults("%s\n" % line)

                        # Format lines for creating CD images
                        elif (self.writermode == ImageCD):
                            if self.formataudio.match(line):
                                self.track.set_text("%s" % str(atoi(line[6:8])))
                                formatstr = "%p%% (" + strip(line[10:13]) + " of " + strip(line[17:20]) + " MB)"
                                if (atof(line[10:13]) <= atoi(line[17:20])):
                                    self.progressbar.set_format_string(formatstr)
                                    if atof(line[17:20]) > 0:
                                        self.progressbar.update(atof(line[10:13]) / atof(line[17:20]))

                            elif self.formataudiolong.match(line):
                                self.track.set_text("%s" % str(atoi(line[6:8])))
                                formatstr = "%p%% (" + strip(line[10:13]) + " of " + strip(line[17:20]) + " MB)"
                                if (atof(line[10:13]) <= atof(line[17:20])):
                                    self.progressbar.set_format_string(formatstr)
                                    if atof(line[17:20]) > 0:
                                        self.progressbar.update(atof(line[10:13]) / atof(line[17:20]))
                                self.fifo.set_text("%s%%" % strip(line[38:41]))
                            elif (not self.formatignore.match(line)):
                                self.cdtext.insert_defaults("%s\n" % line)

                        # Format lines for creating Image files
                        elif (self.writermode == modeDataCDImage):

                            if self.formatimage.match(line):
                                formatstr = "%p%%"
                                self.progressbar.set_format_string(formatstr)
                                self.progressbar.update(atof(strip(line[:find(line, ".")])) / 100)
                                self.estimate.set_text(line[find(line, ".") + 27:])
                            elif (not self.formatignore.match(line)):
                                self.cdtext.insert_defaults("%s\n" % line)

    def BurnWindowDestroy(self, args):
        """ Close the burn window """
        self.connection.close()
        self.server.close()
        tmppid = 0
        # Call waitpid to clean up all child processes
        while (tmppid == 0):
            sleep(0.1)
            tmppid = os.waitpid(self.pid, os.WNOHANG)[0]
            while (events_pending()):
                mainiteration()
        self.burnwindow.destroy()
        self.burnwindow = None
        if (self.startup_burnmode != None):
            self.Destroy(None)

    # Handler to prevent users to kill the burn window
    def BurnWindowDontKill(self, *args):
        return 1
    
    # Normalize wav-files
    def Normalize(self):
        
        if (self.normalize.active):

            pgb = GnomeProgressBar("ECLiPt Roaster Info", "Normalizing wav-files - This may take a minute or two...", 1)

            command = "normalize -q"
            line = 0
            try:
                filename = self.songlist.get_text(line, 2)
            except detail:
                filename = None
            while (filename != None):

                command = "%s \"%s\"" % (command, filename)
                line = line + 1
                try:
                    filename = self.songlist.get_text(line, 2)
                except:
                    filename = None

            system(command)

            pgb.update()
            pgb.close()
            pgb = None

        return TRUE

    # Select the default temporary path for CD images
    def SelectTempPath(self, args):
        self.filedialog = GnomeFileSelection(multiselection = FALSE, filetypes = [ALL_FILES], icondir = iconpath, loglevel = self.cat.get_loglevel())
        self.filedialog.use_lastdirectory("%s/%s/lastdirectory.cdimages" % (environ["HOME"], configdirectory))
        self.filedialog.load_shortcuts_from_file("%s/%s/%s" % (environ["HOME"], configdirectory, shortcutfile))
        self.filedialog.ok_button.connect("clicked", self.SelectTempDirectory)
        self.filedialog.close_button.connect("clicked", self.filedialog.destroy)
        self.filedialog.show()

    # After browsing for the cd image enter the filename in the entry field
    def SelectTempDirectory(self, args):
        self.imageentry.gtk_entry().set_text("%s/%s" % (self.filedialog.get_directory(), self.filedialog.get_filenames()))
        self.filedialog.destroy()

    # Set various options for CDRecord & MkIsoFS
    def Options(self, frame):

        # A table containing various options
        opttable = GtkTable(3, 1)
        opttable.show()

        # Filesystem options
        fsframe = GtkFrame(" Filesystem (Data & Audio) ")
        fsframe.set_border_width(5)
        fsframe.set_shadow_type(SHADOW_ETCHED_OUT)
        fsframe.show()

        # Create a table containing the check buttons
        fstab = GtkTable(6, 4)
        fstab.show()

        self.diralloc = GtkCheckButton("Disable deep directory relocation")
        self.diralloc.show()
        self.fullchar = GtkCheckButton("Allow full 32 character filenames")
        self.fullchar.show()
        self.allowdots = GtkCheckButton("Allow file to start with '.'")
        self.allowdots.show()
        self.followlinks = GtkCheckButton("Follow symbolic links")
        self.followlinks.show()
        self.joliet = GtkCheckButton("Generate Joliet directory information")
        self.joliet.show()
        self.ratrock = GtkCheckButton("Generate rationalized Rock Ridge directory information")
        self.ratrock.show()
        self.rockridge = GtkCheckButton("Generate Rock Ridge directory information")
        self.rockridge.show()
        self.periods = GtkCheckButton("Omit trailing periods from filenames")
        self.periods.show()
        self.pad = GtkCheckButton("Pad audio tracks to a multiple of 2352 bytes")
        self.pad.show()
        self.swab = GtkCheckButton("Audio data source is byte-swapped (little-endian/Intel)")
        self.swab.show()

        fifolabel = GtkLabel("FIFO Size:")
        fifolabel.show()
        self.fifosize = GtkSpinButton(GtkAdjustment(4,2,64,1,10,0), 0, 0)
        self.fifosize.show()
        mblabel = GtkLabel("MB ")
        mblabel.show()
        empty = GtkLabel()
        empty.show()

        self.dao = GtkCheckButton("DAO mode (Audio)")
        self.dao.show()
        self.burnproof = GtkCheckButton("Use Burnfree driveropt.")
        self.burnproof.show()
        self.overburn = GtkCheckButton("Allow overburning")
        self.overburn.show()

        fifobox = GtkHBox(spacing = 5)
        fifobox.pack_start(fifolabel, expand = FALSE)
        fifobox.pack_start(self.fifosize, expand = FALSE)
        fifobox.pack_start(mblabel, expand = FALSE)
        fifobox.show()

        jolietCharsets = cdrtools.cdrtools().joliet_charsets()
        self.jolietCharSets = GnomeOptionMenu(loglevel=self.cat.get_loglevel())
        self.jolietCharSets.append_itemlist(jolietCharsets)
        self.jolietCharSets.show()

        fstab.attach(self.diralloc, 0, 1, 0, 1, FILL, 0, 5)
        fstab.attach(self.fullchar, 0, 1, 1, 2, FILL, 0, 5)
        fstab.attach(self.allowdots, 0, 1, 2, 3, FILL, 0, 5)
        fstab.attach(self.followlinks, 0, 1, 3, 4, FILL, 0, 5)
        fstab.attach(self.periods, 0, 1, 4, 5, FILL, 0, 5)

        fstab.attach(self.joliet, 1, 2, 0, 1, FILL, 0, 5)
        fstab.attach(self.jolietCharSets.get_gtkoptionmenu(), 2, 3, 0, 1, 0, 0, 0)
        fstab.attach(self.ratrock, 1, 3, 1, 2, FILL, 0, 5)
        fstab.attach(self.rockridge, 1, 3, 2, 3, FILL, 0, 5)
        fstab.attach(self.pad, 1, 3, 3, 4, FILL, 0, 5)
        fstab.attach(self.swab, 1, 3, 4, 5, FILL, 0, 5)

        fstab.attach(self.dao, 3, 4, 0, 1, FILL, 0, 0)
        fstab.attach(self.burnproof, 3, 4, 1, 2, FILL, 0, 0)
        fstab.attach(self.overburn, 3, 4, 2, 3, FILL, 0, 0)
        fstab.attach(fifobox, 3, 4, 3, 4, 0, 0, 0)
        fstab.attach(empty, 3, 4, 4, 5, 0, 0, 0)
        fsframe.add(fstab)

        opttable.attach(fsframe, 0, 1, 0, 1, FILL, 0, 0, 0)

        # Recorder options
        recframe = GtkFrame(" Recorder / Reader")
        recframe.set_border_width(5)
        recframe.set_shadow_type(SHADOW_ETCHED_OUT)
        recframe.show()

        # Create a vertical box containing the SCSI-options, speed and mode checkboxes
        recordbox = GtkVBox(spacing = 10)
        recordbox.show()

        # Create a table containing the SCSI-options (Select CD-Writer)
        channel = GtkLabel("Channel:")
        channel.set_alignment(1.0, 0.5)
        channel.show()
        id = GtkLabel("ID:")
        id.set_alignment(1.0, 0.5)
        id.show()
        lun = GtkLabel("Lun:")
        lun.set_alignment(1.0, 0.5)
        lun.show()

        self.channel = GtkEntry()
        self.channel.set_usize(35, -1)
        self.channel.show()
        self.id = GtkEntry()
        self.id.set_usize(35, -1)
        self.id.show()
        self.lun = GtkEntry()
        self.lun.set_usize(35, -1)
        self.lun.show()

        autobutton = GtkButton(" Detect Recorder ")
        autobutton.connect('clicked', self.DetectRecorder)
        autobutton.show()

        channelReader = GtkLabel("Channel:")
        channelReader.set_alignment(1.0, 0.5)
        channelReader.show()
        idReader = GtkLabel("ID:")
        idReader.set_alignment(1.0, 0.5)
        idReader.show()
        lunReader = GtkLabel("Lun:")
        lunReader.set_alignment(1.0, 0.5)
        lunReader.show()

        self.channelReader = GtkEntry()
        self.channelReader.set_usize(35, -1)
        self.channelReader.show()
        self.idReader = GtkEntry()
        self.idReader.set_usize(35, -1)
        self.idReader.show()
        self.lunReader = GtkEntry()
        self.lunReader.set_usize(35, -1)
        self.lunReader.show()

        btnAutoReader = GtkButton(" Detect Reader ")
        btnAutoReader.connect('clicked', self.DetectReader)
        btnAutoReader.show()

        speedlabel = GtkLabel("Speed (CD-W):")
        speedlabel.set_alignment(1.0, 0.5)
        speedlabel.show()
        self.speed = GtkSpinButton(GtkAdjustment(8,2,64,2,10,0), 0, 0)
        self.speed.show()
        xlabel = GtkLabel("x")
        xlabel.show()

        speedtable = GtkTable(2, 3)
        speedtable.attach(speedlabel, 0, 1, 0, 1, EXPAND|FILL, 0, 5)
        speedtable.attach(self.speed, 1, 2, 0, 1, FILL, 0, 5)
        speedtable.attach(xlabel, 2, 3, 0, 1, 0, FILL, 5)

        speedlabel = GtkLabel("Speed (CD-RW):")
        speedlabel.set_alignment(1.0, 0.5)
        speedlabel.show()
        self.speedRW = GtkSpinButton(GtkAdjustment(4,2,64,2,10,0), 0, 0)
        self.speedRW.show()
        xlabel = GtkLabel("x")
        xlabel.show()

        speedtable.attach(speedlabel, 0, 1, 1, 2, EXPAND|FILL, 0, 5)
        speedtable.attach(self.speedRW, 1, 2, 1, 2, FILL, 0, 5)
        speedtable.attach(xlabel, 2, 3, 1, 2, FILL, 0, 5)

        speedtable.show()

        self.devReader = GtkEntry()
        self.devReader.set_usize(70, -1)
        self.devReader.show()
        devReader = GtkLabel("Device:")
        devReader.set_alignment(1.0, 0.5)
        devReader.show()

        self.devWriter = GtkEntry()
        self.devWriter.set_usize(70, -1)
        self.devWriter.show()
        devWriter = GtkLabel("Device:")
        devWriter.set_alignment(1.0, 0.5)
        devWriter.show()

        recordtab = GtkTable(3, 9)
        recordtab.attach(channel, 0, 1, 0, 1, FILL, 0, 5)
        recordtab.attach(self.channel, 1, 2, 0, 1, 0, 0, 5)
        recordtab.attach(id, 0, 1, 1, 2, FILL, 0, 5)
        recordtab.attach(self.id, 1, 2, 1, 2, 0, 0, 5)
        recordtab.attach(lun, 0, 1, 2, 3, FILL, 0, 5)
        recordtab.attach(self.lun, 1, 2, 2, 3, 0, 0, 5)
        recordtab.attach(autobutton, 2, 4, 0, 2, SHRINK, 0, 5)
        recordtab.attach(devWriter, 2, 3, 2, 3, 0, 0, 5)
        recordtab.attach(self.devWriter, 3, 4, 2, 3, 0, 0, 5)

        recordtab.attach(channelReader, 4, 5, 0, 1, FILL, 0, 5)
        recordtab.attach(self.channelReader, 5, 6, 0, 1, 0, 0, 5)
        recordtab.attach(idReader, 4, 5, 1, 2, FILL, 0, 5)
        recordtab.attach(self.idReader, 5, 6, 1, 2, 0, 0, 5)
        recordtab.attach(lunReader, 4, 5, 2, 3, FILL, 0, 5)
        recordtab.attach(self.lunReader, 5, 6, 2, 3, 0, 0, 5)
        recordtab.attach(btnAutoReader, 6, 8, 0, 2, SHRINK, 0, 5)
        recordtab.attach(devReader, 6, 7, 2, 3, 0, 0, 5)
        recordtab.attach(self.devReader, 7, 8, 2, 3, 0, 0, 5)
        recordtab.attach(speedtable, 8, 9, 0, 3, 0, 0, 5)
        recordtab.show()

        # Create a table containing varions Recorder options
        recopttab = GtkTable(1, 2)
        recopttab.show()

        self.dummy = GtkCheckButton("Dummy operation")
        self.dummy.show()
        self.eject = GtkCheckButton("Eject CD after operation")
        self.eject.show()

        recopttab.attach(self.dummy, 0, 1, 0, 1, FILL, 0, 5)
        recopttab.attach(self.eject, 1, 2, 0, 1, FILL, 0, 5)

        recordbox.pack_start(recordtab, expand = FALSE, fill = FALSE)
        recordbox.pack_start(recopttab, expand = FALSE, fill = FALSE)

        recframe.add(recordbox)

        opttable.attach(recframe, 0, 1, 1, 2, FILL, 0, 0, 0)

        # Miscellaneous options
        miscframe = GtkFrame(" Miscellaneous ")
        miscframe.set_border_width(5)
        miscframe.set_shadow_type(SHADOW_ETCHED_OUT)
        miscframe.show()

        miscvbox = GtkVBox(spacing = 5)
        miscvbox.set_border_width(5)
        miscvbox.show()

        imagelabel = GtkLabel("Image path: ")
        imagelabel.show()

        self.imageentry = GnomeEntry("tempimage")
        self.imageentry.set_usize(350, -1)
        self.imageentry.show()

        openimagebutton = GtkButton(" Browse ")
        openimagebutton.connect('clicked', self.SelectTempPath)
        openimagebutton.show()

        imagebox = GtkHBox(spacing = 5)
        imagebox.pack_start(imagelabel, expand = FALSE)
        imagebox.pack_start(self.imageentry, expand = FALSE)
        imagebox.pack_start(openimagebutton, expand = FALSE)
        imagebox.show()

        miscvbox.pack_start(imagebox, expand = FALSE)

        mischbox = GtkHBox(spacing = 5)
        mischbox.show()

        self.convmp3wav = GtkCheckButton("Automatically convert mp3-/ogg-files to wav-files")
        self.convmp3wav.show()

        self.normalize = GtkCheckButton("Normalize wav-files")
        self.normalize.show()

        labPlayer = GtkLabel(" Audio Player:")
        labPlayer.show()

        self.playermenu = GnomeOptionMenu()
        self.playermenu.append_itemlist([playerMpg123, playerXMMS, playerFreeAmp])
        self.playermenu.show()

        mischbox.pack_start(self.convmp3wav, expand = FALSE)
        mischbox.pack_start(self.normalize, expand = FALSE)
        mischbox.pack_start(labPlayer, expand = FALSE)
        mischbox.pack_start(self.playermenu.get_gtkoptionmenu(), expand = FALSE)

        miscvbox.pack_start(mischbox, expand = FALSE)

        miscframe.add(miscvbox)

        opttable.attach(miscframe, 0, 1, 2, 3, FILL, 0, 0, 0)

        frame.add(opttable)

    # Save options to the config file
    def SaveOptions(self):

        filename = "%s/%s/%s" % (environ["HOME"], configdirectory, deffile)
        file = open(filename, "w")

        # Filesystem options
        file.write("[Filesystem]\n")
        file.write("DisableDeepRelocation: %s\n" % bool2str(self.diralloc.active))
        file.write("FullIso9660Filenames: %s\n" % bool2str(self.fullchar.active))
        file.write("AllowLeadingDots: %s\n" % bool2str(self.allowdots.active))
        file.write("FollowLinks: %s\n" % bool2str(self.followlinks.active))
        file.write("Joliet: %s\n" % bool2str(self.joliet.active))
        file.write("Joliet-Characterset: %s\n" % self.jolietCharSets.get_active_item())
        file.write("RationalRock: %s\n" % bool2str(self.ratrock.active))
        file.write("Rock: %s\n" % bool2str(self.rockridge.active))
        file.write("OmitPeriod: %s\n" % bool2str(self.periods.active))
        file.write("Pad: %s\n" % bool2str(self.pad.active))
        file.write("Swab: %s\n" % bool2str(self.swab.active))
        file.write("DAO: %s\n" % bool2str(self.dao.active))
        file.write("Burnproof: %s\n" % bool2str(self.burnproof.active))
        file.write("Overburn: %s\n" % bool2str(self.overburn.active))

        # Recorder options
        file.write("\n[Recorder]\n")
        file.write("Speed: %d\n" % self.speed.get_value_as_int())
        file.write("SpeedRW: %d\n" % self.speedRW.get_value_as_int())
        file.write("Channel: %s\n" % self.channel.get_text())
        file.write("ID: %s\n" % self.id.get_text())
        file.write("LUN: %s\n" % self.lun.get_text())
        file.write("Device: %s\n" % self.devWriter.get_text())
        file.write("DummyMode: %s\n" % bool2str(self.dummy.active))
        file.write("Eject: %s\n" % bool2str(self.eject.active))

        # Reader options
        file.write("\n[Reader]\n")
        file.write("Channel: %s\n" % self.channelReader.get_text())
        file.write("ID: %s\n" % self.idReader.get_text())
        file.write("LUN: %s\n" % self.lunReader.get_text())
        file.write("Device: %s\n" % self.devReader.get_text())

        # Temporary writing settings
        file.write("\n[Settings]\n")
        file.write("Mode: %d\n" % self.tw_mode)
        file.write("Fixate: %s\n" % bool2str(self.tw_fixate))
        file.write("Multisession: %s\n" % bool2str(self.tw_multisession))
        if (self.cdsize650.active):
            file.write("CDR-Size: %s\n" % cdrSize650)
        else:
            file.write("CDR-Size: %s\n" % cdrSize700)

        # Miscellaneous options
        file.write("\n[Miscellaneous]\n")
        file.write("FIFO: %d\n" % self.fifosize.get_value_as_int())
        file.write("ImagePath: %s\n" % self.imageentry.gtk_entry().get_text())
        file.write("ConvertMp3: %s\n" % bool2str(self.convmp3wav.active))
        file.write("Mp3-Player: %s\n" % self.playermenu.get_active_item())
        file.write("Normalize: %s\n\n" % bool2str(self.normalize.active))

        file.close()

    # Load configuration options (or set defaults) and copy shortcut file if necessary
    def LoadOptions(self):

        if (not (os.path.exists("%s/%s" % (environ["HOME"], configdirectory)))):
            mkdirtree("%s/%s" % (environ["HOME"], configdirectory))
        filename = "%s/%s/%s" % (environ["HOME"], configdirectory, deffile)
        if (not os.path.exists("%s/%s/%s" % (environ["HOME"], configdirectory, shortcutfile))):
            filecopy(systemshortcutfile, "%s/%s/%s" % (environ["HOME"], configdirectory, shortcutfile))
        if (os.path.exists(lockfile)):
            unlink(lockfile)

        setDefault = FALSE

        if (os.path.exists(filename)):                        # Load configuration file
            try:
                self.parser.read(filename)

                # Filesystem options
                self.diralloc.set_active(str2bool(self.parser.get("Filesystem", "DisableDeepRelocation")))
                self.fullchar.set_active(str2bool(self.parser.get("Filesystem", "FullIso9660Filenames")))
                self.allowdots.set_active(str2bool(self.parser.get("Filesystem", "AllowLeadingDots")))
                self.followlinks.set_active(str2bool(self.parser.get("Filesystem", "FollowLinks")))
                self.joliet.set_active(str2bool(self.parser.get("Filesystem", "Joliet")))
                self.jolietCharSets.activate_item(self.parser.get("Filesystem", "Joliet-Characterset"))
                self.ratrock.set_active(str2bool(self.parser.get("Filesystem", "RationalRock")))
                self.rockridge.set_active(str2bool(self.parser.get("Filesystem", "Rock")))
                self.periods.set_active(str2bool(self.parser.get("Filesystem","OmitPeriod")))
                self.pad.set_active(str2bool(self.parser.get("Filesystem", "Pad")))
                self.swab.set_active(str2bool(self.parser.get("Filesystem","Swab")))
                self.dao.set_active(str2bool(self.parser.get("Filesystem", "DAO")))
                self.burnproof.set_active(str2bool(self.parser.get("Filesystem", "Burnproof")))
                self.overburn.set_active(str2bool(self.parser.get("Filesystem", "Overburn")))

                # Recorder options
                self.speed.set_value(atoi(self.parser.get("Recorder", "Speed")))
                self.speedRW.set_value(atoi(self.parser.get("Recorder", "SpeedRW")))
                self.channel.set_text(self.parser.get("Recorder", "Channel"))
                self.id.set_text(self.parser.get("Recorder", "ID"))
                self.lun.set_text(self.parser.get("Recorder", "LUN"))
                self.devWriter.set_text(self.parser.get("Recorder", "Device"))
                self.dummy.set_active(str2bool(self.parser.get("Recorder", "DummyMode")))
                self.eject.set_active(str2bool(self.parser.get("Recorder", "Eject")))

                # Reader options
                self.channelReader.set_text(self.parser.get("Reader", "Channel"))
                self.idReader.set_text(self.parser.get("Reader", "ID"))
                self.lunReader.set_text(self.parser.get("Reader", "LUN"))
                self.devReader.set_text(self.parser.get("Reader", "Device"))

                # Temporary writing settings
                self.tw_mode = atoi(self.parser.get("Settings", "Mode"))
                self.tw_fixate = str2bool(self.parser.get("Settings", "Fixate"))
                self.tw_multisession = str2bool(self.parser.get("Settings", "Multisession"))
                cdrsize = self.parser.get("Settings", "CDR-Size")
                if (cdrsize == cdrSize650):
                    self.cdsize650.set_active(TRUE)
                elif (cdrsize == cdrSize700):
                    self.cdsize700.set_active(TRUE)

                # Miscellaneous options
                self.fifosize.set_value(atoi(self.parser.get("Miscellaneous", "FIFO")))
                tmpImagePath = self.parser.get("Miscellaneous", "ImagePath")
                self.imageentry.gtk_entry().set_text(tmpImagePath)
                self.readcdimage.gtk_entry().set_text(tmpImagePath)
                self.cdimage.gtk_entry().set_text(tmpImagePath)
                self.convmp3wav.set_active(str2bool(self.parser.get("Miscellaneous", "ConvertMp3")))
                self.playermenu.activate_item(self.parser.get("Miscellaneous", "Mp3-Player"))
                self.normalize.set_active(str2bool(self.parser.get("Miscellaneous", "Normalize")))

            except:

                setDefault = TRUE

        else:                                               # Set default values

            setDefault = TRUE

        if (setDefault == TRUE):
            self.cat.warn("Couldn't read settings - setting default values !")

            # Filesystem options
            self.diralloc.set_active(1)
            self.fullchar.set_active(1)
            self.allowdots.set_active(1)
            self.followlinks.set_active(0)
            self.joliet.set_active(1)
            self.jolietCharSets.activate_item("iso8859-1")
            self.ratrock.set_active(0)
            self.rockridge.set_active(1)
            self.periods.set_active(0)
            self.pad.set_active(1)
            self.swab.set_active(1)
            self.dao.set_active(1)
            self.burnproof.set_active(0)
            self.overburn.set_active(0)

            # Recorder options
            self.speed.set_value(8)
            self.speedRW.set_value(4)
            self.channel.set_text("00")
            self.id.set_text("00")
            self.lun.set_text("00")
            self.dummy.set_active(0)
            self.eject.set_active(1)

            # Reader options
            self.channelReader.set_text("00")
            self.idReader.set_text("00")
            self.lunReader.set_text("00")

            # Temporary writing settings
            self.tw_mode = 0
            self.tw_fixate = 1
            self.tw_multisession = 0

            # Miscellaneous options
            self.fifosize.set_value(4)
            self.convmp3wav.set_active(1)
            self.playermenu.activate_item(playerXMMS)
            self.normalize.set_active(0)

    # Detect SCSI-recorder
    def DetectRecorder(self, args):
        self.DetectSCSIDevice(deviceRecorder)

    # Detect SCSI-reader
    def DetectReader(self, args):
        self.DetectSCSIDevice(deviceReader)

    # Detect SCSI-devices
    def DetectSCSIDevice(self, device):
        devicelist = cdrtools.cdrtools().devices()
        if (len(devicelist) == 0):
            GnomeErrorDialog("Couldn't detect your reader / recorder !\nPlease make sure that you are root or that you're allowed to read /dev/sg* !")
        elif len(devicelist) == 1:
            if (device == deviceReader):
                self.idReader.set_text(devicelist[0][1])
                self.channelReader.set_text(devicelist[0][0])
                self.lunReader.set_text(devicelist[0][2])
                self.devReader.set_text("/dev/scd0")
            elif (device == deviceRecorder):
                self.id.set_text(devicelist[0][1])
                self.channel.set_text(devicelist[0][0])
                self.lun.set_text(devicelist[0][2])
                self.devWriter.set_text("/dev/scd0")
        else:
            self.SelectSCSIDevice(device, devicelist)

    # Select the device if >1 devices found
    def SelectSCSIDevice(self, device, devicelist):
        self.scsiwindow = GnomeApp("ERoasterSCSI", "SCSI Devices")
        self.scsiwindow.set_border_width(1)
        self.scsiwindow.show()

        scsibox = GtkVBox(spacing = 5)
        scsibox.set_border_width(5)
        scsibox.show()

        scsifrm = GtkFrame(" Select SCSI-device ")
        scsifrm.set_shadow_type(SHADOW_ETCHED_OUT)
        scsifrm.show()

        box = GtkVBox(spacing = 5)
        box.set_border_width(5)
        box.show()

        self.scsidevice = []
        for intCounter in range(len(devicelist)):
            if intCounter == 0:
                self.scsidevice.append(GtkRadioButton(None, devicelist[intCounter][3]))
            else:
                self.scsidevice.append(GtkRadioButton(self.scsidevice[intCounter - 1], devicelist[intCounter][3]))
            self.scsidevice[intCounter].show()
            box.pack_start(self.scsidevice[intCounter], expand = FALSE)

        scsifrm.add(box)

        btnSelect = GtkButton(" Select ")
        btnSelect.connect('clicked', self.SelectSCSIDeviceSelect)
        btnSelect.show()

        self.device = device
        self.devicelist = devicelist

        scsibox.pack_start(scsifrm, expand = FALSE)
        scsibox.pack_start(btnSelect, expand = FALSE)

        self.scsiwindow.set_contents(scsibox)

    # Select SCSI Device (Select button clicked)
    def SelectSCSIDeviceSelect(self, args):

        for intCounter in range(len(self.scsidevice)):
            if (self.scsidevice[intCounter].active == 1):
                if (self.device == deviceReader):
                    self.idReader.set_text(self.devicelist[intCounter][1])
                    self.channelReader.set_text(self.devicelist[intCounter][0])
                    self.lunReader.set_text(self.devicelist[intCounter][2])
                    self.devReader.set_text("/dev/scd%d" % intCounter)
                elif (self.device == deviceRecorder):
                    self.id.set_text(self.devicelist[intCounter][1])
                    self.channel.set_text(self.devicelist[intCounter][0])
                    self.lun.set_text(self.devicelist[intCounter][2])
                    self.devWriter.set_text("/dev/scd%d" % intCounter)

        self.scsiwindow.destroy()
        self.scsiwindow = None

    # Swap two entries in the Songlist
    def SongListSwap(self, row):
        if (row < 0):
            return                                    # You can't move out of the top
        self.cat.debug("Swapping rows %d and %d" % (self.songlist.focus_row, row))
        if (row > self.songlist.focus_row):
            swaprows = range(self.songlist.focus_row, row)
        else:
            swaprows = range(row, self.songlist.focus_row)
            swaprows.reverse()
        for row in swaprows:
            sourceindex = self.songlist.get_text(row, 1)
            targetindex = self.songlist.get_text(row + 1, 1)
            self.songlist.set_text(row, 1, targetindex)
            self.songlist.set_text(row + 1, 1, sourceindex)
            self.songlist.row_move(row, row + 1)

    # When button is pressed move the selected file
    def SongListButtonPressed(self, widget, event = None):
        try:
            row = self.songlist.get_selection_info(event.x, event.y)[0]
        except:
            row = -1

    # Stop moving the file when the mouse button is released
    def SongListButtonReleased(self, widget, event = None):
        try:
            row = self.songlist.get_selection_info(event.x, event.y)[0]
        except:
            row = -1
        if (row != self.songlist.focus_row) and (row != -1) and (self.songlist.focus_row != -1):
            self.SongListSwap(row)

        self.songlist.freeze()

        if ((event.state & GDK.SHIFT_MASK) == 0) and ((event.state & GDK.CONTROL_MASK) == 0):
            self.songlist.set_selection_mode(SELECTION_SINGLE)
            self.songlist.unselect_row(self.songlist.focus_row, 0)
            while events_pending():
                mainiteration()
            self.songlist.set_selection_mode(SELECTION_EXTENDED)
            self.songlist.select_row(self.songlist.focus_row, 0)

        self.ColorizeCList(self.songlist)
        self.songlist.thaw()

    # Move files up & down when "dragging"
    def SongListMotion(self, widget, event=None):
        if (event.state == 0):                           # Fix "random reordering" bug
            return
        try:
            row = self.songlist.get_selection_info(event.x, event.y)[0]
        except:
            row = -1
        if (row != self.songlist.focus_row) and (row != -1) and (self.songlist.focus_row != -1):
            self.SongListSwap(row)

    # Drag & Drop - Add file to the Songlist window
    def SongListDragReceive(self, window, context, x, y, data, info, time):
        filenames = cleanlist(split(data.data,"\n"))
        self.songlist.freeze()
        for i in range(len(filenames)):
            if (filenames[i][:5] == "file:"):
                filenames[i] = filenames[i][5:]
            filenames[i] = replace(filenames[i], "%20", " ")
            filenames[i] = replace(filenames[i], "\000", "")
            filenames[i] = strip(filenames[i])
            basename = strip(os.path.basename(filenames[i]))
            if (filenames[i][0] == "/") and (basename != "") and (basename != ".") and (basename != ".."):
                self.AddFileToList(filenames[i])
        self.ColorizeCList(self.songlist)
        self.songlist.thaw()

    # Burn Audio CDs
    def BurnAudio(self, frame):
        burnbox = GtkVBox(spacing = 5)
        burnbox.show()

        # Volume ID
        volumeframe = GtkFrame(" Volume ID ")
        volumeframe.set_border_width(5)
        volumeframe.set_shadow_type(SHADOW_ETCHED_OUT)
        volumeframe.show()

        # Create a table containing the Volume ID
        volumetab = GtkTable(1, 2)
        volumetab.show()

        label = GtkLabel("Enter Volume ID: ")
        label.show()

        self.volumeidaudio = GtkEntry()
        self.volumeidaudio.show()

        volumetab.attach(label, 0, 1, 0, 1, FILL, 0, 5, 5)
        volumetab.attach(self.volumeidaudio, 1, 2, 0, 1, FILL, 0, 5, 5)

        volumeframe.add(volumetab)

        volumebox = GtkHBox(spacing = 0)
        volumebox.pack_start(volumeframe, expand = TRUE)
        volumebox.pack_start(GnomePixmap(self.window, "%s/cdwriter.xpm" % iconpath).get_pixmap(), expand = FALSE)
        volumebox.show()

        burnbox.pack_start(volumebox, expand = FALSE)

        # Create a table containing the wav files
        wavframe = GtkFrame(" Wav-/Ogg-/Mp3-files ")
        wavframe.set_border_width(5)
        wavframe.set_shadow_type(SHADOW_ETCHED_OUT)
        wavframe.show()

        self.songlist = GtkCList(4, [ "", " Nr ", " Name ", " Time " ])
        self.songlist.connect("button_press_event", self.SongListButtonPressed)
        self.songlist.connect("button_release_event", self.SongListButtonReleased)
        self.songlist.connect("motion_notify_event", self.SongListMotion)
        self.songlist.connect("drag_data_received", self.SongListDragReceive)
        self.songlist.drag_dest_set(DEST_DEFAULT_DROP | DEST_DEFAULT_MOTION, targets, GDK.ACTION_COPY | GDK.ACTION_MOVE)
        self.songlist.set_selection_mode(SELECTION_EXTENDED)
        self.songlist.set_column_width(0, 18)
        self.songlist.set_column_width(2, 385)
        self.songlist.set_column_justification(3, JUSTIFY_RIGHT)
        self.songlist.show()

        self.songlistwin = GtkScrolledWindow()
        self.songlistwin.set_policy(POLICY_AUTOMATIC, POLICY_AUTOMATIC)
        self.songlistwin.add(self.songlist)
        self.songlistwin.show()

        addbutton = GtkButton(" Add File(s) ")
        addbutton.set_usize(95, -1)
        addbutton.connect('clicked', self.AddFile)
        addbutton.show()

        delbutton = GtkButton(" Remove File(s) ")
        delbutton.set_usize(95, -1)
        delbutton.connect('clicked', self.DelFile)
        delbutton.show()

        import_button = GtkButton(" Import XMMS ")
        import_button.set_usize(95, -1)
        import_button.connect("clicked", self.ImportXMMSPlaylist)
        import_button.show()

        btnPlay = GtkButton(" Play File ")
        btnPlay.set_usize(95, -1)
        btnPlay.connect('clicked', self.PlayAudioFile)
        btnPlay.show()

        sizelabel = GtkLabel("Total time: ")
        sizelabel.set_alignment(1.0, 0.5)
        sizelabel.show()

        self.audiosize = GtkEntry()
        self.audiosize.set_editable(FALSE)
        self.audiosize.set_usize(40, -1)
        self.audiosize.set_text("00:00")
        self.audiosize.show()

        emptyLabel = GtkLabel()
        emptyLabel.show()

        wavtable = GtkTable(6, 3)
        wavtable.show()

        wavtable.attach(self.songlistwin, 0, 1, 0, 6, EXPAND|FILL, EXPAND|FILL, 5, 5)
        wavtable.attach(addbutton, 1, 3, 0, 1, 0, 0, 5, 5)
        wavtable.attach(delbutton, 1, 3, 1, 2, 0, 0, 5, 5)
        wavtable.attach(import_button, 1, 3, 2, 3, 0, 0, 5, 5)
        wavtable.attach(emptyLabel, 1, 3, 3, 4, 0, EXPAND|FILL, 5, 5)
        wavtable.attach(btnPlay, 1, 3, 4, 5, 0, 0, 5, 5)
        wavtable.attach(sizelabel, 1, 2, 5, 6, FILL, 0, 5, 5)
        wavtable.attach(self.audiosize, 2, 3, 5, 6, FILL, 0, 5, 5)
        wavframe.add(wavtable)

        burnbox.pack_start(wavframe)

        frame.add(burnbox)

    # Play an audio file using xmms
    def PlayAudioFile(self, args):
        if (len(self.songlist.selection) == 0) and (self.songlist.focus_row < 0):
            GnomeErrorDialog("No audio file selected for playing")
            return

        if (len(self.songlist.selection) == 0):
            myselection = [self.songlist.focus_row]
        else:
            myselection = self.songlist.selection

        audiofiles = ""
        oggfile = FALSE
        for i in myselection:
            filename = self.songlist.get_text(i, 2)
            if (lower(os.path.splitext(filename)[1]) == ".ogg"):
                oggfile = TRUE
            audiofiles = "%s \"%s\"" % (audiofiles, filename)

        active_player = self.playermenu.get_active_item()
        if (active_player == playerXMMS):
            command = "xmms %s &" % audiofiles
        elif (active_player == playerMpg123):
            if (oggfile == TRUE):
                GnomeErrorDialog("Sorry, you cannot play ogg files with mpg123.")
                return
            command = "mpg123 %s &" % audiofiles
        elif (active_player == playerFreeAmp):
            command = "freeamp %s &" % audiofiles

        system(command)

    # Import XMMS Playlist files
    def ImportXMMSPlaylist(self, args):
        self.importwin = GnomeFileSelection(filetypes = [XMMS_PLAYLISTS], icondir = iconpath, loglevel = self.cat.get_loglevel(), multiselection = FALSE)
        self.importwin.use_lastdirectory("%s/%s/lastdirectory.import_xmms" % (environ["HOME"], configdirectory))
        self.importwin.load_shortcuts_from_file("%s/%s/%s" % (environ["HOME"], configdirectory, shortcutfile))
        self.importwin.ok_button.connect("clicked", self.ReadXMMSPlaylistFile)
        self.importwin.close_button.connect("clicked", self.importwin.destroy)
        self.importwin.show()

    def ReadXMMSPlaylistFile(self, args):
        filename = "%s/%s" % (self.importwin.get_directory(), self.importwin.get_filenames())
        self.importwin.destroy()
        file = open(filename, "r")
        filenames = striplist(file.readlines())
        file.close()
        for i in range(len(filenames)):
            if (os.path.exists(filenames[i])):
                self.AddFileToList(filenames[i])
            else:
                self.cat.error("File doesn't exist: %s" % filenames[i])

    # Create frame for special operations on CDs
    def SpecialOperation(self, frame):
        burnbox = GtkVBox(spacing = 5)
        burnbox.set_border_width(5)
        burnbox.show()

        blankfrm = GtkFrame(" Select operation ")
        blankfrm.set_shadow_type(SHADOW_ETCHED_OUT)
        blankfrm.show()

        self.blankDisc = GtkRadioButton(None, "Erase disc [full]")
        self.blankDisc.show()
        self.blankMinimal = GtkRadioButton(self.blankDisc, "Erase disc [minimal] (PMA, TOC, pregap)")
        self.blankMinimal.show()
        self.blankSession = GtkRadioButton(self.blankMinimal, "Erase last session")
        self.blankSession.show()
        self.fixate = GtkRadioButton(self.blankSession, "Fixate CD")
        self.fixate.show()
        self.writeTOC = GtkRadioButton(self.fixate, "Write TOC")
        self.writeTOC.set_sensitive(FALSE)
        self.writeTOC.show()

        blankTable = GtkTable(3,2)
        blankTable.attach(self.blankDisc, 0, 1, 0, 1, FILL, 0, 5)
        blankTable.attach(self.blankMinimal, 0, 1, 1, 2, FILL, 0, 5)
        blankTable.attach(self.blankSession, 0, 1, 2, 3, FILL, 0, 5)
        blankTable.attach(self.fixate, 1, 2, 0, 1, FILL, 0, 5)
        blankTable.attach(self.writeTOC, 1, 2, 1, 2, FILL, 0, 5)
        blankTable.show()

        blankfrm.add(blankTable)

        miscfrm = GtkFrame()
        miscfrm.set_shadow_type(SHADOW_ETCHED_OUT)
        miscfrm.show()

        blankBtn = GtkButton(" Perform special operation ")
        blankBtn.connect('clicked', self.PerformSpecialOperation)
        blankBtn.show()

        btnbox = GtkHBox(spacing = 5)
        btnbox.set_border_width(5)
        btnbox.show()

        leftlabel = GtkLabel()
        leftlabel.show()

        rightlabel = GtkLabel()
        rightlabel.show()

        btnbox.pack_start(leftlabel)
        btnbox.pack_start(blankBtn, expand = FALSE)
        btnbox.pack_start(rightlabel)

        miscfrm.add(btnbox)

        burnbox.pack_start(blankfrm, expand = FALSE)
        burnbox.pack_start(miscfrm, expand = FALSE)

        frame.add(burnbox)

    # Really perform special operation on CD now
    def PerformSpecialOperation(self, args):
        if (self.blankDisc.active == 1):
            self.writermode = BlankCDAll
        elif (self.blankMinimal.active == 1):
            self.writermode = BlankCDMinimal
        elif (self.blankSession.active == 1):
            self.writermode = BlankCDLast
        elif (self.fixate.active == 1):
            self.writermode = modeFixateCD
        elif (self.writeTOC.active == 1):
            return

        self.BurnCDNow()

    # Delete selected files from the list of wavefiles
    def DelFile(self, args):
        if (len(self.songlist.selection) == 0):
            GnomeErrorDialog("You have to select files first!")
        else:
            list = copy.copy(self.songlist.selection)
            list.sort()
            list.reverse()
            for i in range(len(list)):
                filename = self.songlist.get_text(list[i], 2)
                self.totalaudiosize = self.totalaudiosize - self.tracksize[filename]
                self.totaltracklength = self.totaltracklength - self.tracklength[filename]
                self.audiosize.set_text(nicetime(self.totaltracklength))

                del self.tracksize[filename]
                del self.tracklength[filename]
                self.songlist.remove(list[i])

                # Renumber files
                line = list[i]
                try:
                    index = self.songlist.get_text(line, 1)
                except:
                    index = None
                while (index != None):
                    self.songlist.set_text(line, 1, str(int(self.songlist.get_text(line, 1)) - 1))
                    line = line + 1
                    try:
                        index = self.songlist.get_text(line, 1)
                    except:
                        index = None

    # Add audio files to audio list
    def AddAudioFileToList(self, args):
        filenames = self.addfilewin.get_filenames()
        self.songlist.freeze()
        for i in range(len(filenames)):
            self.AddFileToList("%s/%s" % (self.addfilewin.get_directory(), filenames[i]))
        self.ColorizeCList(self.songlist)
        self.songlist.thaw()

    # Actually add the file to the list
    def AddFileToList(self, filename):
        filename = strip(filename)
        found = FALSE
        for i in range(self.songlist.rows):
            listname = self.songlist.get_text(i, 2)
            if (listname == filename):
                found = TRUE

        if (found == FALSE):
            filesize = os.path.getsize(filename)
            self.totalaudiosize = self.totalaudiosize + filesize
            seconds = self.GetAudioTrackLength(filename)
            self.tracksize[filename] = filesize
            self.tracklength[filename] = seconds
            self.totaltracklength = self.totaltracklength + seconds
            playtime = nicetime(seconds)
            self.songlist.append([ "", str(self.songlist.rows + 1), filename, playtime])
            self.songlist.set_pixmap((self.songlist.rows - 1), 0, get_file_icon(filename, self.window, iconpath))
            self.audiosize.set_text(nicetime(self.totaltracklength))

    # Converts a mp3-file to a wav-file
    def ConvertMp3ToWav(self):

        if (self.convmp3wav.active):

            imagepath = self.imageentry.gtk_entry().get_text()
            if (imagepath == ""):
                GnomeErrorDialog("Please select a image path in the preferences tab first !")
                return FALSE
            mp3count = 0
            line = 0
            try:
                filename = self.songlist.get_text(line, 2)
            except:
                filename = None
            while (filename != None):
                if (lower(filename[-4:]) == ".mp3") or (lower(filename[-4:]) == ".ogg"):
                    mp3count = mp3count + 1
                line = line + 1
                try:
                    filename = self.songlist.get_text(line, 2)
                except:
                    filename = None

            self.cat.debug("Converting %d file(s) now" % mp3count)

            if (mp3count > 0):
                win = GnomeProgressBar("ECLiPt Roaster Info", "Converting %d wav-, ogg- and mp3-files to wav-files." % mp3count, mp3count)

                line = 0
                try:
                    filename = self.songlist.get_text(line, 2)
                except:
                    filename = None
                while (filename != None):

                    if (lower(filename[-4:]) == ".mp3") or (lower(filename[-4:]) == ".ogg"):
                        tracklength = self.songlist.get_text(line, 3)
                        if (imagepath[-1] == "/"):
                            wavfilename = "%s%s.wav" % (imagepath, os.path.basename(filename)[:-4])
                        else:
                            wavfilename = "%s/%s.wav" % (imagepath, os.path.basename(filename)[:-4])

                        if (lower(filename[-4:]) == ".mp3"):
                            command = "(mpg123 --stereo -s \"%s\" | sox -t raw -r 44100  -w -s -c 2 - -t wav \"%s\") 2>&1" % (escapedfilename(filename), escapedfilename(wavfilename))
                        elif (lower(filename[-4:]) == ".ogg"):
                            command = "ogg123 -d wav -f \"%s\" \"%s\" 2>&1" % (escapedfilename(wavfilename), escapedfilename(filename))
                        self.cat.debug("Executing: %s" % command)
                        output = cmdoutput(command, strip = TRUE)

                        if (lower(filename[-4:]) == ".mp3"):
                            result = listmatch(output, ".*Decoding.*finished")
                        elif (lower(filename[-4:]) == ".ogg"):
                            result = listmatch(output, ".*Done.")

                        if (result[0] == -1):
                            win.close()
                            win = None
                            if (lower(filename[-4:]) == ".mp3"):
                                result = listmatch(output, "Playing")
                                output = output[result[0]:]
                            GnomeErrorDialog("An error occured while decoding \"%s\":\n\n%s" % (filename, join(output, "\n")))
                            return FALSE

                        self.songlist.remove(line)
                        self.songlist.insert(line, [ "", str(line + 1), wavfilename, tracklength])
                        self.songlist.set_pixmap(line, 0, get_file_icon(wavfilename, self.window, iconpath))

                        # Correct filesize
                        self.totalaudiosize = self.totalaudiosize - self.tracksize[filename]
                        filesize = os.path.getsize(wavfilename)
                        self.tracksize[wavfilename] = filesize
                        self.tracklength[wavfilename] = self.tracklength[filename]
                        self.totalaudiosize = self.totalaudiosize + self.tracksize[wavfilename]

                        del self.tracksize[filename]
                        del self.tracklength[filename]

                        win.update()

                    line = line + 1
                    try:
                        filename = self.songlist.get_text(line, 2)
                    except:
                        filename = None

                win.update()
                win.close()
                win = None
  
        return TRUE
    
    # Open the file window to select a list of wavefiles
    def AddFile(self, args):
        self.addfilewin = GnomeFileSelection(filetypes = [AUDIO_FILES, ALL_FILES], icondir = iconpath, loglevel = self.cat.get_loglevel())
        self.addfilewin.use_lastdirectory("%s/%s/lastdirectory.audio" % (environ["HOME"], configdirectory))
        self.addfilewin.load_shortcuts_from_file("%s/%s/%s" % (environ["HOME"], configdirectory, shortcutfile))
        self.addfilewin.ok_button.connect("clicked", self.AddAudioFileToList)
        self.addfilewin.close_button.connect("clicked", self.addfilewin.destroy)
        self.addfilewin.show()

    # Drag & Drop - Add file to the datafile window
    def DragDataReceive(self, window, context, x, y, data, info, time):
        filenames = cleanlist(split(data.data,"\n"))
        self.datafiles.freeze()
        for i in range(len(filenames)):
            if (filenames[i][:5] == "file:"):
                filenames[i] = filenames[i][5:]
            filenames[i] = replace(filenames[i], "%20", " ")
            filenames[i] = replace(filenames[i], "\000", "")
            filenames[i] = strip(filenames[i])
            basename = strip(os.path.basename(filenames[i]))
            if (filenames[i][0] == "/") and (basename != "") and (basename != ".") and (basename != ".."):
                self.AddDataFileToList(filenames[i])
        self.ColorizeCList(self.datafiles)
        self.datafiles.thaw()

    def AddDataFileFromDialogToList(self, args):
        filenames = self.adddatawin.get_filenames()
        self.datafiles.freeze()
        for i in range(len(filenames)):
            self.AddDataFileToList("%s/%s" % (self.adddatawin.get_directory(), filenames[i]))
        self.ColorizeCList(self.datafiles)
        self.datafiles.thaw()

    def ColorizeCList(self, clist):
        for i in range(clist.rows):
            if (divmod(i, 2)[1] == 1):
                gdkcolor = hex2gdkcolor(self.window, "#ffffff")
            else:
                gdkcolor = hex2gdkcolor(self.window, "#f6f6f6")
            if (gdkcolor != None):
                clist.set_background(i, gdkcolor)

    # Add Files to the Datafile list
    def AddDataFileToList(self, filename):
        filename = strip(filename)
        found = FALSE
        for i in range(self.datafiles.rows):
            listname = self.datafiles.get_text(i, 1)
            if (listname == filename):
                found = TRUE

        if (found == FALSE):
            if filename[-1] == "\000":
                filename = filename[:-1]
            if (os.path.exists(filename)):
                try:
                    size = du(filename) / 1024
                    self.totaldatasize = self.totaldatasize + size
                    self.datafilesize[filename] = size
                    statinfo = os.stat(filename)
                    self.datafiles.append(["", filename, "%.0f KB" % size, asctime(localtime(statinfo[8]))])
                    self.datafiles.set_pixmap((self.datafiles.rows - 1), 0, get_file_icon(filename, self.window, iconpath))
                    self.datasize.set_text("%.0f MB" % (round(self.totaldatasize / 1024.0)))
                except:
                    GnomeErrorDialog("Warning: Can't stat \"%s\"!" % filename)
            else:
                GnomeErrorDialog("Warning: \"%s\" doesn't exist!" % filename)

    # Open the file window to select a list of wavefiles
    def AddDataFile(self, args):
        self.adddatawin = GnomeFileSelection(icondir = iconpath, loglevel = self.cat.get_loglevel())
        self.adddatawin.use_lastdirectory("%s/%s/lastdirectory.files" % (environ["HOME"], configdirectory))
        self.adddatawin.load_shortcuts_from_file("%s/%s/%s" % (environ["HOME"], configdirectory, shortcutfile))
        self.adddatawin.ok_button.connect("clicked", self.AddDataFileFromDialogToList)
        self.adddatawin.close_button.connect("clicked", self.adddatawin.destroy)
        self.adddatawin.show()

    # Delete files from the data file selection
    def DelDataFile(self, args):
        if (len(self.datafiles.selection) == 0):
            GnomeErrorDialog("You have to select files/directories first!")
        else:
            list = copy.copy(self.datafiles.selection)
            list.sort()
            list.reverse()
            for i in range(len(list)):
                filename = self.datafiles.get_text(list[i], 1)
                size = self.datafilesize[filename]
                self.totaldatasize = self.totaldatasize - size
                self.datasize.set_text("%d MB" % (round(self.totaldatasize / 1024.0)))
                del self.datafilesize[filename]
                self.datafiles.remove(list[i])

    # Select a data row
    def DataSelectRow(self, clist, row, column, event):
        if ((event == None) or
            ((event.type != GDK._2BUTTON_PRESS) and (event.type != GDK._3BUTTON_PRESS))):
            size = atoi(self.datafiles.get_text(row, 2)[:-3])
            self.selecteddatasize = self.selecteddatasize + size
            self.datasizesel.set_text("%d MB" % round(float(self.selecteddatasize) / 1024))

    # Unselect a data row
    def DataUnselectRow(self, clist, row, column, event):
        size = atoi(self.datafiles.get_text(row, 2)[:-3])
        self.selecteddatasize = self.selecteddatasize - size
        self.datasizesel.set_text("%d MB" % round(float(self.selecteddatasize) / 1024))

    # Calculate & select optimal directories
    def CalculateOptimize(self, args):
        maxsize = 0
        self.datafiles.unselect_all()
        if (self.cdsize650.active):
            maxsize = 650 * 1024
        elif (self.cdsize700.active):
            maxsize = 700 * 1024
        if (self.totaldatasize <= maxsize):
            self.datafiles.select_all()
        else:

            # Insert size & filename into a valuable data structure
            sizefilename = {}
            sizelist = []
            line = 0
            try:
                name = self.datafiles.get_text(line, 1)
                filename = self.datafiles.get_text(line, 1)
                size = self.datafilesize[filename]
            except:
                name = None
            while (name != None):
                if sizefilename.has_key(size):
                    sizefilename[size].append(name)
                else:
                    sizefilename[size] = [name]
                    sizelist.append(size)
                line = line + 1
                try:
                    name = self.datafiles.get_text(line, 1)
                    size = atoi(self.datafiles.get_text(line, 2)[:-3])
                except:
                    name = None
            sizelist.sort()
            sizelist.reverse()

            # Move through all available sizes
            selectedsize = 0
            selectedfilenames = []
            for i in range(len(sizelist)):
                size = sizelist[i]
                filenames = sizefilename[size]
                for j in range(len(filenames)):
                    filename = filenames[j]
                    if ((selectedsize + size) <= maxsize):
                        selectedsize = selectedsize + size
                        selectedfilenames.append(filename)

            # Select files
            line = 0
            try:
                name = self.datafiles.get_text(line, 1)
            except:
                name = None
            while (name != None):
                if (name in selectedfilenames):
                    self.datafiles.select_row(line, 1)
                line = line + 1
                try:
                    name = self.datafiles.get_text(line, 1)
                except:
                    name = None

    # Burn Data CDs
    def BurnData(self, frame):
        burnbox = GtkVBox(spacing = 5)
        burnbox.show()

        # Volume ID
        volumeframe = GtkFrame(" Volume ID ")
        volumeframe.set_border_width(5)
        volumeframe.set_shadow_type(SHADOW_ETCHED_OUT)
        volumeframe.show()

        # Create a table containing the Volume ID
        volumetab = GtkTable(1, 2)
        volumetab.show()

        label = GtkLabel("Enter Volume ID: ")
        label.show()

        self.volumeid = GtkEntry()
        self.volumeid.show()

        volumetab.attach(label, 0, 1, 0, 1, FILL, 0, 5, 5)
        volumetab.attach(self.volumeid, 1, 2, 0, 1, FILL, 0, 5, 5)

        volumeframe.add(volumetab)

        volumebox = GtkHBox(spacing = 0)
        volumebox.show()
        volumebox.pack_start(volumeframe, expand = TRUE)
        volumebox.pack_start(GnomePixmap(self.window, "%s/cdwriter.xpm" % iconpath).get_pixmap(), expand = FALSE)

        burnbox.pack_start(volumebox, expand = FALSE)

        # Create some fields for selecting the Source Directory & calculating the directory size

        sourceframe = GtkFrame(" Directories ")
        sourceframe.set_border_width(5)
        sourceframe.set_shadow_type(SHADOW_ETCHED_OUT)
        sourceframe.show()

        audiotable = GtkTable(8, 3)
        audiotable.show()

        self.datafiles = GtkCList(4, [ "", " Files / Directories ", " Size ", " Last modified "])
        self.datafiles.show()
        self.datafiles.connect("select_row", self.DataSelectRow)
        self.datafiles.connect("unselect_row", self.DataUnselectRow)
        self.datafiles.connect("drag_data_received", self.DragDataReceive)
        self.datafiles.drag_dest_set(DEST_DEFAULT_DROP | DEST_DEFAULT_MOTION, targets, GDK.ACTION_COPY | GDK.ACTION_MOVE)
        self.datafiles.set_selection_mode(SELECTION_EXTENDED)
        self.datafiles.set_column_width(0, 18)
        self.datafiles.set_column_width(1, 260)
        self.datafiles.set_column_width(2, 80)
        self.datafiles.set_column_width(3, 155)
        self.datafiles.set_column_justification(2, JUSTIFY_RIGHT)
        self.datafiles.set_column_justification(3, JUSTIFY_RIGHT)
        self.datafiles.set_auto_sort(TRUE)

        listwin = GtkScrolledWindow()
        listwin.set_policy(POLICY_AUTOMATIC, POLICY_AUTOMATIC)
        listwin.add(self.datafiles)
        listwin.show()

        adddirbtn = GtkButton(" Add File(s) ")
        adddirbtn.set_usize(105, -1)
        adddirbtn.connect('clicked', self.AddDataFile)
        adddirbtn.show()

        deldirbtn = GtkButton(" Remove File(s) ")
        deldirbtn.set_usize(105, -1)
        deldirbtn.connect('clicked', self.DelDataFile)
        deldirbtn.show()

        calcbtn = GtkButton(" AutoSelect ")
        calcbtn.set_usize(105, -1)
        calcbtn.connect('clicked', self.CalculateOptimize)
        calcbtn.show()

        emptyLabel = GtkLabel()
        emptyLabel.show()

        sizelabel = GtkLabel("Total: ")
        sizelabel.set_alignment(1.0, 0.5)
        sizelabel.show()

        self.datasize = GtkEntry()
        self.datasize.set_editable(FALSE)
        self.datasize.set_usize(60, -1)
        self.datasize.set_text("0 MB")
        self.datasize.show()

        selectsize = GtkLabel("Selected: ")
        selectsize.set_alignment(1.0, 0.5)
        selectsize.show()

        self.datasizesel = GtkEntry()
        self.datasizesel.set_editable(FALSE)
        self.datasizesel.set_usize(60, -1)
        self.datasizesel.set_text("0 MB")
        self.datasizesel.show()

        self.cdsize650 = GtkRadioButton(None, "650 MB")
        self.cdsize650.show()
        self.cdsize700 = GtkRadioButton(self.cdsize650, "700 MB")
        self.cdsize700.show()

        bootablebox = GtkHBox(spacing = 5)
        bootablebox.set_border_width(5)

        self.makebootable = GtkCheckButton("Bootable")
        self.makebootable.connect("clicked", self.BootableClicked)
        self.makebootable.show()
        bootimagelabel = GtkLabel(" Image:")
        bootimagelabel.show()
        self.bootimage = GtkEntry()
        self.bootimage.show()
        bootimagehelp = GtkButton()
        bootimagehelp.add(GnomePixmap(self.window, "%s/help.xpm" % iconpath).get_pixmap())
        bootimagehelp.connect("clicked", self.BootImageClicked)
        bootimagehelp.show()
        bootcataloglabel = GtkLabel(" Catalog:")
        bootcataloglabel.show()
        self.bootcatalog = GtkEntry()
        self.bootcatalog.show()
        bootcataloghelp = GtkButton()
        bootcataloghelp.add(GnomePixmap(self.window, "%s/help.xpm" % iconpath).get_pixmap())
        bootcataloghelp.connect("clicked", self.BootCatalogClicked)
        bootcataloghelp.show()

        bootablebox.pack_start(self.makebootable, expand = FALSE)
        bootablebox.pack_start(bootimagelabel, expand = FALSE)
        bootablebox.pack_start(self.bootimage, expand = FALSE)
        bootablebox.pack_start(bootimagehelp, expand = FALSE)
        bootablebox.pack_start(bootcataloglabel, expand = FALSE)
        bootablebox.pack_start(self.bootcatalog, expand = FALSE)
        bootablebox.pack_start(bootcataloghelp, expand = FALSE)
        bootablebox.show()

        audiotable.attach(listwin, 0, 1, 0, 6, EXPAND|FILL, EXPAND|FILL, 5, 5)
        audiotable.attach(bootablebox, 0, 1, 6, 7, FILL, 0, 0, 0)
        audiotable.attach(adddirbtn, 1, 3, 0, 1, 0, 0, 5, 5)
        audiotable.attach(deldirbtn, 1, 3, 1, 2, 0, 0, 5, 5)
        audiotable.attach(calcbtn, 1, 3, 2, 3, 0, 0, 5, 5)
        audiotable.attach(emptyLabel, 1, 3, 3, 4, 0, EXPAND|FILL, 5)
        audiotable.attach(self.cdsize650, 1, 2, 4, 5, 0, 0)
        audiotable.attach(self.cdsize700, 2, 3, 4, 5, 0, 0)
        audiotable.attach(sizelabel, 1, 2, 5, 6, FILL, 0)
        audiotable.attach(self.datasize, 2, 3, 5, 6, 0, 0, 0, 5)
        audiotable.attach(selectsize, 1, 2, 6, 7, FILL, 0)
        audiotable.attach(self.datasizesel, 2, 3, 6, 7, 0, 0, 5, 5)

        sourceframe.add(audiotable)

        burnbox.pack_start(sourceframe)

        frame.add(burnbox)

    # Perform operations when someone has checked the "Bootable" checkbox
    def BootableClicked(self, args):
        if (self.bootimage.get_text() == ""):
            self.bootimage.set_text("boot/boot.img")
        if (self.bootcatalog.get_text() == ""):
            self.bootcatalog.set_text("boot.catalog")

    def BootImageClicked(self, args):
        GnomeOkDialog("The boot image has to be exactly the size of either a 1.2, 1.44, or\n" + 
                      "a 2.88 meg floppy. You can create such an image with the command\n\n" +
                      "dd if=/dev/fd0 of=boot.img bs=8192\n\n" +
                      "if you have bootable floppy disk. For more information, please check\n" +
                      "the README.eltorito from the mkisofs distribution.")

    def BootCatalogClicked(self, args):
        GnomeOkDialog("The filename you have to enter here is usually \"boot.catalog\".\n" + 
                      "You don't have to create the file yourself, this will be done automatically.")

    # Close the main window (save options first)
    def Destroy(self, args):
        self.SaveOptions()
        self.window.destroy()
        mainquit()

    # Get the information of the image
    def ImageInfo(self, args):
        image = self.cdimage.gtk_entry().get_text()
        if (image == ""):
            GnomeErrorDialog("Please select a image file first.")
            return
        if (not os.path.exists(image)) or (os.path.isdir(image)):
            GnomeErrorDialog("The image file \"%s\" is not valid." % image)
            return
        output = cmdoutput("isoinfo -d -i \"%s\"" % image, TRUE)
        for i in range(len(output)):
            line = output[i]
            if (line[:10] == "System id:"): self.sysidtext.set_text(line[11:])
            elif (line[:10] == "Volume id:"): self.volidtext.set_text(line[11:])
            elif (line[:14] == "Volume set id:"): self.volsettext.set_text(line[15:])
            elif (line[:13] == "Publisher id:"): self.pubidtext.set_text(line[14:])
            elif (line[:15] == "Application id:"): self.appidtext.set_text(line[16:])
            elif (line[:22] == "Logical block size is:"): self.blsizetext.set_text(line[23:])
            elif (line[:15] == "Volume size is:"): self.volsizetext.set_text(line[16:])

    # Delete a CD image
    def DeleteCDImage(self, args):
        image = self.cdimage.gtk_entry().get_text()
        if (not os.path.exists(image)) or (os.path.isdir(image)):
            GnomeErrorDialog("The file \"%s\" doesn't exist." % image)
            return
        dialog = GnomeQuestionDialog("Do you really want to delete this ISO file ?", self.DeleteCDImage_callback)
        result = dialog.run_and_close()
        if (result == YES):
            rm(image)

    # Dummy callback function for the "DeleteCDImage" function
    def DeleteCDImage_callback(self, args):
        return TRUE

    # Browse for a CD Image
    def OpenBrowseCDImage(self, args):
        self.filedialog = GnomeFileSelection(multiselection = FALSE, filetypes = [ISO_IMAGES, ALL_FILES], icondir = iconpath, loglevel = self.cat.get_loglevel())
        self.filedialog.use_lastdirectory("%s/%s/lastdirectory.cdimages" % (environ["HOME"], configdirectory))
        self.filedialog.load_shortcuts_from_file("%s/%s/%s" % (environ["HOME"], configdirectory, shortcutfile))
        self.filedialog.ok_button.connect("clicked", self.SelectImageFile)
        self.filedialog.close_button.connect("clicked", self.filedialog.destroy)
        self.filedialog.show()

    # After browsing for the cd image enter the filename in the entry field
    def SelectImageFile(self, args):
        self.cdimage.gtk_entry().set_text("%s/%s" % (self.filedialog.get_directory(), self.filedialog.get_filenames()))
        self.filedialog.destroy()

    # Write a Image
    def BurnImage(self, frame):

        # Select Image

        # Create a table containing the Image selection
        label = GtkLabel("Select CD Image: ")
        label.show()

        self.cdimage = GnomeEntry("imageentry")
        self.cdimage.set_usize(350, -1)
        self.cdimage.show()

        opencdimage = GtkButton(" Browse ")
        opencdimage.connect('clicked', self.OpenBrowseCDImage)
        opencdimage.show()

        infobutton = GtkButton(" Image info ")
        infobutton.connect('clicked', self.ImageInfo)
        infobutton.show()

        deleteButton = GtkButton(" Delete Image ")
        deleteButton.connect("clicked", self.DeleteCDImage)
        deleteButton.show()

        imagetab = GtkTable(1, 5)
        imagetab.attach(label, 0, 1, 0, 1, FILL, 0, 5, 5)
        imagetab.attach(self.cdimage, 1, 2, 0, 1, FILL, 0, 5, 5)
        imagetab.attach(opencdimage, 2, 3, 0, 1, FILL, 0, 5, 5)
        imagetab.attach(infobutton, 3, 4, 0, 1, FILL, 0, 5, 5)
        imagetab.attach(deleteButton, 4, 5, 0, 1, FILL, 0, 5, 5)
        imagetab.show()

        imageframe = GtkFrame(" ISO Image ")
        imageframe.set_border_width(5)
        imageframe.set_shadow_type(SHADOW_ETCHED_OUT)
        imageframe.add(imagetab)
        imageframe.show()

        # Frame which contains the iso information
        infoframe = GtkFrame(" ISO Information ")
        infoframe.set_border_width(5)
        infoframe.set_shadow_type(SHADOW_ETCHED_OUT)
        infoframe.show()

        sysidlabel = GtkLabel("System ID:")
        sysidlabel.set_alignment(1.0, 0.5)
        sysidlabel.show()

        self.sysidtext = GtkEntry()
        self.sysidtext.set_usize(130, -1)
        self.sysidtext.set_editable(FALSE)
        self.sysidtext.show()

        volidlabel = GtkLabel("Volume ID:")
        volidlabel.set_alignment(1.0, 0.5)
        volidlabel.show()

        self.volidtext = GtkEntry()
        self.volidtext.set_usize(130, -1)
        self.volidtext.set_editable(FALSE)
        self.volidtext.show()

        volsetlabel = GtkLabel("Volume set ID:")
        volsetlabel.set_alignment(1.0, 0.5)
        volsetlabel.show()

        self.volsettext = GtkEntry()
        self.volsettext.set_usize(250, -1)
        self.volsettext.set_editable(FALSE)
        self.volsettext.show()

        pubidlabel = GtkLabel("Publisher ID:")
        pubidlabel.set_alignment(1.0, 0.5)
        pubidlabel.show()

        self.pubidtext = GtkEntry()
        self.pubidtext.set_usize(250, -1)
        self.pubidtext.set_editable(FALSE)
        self.pubidtext.show()

        appidlabel = GtkLabel("Application ID:")
        appidlabel.set_alignment(1.0, 0.5)
        appidlabel.show()

        self.appidtext = GtkEntry()
        self.appidtext.set_usize(350, -1)
        self.appidtext.set_editable(FALSE)
        self.appidtext.show()

        blsizelabel = GtkLabel("Logical block size:")
        blsizelabel.set_alignment(1.0, 0.5)
        blsizelabel.show()

        self.blsizetext = GtkEntry()
        self.blsizetext.set_usize(80, -1)
        self.blsizetext.set_editable(FALSE)
        self.blsizetext.show()

        emptylabel = GtkLabel()
        emptylabel.show()

        volsizelabel = GtkLabel("Volume size:")
        volsizelabel.set_alignment(1.0, 0.5)
        volsizelabel.show()

        self.volsizetext = GtkEntry()
        self.volsizetext.set_usize(180, -1)
        self.volsizetext.set_editable(FALSE)
        self.volsizetext.show()

        infotab = GtkTable(5, 5)
        infotab.attach(sysidlabel, 0, 1, 0, 1, FILL, 0, 5, 5)
        infotab.attach(self.sysidtext, 1, 2, 0, 1, FILL, 0, 5, 5)
        infotab.attach(volidlabel, 2, 3, 0, 1, FILL, 0, 5)
        infotab.attach(self.volidtext, 3, 4, 0, 1, FILL, 0, 5)
        infotab.attach(volsetlabel, 0, 1, 1, 2, FILL, 0, 5)
        infotab.attach(self.volsettext, 1, 4, 1, 2, FILL, 0, 5)
        infotab.attach(pubidlabel, 0, 1, 2, 3, FILL, 0, 5, 5)
        infotab.attach(self.pubidtext, 1, 4, 2, 3, FILL, 0, 5, 5)
        infotab.attach(appidlabel, 0, 1, 3, 4, FILL, 0, 5)
        infotab.attach(self.appidtext, 1, 4, 3, 4, FILL, 0, 5)
        infotab.attach(blsizelabel, 0, 1, 4, 5, FILL, 0, 5, 5)
        infotab.attach(self.blsizetext, 1, 2, 4, 5, FILL, 0, 5, 5)
        infotab.attach(volsizelabel, 2, 3, 4, 5, FILL, 0, 5)
        infotab.attach(self.volsizetext, 3, 4, 4, 5, FILL, 0, 5)
        infotab.show()

        infoframe.add(infotab)

        cuefilelabel = GtkLabel("Cue file:")
        cuefilelabel.show()
        self.cuefile = GnomeEntry("cuefile")
        self.cuefile.set_usize(130, -1)
        self.cuefile.show()
        browsecuefilebutton = GtkButton()
        pixmap = GnomePixmap(self.window, "%s/folder.xpm" % iconpath).get_pixmap()
        browsecuefilebutton.add(pixmap)
        browsecuefilebutton.connect('clicked', self.OpenBrowseCueFilename)
        browsecuefilebutton.show()

        binfilelabel = GtkLabel("Bin file:")
        binfilelabel.show()
        self.binfile = GnomeEntry("binfile")
        self.binfile.set_usize(130, -1)
        self.binfile.show()
        browsebinfilebutton = GtkButton()
        pixmap = GnomePixmap(self.window, "%s/folder.xpm" % iconpath).get_pixmap()
        browsebinfilebutton.add(pixmap)
        browsebinfilebutton.connect('clicked', self.OpenBrowseBinFilename)
        browsebinfilebutton.show()

        basenamelabel = GtkLabel("Basename:")
        basenamelabel.show()
        self.basename = GnomeEntry("binfile")
        self.basename.set_usize(130, -1)
        self.basename.show()
        browsebasenamebutton = GtkButton()
        pixmap = GnomePixmap(self.window, "%s/folder.xpm" % iconpath).get_pixmap()
        browsebasenamebutton.add(pixmap)
        browsebasenamebutton.connect('clicked', self.OpenBrowseBasename)
        browsebasenamebutton.show()

        bincuetoisobox = GtkHBox(spacing = 3)
        bincuetoisobox.set_border_width(3)
        bincuetoisobox.pack_start(cuefilelabel)
        bincuetoisobox.pack_start(self.cuefile)
        bincuetoisobox.pack_start(browsecuefilebutton, expand = FALSE)
        bincuetoisobox.pack_start(binfilelabel)
        bincuetoisobox.pack_start(self.binfile)
        bincuetoisobox.pack_start(browsebinfilebutton, expand = FALSE)
        bincuetoisobox.pack_start(basenamelabel)
        bincuetoisobox.pack_start(self.basename)
        bincuetoisobox.pack_start(browsebasenamebutton, expand = FALSE)
        bincuetoisobox.show()

        labLeft = GtkLabel()
        labLeft.show()
        labRight = GtkLabel()
        labRight.show()

        btnConvertCueToIso = GtkButton(" Start .cue/.bin to .iso conversion ")
        mybchunk = bchunk()
        if (mybchunk.available() == TRUE):
            btnConvertCueToIso.connect('clicked', self.ConvertCueBinToISO)
        else:
            btnConvertCueToIso.set_sensitive(FALSE)
        btnConvertCueToIso.show()

        tabConvert = GtkTable(1, 3)
        tabConvert.attach(labLeft, 0, 1, 0, 1, EXPAND, 0, 5, 5)
        tabConvert.attach(btnConvertCueToIso, 1, 2, 0, 1, 0, 0, 5, 5)
        tabConvert.attach(labRight, 2, 3, 0, 1, EXPAND, 0, 5, 5)
        tabConvert.show()

        bincuevbox = GtkVBox(spacing = 3)
        bincuevbox.pack_start(bincuetoisobox)
        bincuevbox.pack_start(tabConvert)
        bincuevbox.show()

        bincuetoisoframe = GtkFrame(" Convert cue/bin to iso ")
        bincuetoisoframe.set_border_width(5)
        bincuetoisoframe.set_shadow_type(SHADOW_ETCHED_OUT)
        bincuetoisoframe.add(bincuevbox)
        bincuetoisoframe.show()

        burnbox = GtkVBox(spacing = 5)
        burnbox.pack_start(imageframe, expand = FALSE)
        burnbox.pack_start(infoframe, expand = FALSE)
        burnbox.pack_start(bincuetoisoframe, expand = FALSE)
        burnbox.show()

        frame.add(burnbox)

    def ConvertCueBinToISO(self, args):
        """ Convert non-unix .cue/.bin files to .iso files by using bchunk """
        if (self.cuefile.gtk_entry().get_text() == "") or (self.binfile.gtk_entry().get_text() == "") or (self.basename.gtk_entry().get_text() == ""):
            errorDialog = GnomeErrorDialog("You have to select a .cue and .bin file and a basename for the iso files first.")
            errorDialog.run()
        else:
            mybchunk = bchunk()
            mybchunk.set_cue_file(self.cuefile.gtk_entry().get_text())
            mybchunk.set_bin_file(self.binfile.gtk_entry().get_text())
            mybchunk.set_basename(self.basename.gtk_entry().get_text())
            command_line = "%s 2>&1 | %s" % (mybchunk.command_line(), ecat)
            pgb = GnomeProgressBar("ECLiPt Roaster Info", "Converting .cue/.bin files to .iso files - This may take a minute or two...", 1)
            self.cat.debug("Executing %s" % command_line)
            pipe = popen2.popen2(command_line)
            line = None
            while (line != ""):
                line = pipe[0].readline()
            pipe[0].close()
            pipe[1].close()
            pipe = None
            pgb.update()
            pgb.close()
            pgb = None

    # Browse for a cuesheet filename
    def OpenBrowseCueFilename(self, args):
        self.filedialog = GnomeFileSelection(multiselection = FALSE, filetypes = [CUE_SHEETS, ALL_FILES], icondir = iconpath, loglevel = self.cat.get_loglevel())
        self.filedialog.use_lastdirectory("%s/%s/lastdirectory.cuesheets" % (environ["HOME"], configdirectory))
        self.filedialog.load_shortcuts_from_file("%s/%s/%s" % (environ["HOME"], configdirectory, shortcutfile))
        self.filedialog.ok_button.connect("clicked", self.SelectCueFile)
        self.filedialog.close_button.connect("clicked", self.filedialog.destroy)
        self.filedialog.show()

    def SelectCueFile(self, args):
        self.cuefile.gtk_entry().set_text("%s/%s" % (self.filedialog.get_directory(), self.filedialog.get_filenames()))
        self.filedialog.destroy()

    # Browse for a .bin filename
    def OpenBrowseBinFilename(self, args):
        self.filedialog = GnomeFileSelection(multiselection = FALSE, filetypes = [BIN_FILES, ALL_FILES], icondir = iconpath, loglevel = self.cat.get_loglevel())
        self.filedialog.use_lastdirectory("%s/%s/lastdirectory.cuesheets" % (environ["HOME"], configdirectory))
        self.filedialog.load_shortcuts_from_file("%s/%s/%s" % (environ["HOME"], configdirectory, shortcutfile))
        self.filedialog.ok_button.connect("clicked", self.SelectBinFile)
        self.filedialog.close_button.connect("clicked", self.filedialog.destroy)
        self.filedialog.show()

    def SelectBinFile(self, args):
        self.binfile.gtk_entry().set_text("%s/%s" % (self.filedialog.get_directory(), self.filedialog.get_filenames()))
        self.filedialog.destroy()

    # Browse for a .bin filename
    def OpenBrowseBasename(self, args):
        self.filedialog = GnomeFileSelection(multiselection = FALSE, filetypes = [ALL_FILES], icondir = iconpath, loglevel = self.cat.get_loglevel())
        self.filedialog.use_lastdirectory("%s/%s/lastdirectory.basename" % (environ["HOME"], configdirectory))
        self.filedialog.load_shortcuts_from_file("%s/%s/%s" % (environ["HOME"], configdirectory, shortcutfile))
        self.filedialog.ok_button.connect("clicked", self.SelectBasename)
        self.filedialog.close_button.connect("clicked", self.filedialog.destroy)
        self.filedialog.show()

    def SelectBasename(self, args):
        self.basename.gtk_entry().set_text("%s/%s" % (self.filedialog.get_directory(), self.filedialog.get_filenames()))
        self.filedialog.destroy()

    # Browse for a filename for reading a CD image
    def OpenBrowseReadCDImage(self, args):
        self.filedialog = GnomeFileSelection(multiselection = FALSE, filetypes = [ISO_IMAGES, ALL_FILES], icondir = iconpath, loglevel = self.cat.get_loglevel())
        self.filedialog.use_lastdirectory("%s/%s/lastdirectory.cdimages" % (environ["HOME"], configdirectory))
        self.filedialog.load_shortcuts_from_file("%s/%s/%s" % (environ["HOME"], configdirectory, shortcutfile))
        self.filedialog.ok_button.connect("clicked", self.SelectReadImageFile)
        self.filedialog.close_button.connect("clicked", self.filedialog.destroy)
        self.filedialog.show()

    # After browsing for the cd image enter the filename in the entry field
    def SelectReadImageFile(self, args):
        self.readcdimage.gtk_entry().set_text("%s/%s" % (self.filedialog.get_directory(), self.filedialog.get_filenames()))
        self.filedialog.destroy()

    # Create a Frame for reading CDs
    def ReadCDFrame(self, frame):
        readCDbox = GtkVBox(spacing = 5)
        readCDbox.show()

        # Frame containing a button for reading a image
        readlabel = GtkLabel("Image filename: ")
        readlabel.show()

        readframe = GtkFrame(" Read ISO Image ")
        readframe.set_border_width(5)
        readframe.set_shadow_type(SHADOW_ETCHED_OUT)
        readframe.show()

        readtab = GtkTable(1, 4)
        readtab.show()

        self.readcdimage = GnomeEntry("readimageentry")
        self.readcdimage.set_usize(350, -1)
        self.readcdimage.show()

        browsecdbutton = GtkButton(" Browse ")
        browsecdbutton.connect('clicked', self.OpenBrowseReadCDImage)
        browsecdbutton.show()
        
        readbutton = GtkButton(" Read Image ")
        readbutton.connect('clicked', self.ReadImage)
        readbutton.show()

        readtab.attach(readlabel, 0, 1, 0, 1, FILL, 0, 5, 5)
        readtab.attach(self.readcdimage, 1, 2, 0, 1, FILL, 0, 5, 5)
        readtab.attach(browsecdbutton, 2, 3, 0, 1, FILL, 0, 5, 5)
        readtab.attach(readbutton, 3, 4, 0, 1, FILL, 0, 5, 5)

        readframe.add(readtab)
        
        readCDbox.pack_start(readframe, expand = FALSE)

        readaudioframe = GtkFrame(" Read Audio Files ")
        readaudioframe.set_border_width(5)
        readaudioframe.set_shadow_type(SHADOW_ETCHED_OUT)
        readaudioframe.show()

        self.readaudiowin = GtkScrolledWindow()
        self.readaudiowin.set_policy(POLICY_AUTOMATIC, POLICY_ALWAYS)
        self.readaudiowin.show()

        btnReadContent = GtkButton(" Read Content ")
        btnReadContent.set_usize(95, -1)
        btnReadContent.connect('clicked', self.ReadAudioContent)
        btnReadContent.show()

        btnReadCD = GtkButton(" Read Songs ")
        btnReadCD.set_usize(95, -1)
        btnReadCD.connect('clicked', self.ReadAudioCD)
        btnReadCD.show()

        self.convwav2mp3 = GtkCheckButton("Convert to mp3")
        check_lame = lame(self.cat.get_loglevel())
        self.convwav2mp3.set_sensitive(check_lame.available())
        self.convwav2mp3.show()

        boxButton = GtkVBox(spacing = 5)
        boxButton.set_border_width(5)
        boxButton.pack_start(btnReadContent, expand = FALSE)
        boxButton.pack_start(btnReadCD, expand = FALSE)
        boxButton.pack_start(self.convwav2mp3, expand = FALSE)
        boxButton.show()

        tracksLabel = GtkLabel("Number of tracks:")
        tracksLabel.show()
        self.tracknumentry = GtkEntry()
        self.tracknumentry.set_usize(30, -1)
        self.tracknumentry.set_text("0")
        self.tracknumentry.set_editable(FALSE)
        self.tracknumentry.show()

        lengthLabel = GtkLabel("Total time:")
        lengthLabel.show()
        self.totaltime = GtkEntry()
        self.totaltime.set_usize(60, -1)
        self.totaltime.set_text("00:00:00")
        self.totaltime.set_editable(FALSE)
        self.totaltime.show()

        cdnameLabel = GtkLabel("CD Title:")
        cdnameLabel.show()
        self.cddb_title = GtkEntry()
        self.cddb_title.set_usize(250, -1)
        self.cddb_title.set_editable(FALSE)
        self.cddb_title.show()

        boxTrackInfo = GtkHBox(spacing = 5)
        boxTrackInfo.set_border_width(5)
        boxTrackInfo.pack_start(tracksLabel, expand = FALSE)
        boxTrackInfo.pack_start(self.tracknumentry, expand = FALSE)
        boxTrackInfo.pack_start(lengthLabel, expand = FALSE)
        boxTrackInfo.pack_start(self.totaltime, expand = FALSE)
        boxTrackInfo.pack_start(cdnameLabel, expand = FALSE)
        boxTrackInfo.pack_start(self.cddb_title, expand = FALSE)
        boxTrackInfo.show()

        boxCDInfo = GtkHBox(spacing = 5)
        boxCDInfo.set_border_width(5)
        boxCDInfo.pack_start(self.readaudiowin)
        boxCDInfo.pack_start(boxButton, expand = FALSE)
        boxCDInfo.show()

        self.boxTracks = GtkVBox(spacing = 2)
        self.boxTracks.set_border_width(5)
        self.boxTracks.show()

        self.readaudiowin.add_with_viewport(self.boxTracks)
    
        boxReadAudioCD = GtkVBox()
        boxReadAudioCD.pack_start(boxTrackInfo, expand = FALSE)
        boxReadAudioCD.pack_start(boxCDInfo)
        boxReadAudioCD.show()

        readaudioframe.add(boxReadAudioCD)

        readCDbox.pack_start(readaudioframe)

        self.audiotracklist = []

        frame.add(readCDbox)

    # Query the CDDB Server and return an array of track names
    def QueryCDDB(self):
        self.cat.debug("Querying CDDB Server")
        try:
            cdrom = DiscID.open(self.devReader.get_text())
            disc_id = DiscID.disc_id(cdrom)
        except:
            self.cat.warn("Couldn't open CD")
            # errorDialog = GnomeErrorDialog("An error occured while reading CD.")
            # errorDialog.run()
            return {}

        try:
            (query_stat, query_info) = CDDB.query(disc_id)
        except:
            self.cat.warn("Couldn't query CDDB server")
            return {}

        success = FALSE
        if (query_stat == 210) or (query_stat == 211):
            success = TRUE
            query_info = query_info[0]
        elif (query_stat == 200):
            success = TRUE

        if (success == TRUE):                 # Query successful
            self.cddb_title.set_text(query_info["title"])
            (read_stat, read_info) = CDDB.read(query_info['category'], query_info['disc_id'])
            if (read_stat == 210):
                tracks = {}
                for i in range(0, disc_id[1]):
                    tracks[i + 1] = read_info['TTITLE' + `i`]
                return tracks
            else:                               # Couldn't read track info
                return {}
        else:
            errorDialog = GnomeErrorDialog("CDDB info not available for this CD.")
            errorDialog.run()
            return {}                           # Couldn't query cddb server

    def ReadAudioCD(self, args):
        if (self.imageentry.gtk_entry().get_text() == ""):
            GnomeErrorDialog("Please select a image path in the preferences tab first !")
            return
        self.writermode = modeReadAudioCD
        if (self.convwav2mp3.get_active()):
            mylame = lame(self.cat.get_loglevel())
            mylame.set_source("-")
            mylame.set_target("\"%s/Track-%d.mp3\"")
            command = "(cdda2wav -D %d,%d,%d -x -B -H -g -O wav -t %%d+%%d - | %s) 2>&1 | %s" % ( int(self.channelReader.get_text()), int(self.idReader.get_text()), int(self.lunReader.get_text()), mylame.command_line(), ecat)
        else:
            command = "cdda2wav -D %d,%d,%d -x -B -H -g -O wav -t %%d+%%d \"%%s/Track-%%d.wav\" 2>&1 | %s" % ( int(self.channelReader.get_text()), int(self.idReader.get_text()), int(self.lunReader.get_text()), ecat)
        self.BurnWindow(command)

    # Get Content of a Audio-CD
    def ReadAudioContent(self, args):
        self.cddb_title.set_text("")
        if (cddb_available == TRUE):
            self.cddb_info = self.QueryCDDB()
        else:
            self.cddb_info = {}
        command = "cdda2wav -D %s,%s,%s -N -J -v 2 -g -Q 2>&1" % (self.channelReader.get_text(), self.idReader.get_text(), self.lunReader.get_text())
        self.cat.debug("Executing %s" % command)
        output = cmdoutput(command)
        boolTrackInfo = FALSE
        self.audiotracklist = []
        self.readaudiowin.remove(self.readaudiowin.children()[0])
        self.boxTracks = GtkVBox(spacing = 2)
        self.boxTracks.set_border_width(5)
        for i in range(len(output)):
            line = output[i]
            if (line != ""):
                if (match("Tracks.*", line)):
                    splitted = split(line[7:], " ")
                    self.tracknumentry.set_text(splitted[0])
                    self.totaltime.set_text(strip(splitted[1]))
                elif (match("T\d.*", line)):
                    tracknum = atoi(line[1:3])
                    length = strip(line[13:21])
                    if (self.cddb_info.has_key(tracknum)):
                        trackString = "%s - %s - Length: %s" % (zfill(tracknum, 2), self.cddb_info[tracknum], length)
                    else:
                        trackString = "Track: %s - Length: %s" % (zfill(tracknum, 2), length)
                    self.audiotracklist.append(GtkCheckButton(trackString))
                    self.audiotracklist[tracknum - 1].show()
                    self.boxTracks.pack_start(self.audiotracklist[tracknum - 1])
                elif (match(".*Permission.*denied.*", line)):
                    GnomeErrorDialog("Permission denied while trying to read the CD content")

        self.boxTracks.show()
        self.readaudiowin.add_with_viewport(self.boxTracks)

    # Create a frame for copying a CD
    def CopyCDFrame(self, frame):

        labwarning = GtkLabel("Direclty copying a CD might not be a good idea, if your computer " +
                              "is slow, the source CD is scratched, \nthe magnetic radiation of your heater is " +
                              "too extreme or your wife has a bad day, so everything you do here is at \nyour " +
                              "own risk !")
        labwarning.set_justify(JUSTIFY_LEFT)
        labwarning.show()

        frmWarning = GtkFrame(" Warning ")
        frmWarning.set_shadow_type(SHADOW_ETCHED_OUT)
        frmWarning.add(labwarning)
        frmWarning.show()
        
        labLeft = GtkLabel()
        labLeft.show()
        labRight = GtkLabel()
        labRight.show()

        btnPerformCopy = GtkButton()
        box = GnomePixmapWithLabel(self.window, "%s/copy.xpm" % iconpath, " Perform direct CD-copy ").get_hbox()
        btnPerformCopy.add(box)
        btnPerformCopy.connect('clicked', self.BurnCD)
        btnPerformCopy.show()

        tabCopyCD = GtkTable(1, 3)
        tabCopyCD.attach(labLeft, 0, 1, 0, 1, EXPAND, 0, 5, 5)
        tabCopyCD.attach(btnPerformCopy, 1, 2, 0, 1, 0, 0, 5, 5)
        tabCopyCD.attach(labRight, 2, 3, 0, 1, EXPAND, 0, 5, 5)
        tabCopyCD.show()

        frmBurn = GtkFrame()
        frmBurn.set_shadow_type(SHADOW_ETCHED_OUT)
        frmBurn.add(tabCopyCD)
        frmBurn.show()

        copyCDbox = GtkVBox(spacing = 5)
        copyCDbox.set_border_width(5)
        copyCDbox.pack_start(frmWarning, expand = FALSE)
        copyCDbox.pack_start(frmBurn, expand = FALSE)
        copyCDbox.show()

        frame.add(copyCDbox)

    # Read a CD
    def ReadImage(self, args):
        readimage = self.readcdimage.gtk_entry().get_text()
        if (readimage == ""):
            GnomeErrorDialog("Please enter a filename for the image file first.")
            return

        command = "readcd -dev=%d,%d,%d f=\"%s\" 2>&1 | %s" % ( int(self.channelReader.get_text()), int(self.idReader.get_text()), int(self.lunReader.get_text()), readimage, ecat)
        self.writermode = modeReadCD
        self.BurnWindow(command)

    # Returns the length of a mp3/wav file in seconds
    def GetAudioTrackLength(self, filename):
        seconds = 0
        if (lower(filename[-4:]) == ".mp3"):
            mpeginfo = mp3info.MP3Info(filename)
            mpeginfo.ReadData()
            seconds = int(mpeginfo.MPEGData["Duration"])
            del mpeginfo

        elif (lower(filename[-4:]) == ".ogg"):
            output = cmdoutput("ogginfo \"%s\"" % filename, TRUE)
            result = listmatch(output, "length")
            match = re.search(r"length=(.*)\.", result[1])
            if (match):
                seconds = int(match.group(1))

        else:
            try:
                wavefile = wave.open(filename, "r")
                seconds = wavefile.getnframes() / wavefile.getframerate ()
                wavefile.close()
            except:
                GnomeErrorDialog("An error occured when getting the track length of the wav file \"%s\"" % filename)
        return seconds

    # Select all files either in the audio track or data track window
    def SelectAll(self, args):
        page = self.notebook.get_current_page()
        if (frames[page] == datacd):
            self.datafiles.select_all()
        elif (frames[page] == audiocd):
            self.songlist.select_all()
        elif (frames[page] == readcd):
            for i in range(len(self.audiotracklist)):
                self.audiotracklist[i].set_active(1)

    # UnSelect all files either in the audio track or data track window
    def UnSelectAll(self, args):
        page = self.notebook.get_current_page()
        if (frames[page] == datacd):
            self.datafiles.unselect_all()
        elif (frames[page] == audiocd):
            self.songlist.unselect_all()
        elif (frames[page] == readcd):
            for i in range(len(self.audiotracklist)):
                self.audiotracklist[i].set_active(0)

    # Parse command line parameters
    def parsecmdline(self):
        self.startup_burnmode = None
        self.startup_burnfiles = None
        try:
            optlist, args = getopt.getopt(sys_argv[1:], 'dh', ["debug", "help", "data", "audio", "copy", "image"])

            for flag, arg in optlist:
                if (flag == "-d") or (flag == "--debug"):
                    self.cat.set_loglevel(log4py.LOGLEVEL_DEBUG)
                elif (flag == "-h") or (flag == "--help"):
                    self.cat.info("Usage: eroaster [options] [files]")
                    self.cat.info("Options:")
                    self.cat.info("      --audio   use [files] to burn a audio CD.")
                    self.cat.info("      --copy    perform a direct CD copy.")
                    self.cat.info("      --data    use [files] to burn a data CD.")
                    self.cat.info("  -d, --debug   debug mode (be very verbose).")
                    self.cat.info("  -h, --help    print this help.")
                    self.cat.info("      --image   burn an image to CD.")
                    sys.exit(0)
                elif (flag == "--data"):
                    self.startup_burnmode = eraDataCD
                    self.startup_burnfiles = args
                elif (flag == "--audio"):
                    self.startup_burnmode = eraAudioCD
                    self.startup_burnfiles = args
                elif (flag == "--copy"):
                    self.startup_burnmode = eraCopyCD
                    self.startup_burnfiles = args
                elif (flag == "--image"):
                    self.startup_burnmode = eraCDImage
                    self.startup_burnfiles = args
                else:
                    self.cat.error("option %s not recognized" % str(flag))
                    sys.exit(1)

        except getopt.error, detail:
            self.cat.error(detail)
            sys.exit(1)

    # Main loop
    def main(self):
        mainloop()
