/*
 * Copyright (C) 1997-2002, Michael Jennings
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies of the Software, its documentation and marketing & publicity
 * materials, and acknowledgment shall be given in the documentation, materials
 * and software packages that this Software was used.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

static const char cvs_ident[] = "$Id: encoding.c,v 1.5 2002/02/03 20:53:06 mej Exp $";

#include "config.h"
#include "feature.h"

#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <limits.h>

#include "../libast/debug.h"
#include "../libast/mem.h"
#include "../libast/strings.h"
#include "debug.h"
#include "command.h"
#include "encoding.h"
#include "startup.h"
#include "options.h"
#include "screen.h"
#include "term.h"
#include "windows.h"

enc_context_t *encoder = NULL;
static enc_context_t builtin_context_cyrillic, builtin_context_greek_elot_928, builtin_context_greek_ibm_437;

static trans_table_t in_table_iso_8859_5 = {
  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,

  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,

  0x80, 0x81, 0x82, 0x83,  0x84, 0x85, 0x86, 0x87,  0x88, 0x89, 0x8a, 0x8b,  0x8c, 0x8d, 0x8e, 0x8f,
  0x90, 0x91, 0x92, 0x93,  0x94, 0x95, 0x96, 0x97,  0x98, 0x99, 0x9a, 0x9b,  0x9c, 0x9d, 0x9e, 0x9f,
  0xa0, 0xae, 0xfe, 0xf1,  0x20, 0xb3, 0x20, 0xfd,  0xa1, 0x20, 0xa4, 0x8b,  0x20, 0x20, 0x20, 0xa7,
  0x20, 0x20, 0xa6, 0xa1,  0xd3, 0x20, 0x20, 0x20,  0xf1, 0xf0, 0xf4, 0x9b,  0xf8, 0xa5, 0xf5, 0xf7,
                                                    
  0xee, 0xd0, 0xd1, 0xe6,  0xd4, 0xd5, 0xe4, 0xd3,  0xe5, 0xd8, 0xd9, 0xda,  0xdb, 0xdc, 0xdd, 0xde,
  0xdf, 0xef, 0xe0, 0xe1,  0xe2, 0xe3, 0xd6, 0xd2,  0xec, 0xeb, 0xd7, 0xe8,  0xed, 0xe9, 0xe7, 0xea,
  0xce, 0xb0, 0xb1, 0xc6,  0xb4, 0xb5, 0xc4, 0xb3,  0xc5, 0xb8, 0xb9, 0xba,  0xbb, 0xbc, 0xbd, 0xbe,
  0xbf, 0xcf, 0xc0, 0xc1,  0xc2, 0xc3, 0xb6, 0xb2,  0xcc, 0xcb, 0xb7, 0xc8,  0xcd, 0xc9, 0xc7, 0xca
};
                                                    
static trans_table_t out_table_iso_8859_5 = {
  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,

  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,

  0x80, 0x81, 0x82, 0x83,  0x84, 0x85, 0x86, 0x87,  0x88, 0x89, 0x8a, 0x8b,  0x8c, 0x8d, 0x8e, 0x8f,
  0x90, 0x91, 0x92, 0x93,  0x94, 0x95, 0x96, 0x97,  0x98, 0x99, 0x9a, 0x9b,  0x9c, 0x9d, 0x9e, 0x9f,
  0xa0, 0xb3, 0x80, 0x81,  0xaa, 0xbd, 0xb2, 0xaf,  0x4a, 0x8a, 0x8c, 0x8e,  0x8d, 0x20, 0xa1, 0x8f,
  0xe1, 0xe2, 0xf7, 0xe7,  0xe4, 0xe5, 0xf6, 0xfa,  0xe9, 0xea, 0xeb, 0xec,  0xed, 0xee, 0xef, 0xf0,
                                                    
  0xf2, 0xf3, 0xf4, 0xf5,  0xe6, 0xe8, 0xe3, 0xfe,  0xfb, 0xfd, 0xff, 0xf9,  0xf8, 0xfc, 0xe0, 0xf1,
  0xc1, 0xc2, 0xd7, 0xc7,  0xc4, 0xc5, 0xd6, 0xda,  0xc9, 0xca, 0xcb, 0xcc,  0xcd, 0xce, 0xcf, 0xd0,
  0xd2, 0xd3, 0xd4, 0xd5,  0xc6, 0xc8, 0xc3, 0xde,  0xdb, 0xdd, 0xdf, 0xd9,  0xd8, 0xdc, 0xc0, 0xd1,
  0xb9, 0xa3, 0x90, 0x83,  0xba, 0xbe, 0x69, 0xbf,  0xbc, 0x9a, 0x9c, 0x9e,  0x9d, 0xa7, 0xa2, 0x9f
};

static trans_table_t in_table_windows_1251 = {
  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,

  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,

  0x80, 0x81, 0x82, 0x83,  0x84, 0x85, 0x86, 0x87,  0x88, 0x89, 0x8a, 0x8b,  0x8c, 0x8d, 0x8e, 0x8f,
  0x90, 0x91, 0x92, 0x93,  0x94, 0x95, 0x96, 0x97,  0x98, 0x99, 0x9a, 0x9b,  0x9c, 0x9d, 0x9e, 0x9f,
  0xa0, 0xa1, 0xa2, 0xb8,  0xa4, 0xa5, 0xa6, 0xa7,  0x22, 0xa9, 0x20, 0x22,  0x5e, 0x2d, 0xae, 0x7e,
  0xb0, 0xb1, 0x20, 0xa8,  0x27, 0xb5, 0xb6, 0xb7,  0x2c, 0x20, 0x20, 0x22,  0x20, 0x20, 0x20, 0xd7,
                                                    
  0xfe, 0xe0, 0xe1, 0xf6,  0xe4, 0xe5, 0xf4, 0xe3,  0xf5, 0xe8, 0xe9, 0xea,  0xeb, 0xec, 0xed, 0xee,
  0xef, 0xff, 0xf0, 0xf1,  0xf2, 0xf3, 0xe6, 0xe2,  0xfc, 0xfb, 0xe7, 0xf8,  0xfd, 0xf9, 0xf7, 0xfa,
  0xde, 0xc0, 0xc1, 0xd6,  0xc4, 0xc5, 0xd4, 0xc3,  0xd5, 0xc8, 0xc9, 0xca,  0xcb, 0xcc, 0xcd, 0xce,
  0xcf, 0xdf, 0xd0, 0xd1,  0xd2, 0xd3, 0xc6, 0xc2,  0xdc, 0xdb, 0xc7, 0xd8,  0xdd, 0xd9, 0xd7, 0xda
};
                                                    
static trans_table_t out_table_windows_1251 = {
  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,

  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,

  0x80, 0x81, 0x82, 0x83,  0x84, 0x85, 0x86, 0x87,  0x88, 0x89, 0x8a, 0x8b,  0x8c, 0x8d, 0x8e, 0x8f,
  0x90, 0x91, 0x92, 0x93,  0x94, 0x95, 0x96, 0x97,  0x98, 0x99, 0x9a, 0x9b,  0x9c, 0x9d, 0x9e, 0x9f,
  0xa0, 0xa1, 0xa2, 0x4a,  0xa4, 0xe7, 0x7c, 0xa7,  0xb3, 0xa9, 0xe5, 0x22,  0x5e, 0x2d, 0xae, 0x49,
  0xb0, 0xb1, 0x49, 0x69,  0xc7, 0xb5, 0xb6, 0xb7,  0xa3, 0x4e, 0xc5, 0x22,  0x6a, 0x53, 0x73, 0xc0,
                                                    
  0xe1, 0xe2, 0xf7, 0xe7,  0xe4, 0xe5, 0xf6, 0xfa,  0xe9, 0xea, 0xeb, 0xec,  0xed, 0xee, 0xef, 0xf0,
  0xf2, 0xf3, 0xf4, 0xf5,  0xe6, 0xe8, 0xe3, 0xfe,  0xfb, 0xfd, 0xff, 0xf9,  0xf8, 0xfc, 0xe0, 0xf1,
  0xc1, 0xc2, 0xd7, 0xc7,  0xc4, 0xc5, 0xd6, 0xda,  0xc9, 0xca, 0xcb, 0xcc,  0xcd, 0xce, 0xcf, 0xd0,
  0xd2, 0xd3, 0xd4, 0xd5,  0xc6, 0xc8, 0xc3, 0xde,  0xdb, 0xdd, 0xdf, 0xd9,  0xd8, 0xdc, 0xc0, 0xd1
};
                                                    
                                                    
static trans_table_t in_table_alt_866 = {
  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,

  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,

  0x20, 0x20, 0x20, 0x20,  0x20, 0x20, 0x20, 0x20,  0x20, 0x20, 0x20, 0x20,  0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20,  0x20, 0xf9, 0x2d, 0x2d,  0x20, 0x20, 0x20, 0x20,  0x20, 0x20, 0xfa, 0x20,
  0x20, 0x20, 0x20, 0xf1,  0xf5, 0x20, 0x69, 0xf9,  0x20, 0x20, 0x20, 0x20,  0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0xf0,  0xf4, 0x20, 0x49, 0xf8,  0x20, 0xfc, 0x20, 0x20,  0x20, 0x20, 0x20, 0x20,
                                                    
  0xee, 0xa0, 0xa1, 0xe6,  0xa4, 0xa5, 0xe4, 0xa3,  0xe5, 0xa8, 0xa9, 0xaa,  0xab, 0xac, 0xad, 0xae,
  0xaf, 0xef, 0xe0, 0xe1,  0xe2, 0xe3, 0xa6, 0xa2,  0xec, 0xeb, 0xa7, 0xe8,  0xed, 0xe9, 0xe7, 0xea,
  0x9e, 0x80, 0x81, 0x96,  0x84, 0x85, 0x94, 0x83,  0x95, 0x88, 0x89, 0x8a,  0x8b, 0x8c, 0x8d, 0x8e,
  0x8f, 0x9f, 0x90, 0x91,  0x92, 0x93, 0x86, 0x82,  0x9c, 0x9b, 0x87, 0x98,  0x9d, 0x99, 0x97, 0x9a
};
                                                    
static trans_table_t out_table_alt_866 = {
  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,

  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,

  0xe1, 0xe2, 0xf7, 0xe7,  0xe4, 0xe5, 0xf6, 0xfa,  0xe9, 0xea, 0xeb, 0xec,  0xed, 0xee, 0xef, 0xf0,
  0xf2, 0xf3, 0xf4, 0xf5,  0xe6, 0xe8, 0xe3, 0xfe,  0xfb, 0xfd, 0xff, 0xf9,  0xf8, 0xfc, 0xe0, 0xf1,
  0xc1, 0xc2, 0xd7, 0xc7,  0xc4, 0xc5, 0xd6, 0xda,  0xc9, 0xca, 0xcb, 0xcc,  0xcd, 0xce, 0xcf, 0xd0,
  0x02, 0x02, 0x02, 0x19,  0x16, 0x16, 0x16, 0x0c,  0x0c, 0x16, 0x19, 0x0c,  0x0b, 0x0b, 0x0b, 0x0c,
                                                    
  0x0e, 0x17, 0x18, 0x15,  0x12, 0x0f, 0x15, 0x15,  0x0e, 0x0d, 0x17, 0x18,  0x15, 0x12, 0x0f, 0x17,
  0x17, 0x18, 0x18, 0x0e,  0x0e, 0x0d, 0x0d, 0x0f,  0x0f, 0x0b, 0x0d, 0x00,  0x00, 0x00, 0x00, 0x00,
  0xd2, 0xd3, 0xd4, 0xd5,  0xc6, 0xc8, 0xc3, 0xde,  0xdb, 0xdd, 0xdf, 0xd9,  0xd8, 0xdc, 0xc0, 0xd1,
  0xb3, 0xa3, 0x20, 0x20,  0xb4, 0xa4, 0x49, 0x69,  0xb7, 0xa7, 0x20, 0x20,  0xb9, 0x20, 0x20, 0x20
};

static enc_context_t *
enc_create_context(const char *id)
{
  enc_context_t *tmp;

  tmp = (enc_context_t *) MALLOC(sizeof(enc_context_t));
  MEMSET(tmp, 0, sizeof(enc_context_t));
  tmp->id = STRDUP(id);
  return tmp;
}

static void
enc_context_add_state(enc_context_t *context, enc_state_t *state)
{
  ASSERT(context != NULL);
  ASSERT(state != NULL);

  state->next = context->states;
  context->states = state;
}

static enc_state_t *
enc_create_state(const char *id, unsigned char lifetime)
{
  enc_state_t *tmp;

  tmp = (enc_state_t *) MALLOC(sizeof(enc_state_t));
  MEMSET(tmp, 0, sizeof(enc_state_t));
  tmp->id = STRDUP(id);
  tmp->lifetime = lifetime;
  return tmp;
}

static void
enc_state_add_switch(enc_state_t *state, unsigned char key, enc_state_t *next_state)
{
  state_switch_t *stsw;

  stsw = (state_switch_t *) MALLOC(sizeof(state_switch_t));
  stsw->key = key;
  stsw->next_state = next_state;
  stsw->next = state->switches;
  state->switches = stsw;
}

static void
enc_state_set_in_table(enc_state_t *state, trans_table_t in_tbl)
{
  ASSERT(state != NULL);
  state->in_tbl = in_tbl;
}

static void
enc_state_set_out_table(enc_state_t *state, trans_table_t out_tbl)
{
  ASSERT(state != NULL);
  state->out_tbl = out_tbl;
}

void
enc_init(void)
{

}

static void
enc_init_builtins(void)
{
  enc_state_t *st;
  state_switch_t *stsw;

  builtin_context_cyrillic.id = "Cyrillic";
  st = enc_create_state("alt-866", 0);
  enc_state_set_in_table(st, in_table_alt_866);
  enc_state_set_out_table(st, out_table_alt_866);
  enc_context_add_state(&builtin_context_cyrillic, st);
  builtin_context_cyrillic.current = st;

  st = enc_create_state("windows-1251", 0);
  enc_state_set_in_table(st, in_table_windows_1251);
  enc_state_set_out_table(st, out_table_windows_1251);
  enc_state_add_switcher(st, 0x0f, builtin_context_cyrillic.current);
  enc_context_add_state(&builtin_context_cyrillic, st);
  builtin_context_cyrillic.current = st;

  st = enc_create_state("iso-8859-5", 0);
  enc_state_set_in_table(st, in_table_iso_8859_5);
  enc_state_set_out_table(st, out_table_iso_8859_5);
  enc_state_add_switcher(st, 0x0f, builtin_context_cyrillic.current);
  enc_context_add_state(&builtin_context_cyrillic, st);
  builtin_context_cyrillic.current = st;

  st = enc_create_state("koi8-r", 0);
  enc_state_add_switcher(st, 0x0f, builtin_context_cyrillic.current);
  enc_context_add_state(&builtin_context_cyrillic, st);
  builtin_context_cyrillic.current = st;

}
