/*
 * etPan! -- a mail user agent
 *
 * Copyright (C) 2001, 2002 - DINH Viet Hoa
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the libEtPan! project nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * $Id: etpan-cfg-storage.h,v 1.8 2004/11/12 13:57:02 hoa Exp $
 */

#ifndef ETPAN_CFG_STORAGE_DECL_H

#define ETPAN_CFG_STORAGE_DECL_H

#include <libetpan/libetpan.h>
#include "etpan-cfg-storage-types.h"

int etpan_storage_config_read(char * filename,
    struct etpan_storage_config ** result);

struct etpan_storage_config * etpan_storage_config_new(void);

void etpan_storage_config_free(struct etpan_storage_config * config);

struct mailstorage *
etpan_storage_get(struct etpan_storage_config * config, char * name);

int etpan_storage_config_add(struct etpan_storage_config * config,
    struct mailstorage * storage, int generated);

void etpan_storage_config_delete(struct etpan_storage_config * config,
    struct mailstorage * storage);

int etpan_storage_config_replace(struct etpan_storage_config * config,
    unsigned int index,
    struct mailstorage * storage, int generated);

int etpan_storage_config_is_generated(struct etpan_storage_config * config,
    struct mailstorage * storage);

void etpan_storage_config_set_generated(struct etpan_storage_config * config,
    struct mailstorage * storage, int generated);


const char * etpan_cfg_storage_get_connection_type_name(int type);

const char * etpan_cfg_storage_get_imap_auth_name(int type);

const char * etpan_cfg_storage_get_pop3_auth_name(int type);

const char * etpan_cfg_storage_get_nntp_auth_name(int type);

int etpan_cfg_storage_get_type(char * name);

int etpan_cfg_storage_write(char * filename,
    struct etpan_storage_config * config);

#endif
