/*
 * EveryBuddy 
 *
 * Copyright (C) 1999, Torrey Searle <tsearle@uci.edu>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include <gtk/gtk.h>
#include <string.h>
#include "contact.h"
#include "service.h"
#include "status.h"
#include "dialog.h"
#include "util.h"
#include "account.h"

static gint window_open = 0;
static GtkWidget * edit_group_window;
static GtkWidget * group_name;
static grouplist * current_group;

static void destroy( GtkWidget *widget, gpointer data)
{
	window_open = 0;
}

static void ok_callback( GtkWidget * widget, gpointer data)
{
	strcpy(current_group->name, gtk_entry_get_text(GTK_ENTRY(group_name)));

	gtk_label_set_text(GTK_LABEL(current_group->label), current_group->name);	
	MakeEditContactList();
	write_contact_list();
	gtk_widget_destroy(edit_group_window);
}

static void cancel_callback( GtkWidget * widget, gpointer data)
{
	gtk_widget_destroy(edit_group_window);
}

void edit_group_window_new( grouplist * g)
{
	gchar buff[1024];

	if ( !window_open )
	{
		GtkWidget * vbox = gtk_vbox_new( FALSE, 5 );
		GtkWidget * hbox = gtk_hbox_new( FALSE, 5 );
		GtkWidget * label;

		edit_group_window = gtk_window_new(GTK_WINDOW_DIALOG);
		gtk_widget_realize(edit_group_window);

		label = gtk_label_new("Group Name");
		gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 5);
		gtk_widget_show(label);

		group_name = gtk_entry_new();
		gtk_box_pack_start(GTK_BOX(hbox), group_name, TRUE, TRUE, 5);
		gtk_entry_set_text(GTK_ENTRY(group_name), g->name);
		gtk_widget_show(group_name);

		gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 5);
		gtk_widget_show(hbox);

		hbox = gtk_hbox_new(TRUE, 5);

		label = gtk_button_new_with_label("OK");
		gtk_box_pack_start(GTK_BOX(hbox), label, TRUE, TRUE, 5);
		gtk_signal_connect(GTK_OBJECT(label), "clicked",
				GTK_SIGNAL_FUNC(ok_callback), NULL);
		gtk_widget_show(label);

		label = gtk_button_new_with_label("Cancel");
		gtk_box_pack_start(GTK_BOX(hbox), label, TRUE, TRUE, 5);
		gtk_signal_connect(GTK_OBJECT(label), "clicked",
				GTK_SIGNAL_FUNC(cancel_callback), NULL);

		gtk_widget_show(label);		

		gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 5);
		gtk_widget_show(hbox);

		gtk_container_add(GTK_CONTAINER(edit_group_window), vbox);
		gtk_widget_show(vbox);
		
		gtk_signal_connect( GTK_OBJECT(edit_group_window), "destroy",
				GTK_SIGNAL_FUNC(destroy), NULL);
		gtk_widget_show(edit_group_window);
	}

	gtk_entry_set_text(GTK_ENTRY(group_name), g->name);
	g_snprintf(buff, 1024, "Edit Properties for %s", g->name);
	gtk_window_set_title(GTK_WINDOW(edit_group_window), buff);
	eb_icon(edit_group_window->window);
	gtk_signal_connect(GTK_OBJECT(edit_group_window), "destroy",
				GTK_SIGNAL_FUNC(destroy), NULL);

	current_group = g;
	window_open = 1;
}

