/*
 * Jabber Extension for everybuddy
 *
 * Copyright (C) 2000, Alex Wheeler <awheeler@speakeasy.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/*
 * jabber.c
 */

#include<gtk/gtk.h>
#include<stdio.h>
#include<stdlib.h>
#include<string.h>
#undef MIN
#undef MAX
#if defined( _WIN32 )
#include "../libjabber/libEBjabber.h"
typedef unsigned long u_long;
typedef unsigned long ulong;
#else
#include "libjabber/libEBjabber.h"
#endif
#include "jabber.h"
#include "contact.h"
#include "account.h"
#include "service.h"
#include "chat_window.h"
#include "info_window.h"
#include "gtk_eb_html.h"
#include "util.h"
#include "status.h"
#include "globals.h"
#include "dialog.h"
#include "message_parse.h"
#include "chat_room.h"
#include "value_pair.h"
#include "input_list.h"

#include "pixmaps/jabber_online.xpm"
#include "pixmaps/jabber_away.xpm"

GList *jabber_contacts = NULL;

static char * jabber_status_strings[] =
{ "", "(Away)", "(Do Not Disturb)", "(Extended Away)", "(Chat)", "(Offline)"};

static char jabber_server[255] = "jaber.com";
static char jabber_port[10] = "5222";

static input_list * jabber_prefs = NULL;


/* Use this struct to hold any service specific information you need
 * about people on your contact list
 */

typedef struct _eb_jabber_account_data
{
	gint status;		//the status of the user
	JABBER_Conn *JConn;	//The connection we know about them from
} eb_jabber_account_data;

typedef struct _jabber_info_data
{
    gchar *profile;
} jabber_info_data;


/* Use this struct to hold any service specific information you need about
 * local accounts
 * below are just some suggested values
 */

typedef struct _eb_jabber_local_account_data
{
	char password[255]; // account password
	int fd;				// the file descriptor
	int status;			// the current status of the user
	JABBER_Conn	*JConn;
} eb_jabber_local_account_data;

static eb_local_account *jabber_local_account;
void eb_jabber_terminate_chat( eb_account * account );
void eb_jabber_add_user( eb_account * account );
void eb_jabber_del_user( eb_account * account );
void eb_jabber_login( eb_local_account * account );
void eb_jabber_logout( eb_local_account * account );
void jabber_info_update(info_window *iw); 
void jabber_info_data_cleanup(info_window *iw);
static void jabber_dialog_callback( GtkWidget * widget, gpointer data );
static void jabber_list_dialog_callback( char * text, gpointer data );
void JABBERInstantMessage(void *data);
void JABBERStatusChange(void *data);
void JABBERDialog(void *data);
void JABBERListDialog(char **list, void *data);
void JABBERLogout(void *data);
void JABBERError(char* title, char *message);
static int ref_count = 0;
static int is_setting_state = 0;

static void jabber_dialog_callback( GtkWidget * widget, gpointer data )
{
    JABBER_Dialog_PTR jd;
    int response = (int)gtk_object_get_user_data(GTK_OBJECT(widget));

    jd = (JABBER_Dialog_PTR)data;
    dprintf("**** response: %i\n", response);
    if(response)
    {
      jd->callback(data);
    }
    if(jd->requestor)
      free(jd->requestor);
    free(jd->message);
    free(jd);
}

static void jabber_list_dialog_callback( char * text, gpointer data )
{
    JABBER_Dialog_PTR jd;

	dprintf("Entering");
    jd = (JABBER_Dialog_PTR)data;
    dprintf("**** response: %s\n", text);
    jd->response=text;
    jd->callback(data);
    free(jd->message);
    free(jd->requestor);
	free(jd->response);
    free(jd);
}


gboolean eb_jabber_query_connected( eb_account * account )
{
    eb_jabber_account_data * jad = account->protocol_account_data;

    dprintf("Entering\n");
    if(ref_count <= 0 )
        jad->status = JABBER_OFFLINE;
    dprintf("Returning: %i\n", jad->status != JABBER_OFFLINE);
    return jad->status != JABBER_OFFLINE;

}

void eb_jabber_login( eb_local_account * account )
{
    eb_jabber_local_account_data * jlad;

    dprintf("Entering\n");

    jlad = (eb_jabber_local_account_data *)account->protocol_local_account_data;
    jabber_local_account = account;
    account->connected = 1; 
	
	jlad->JConn=JABBER_Login(account->handle, jlad->password, 
			    jabber_server,  atoi(jabber_port));
	if(!jlad->JConn)
    {
        account->connected = 0;
    	jlad->status=JABBER_OFFLINE;
    }
    else 
    {
        jlad->status=JABBER_ONLINE;
        ref_count++;
        is_setting_state = 1;
    }

    if(account->status_menu)
    {
        dprintf("eb_jabber_login: status - %i\n", jlad->status);
        gtk_check_menu_item_set_active
        (
                GTK_CHECK_MENU_ITEM
                (
                    g_slist_nth(account->status_menu, jlad->status)->data
                ), TRUE
        );
    }
    is_setting_state = 0;
}

void eb_jabber_logout( eb_local_account * account )
{
	eb_jabber_local_account_data * jlad;
	eb_jabber_account_data *jad;
	GList *l;

	dprintf("Entering\n");
	jlad = (eb_jabber_local_account_data *)account->protocol_local_account_data;
	for (l = jabber_contacts; l; l = l->next) {
		eb_account * ea = find_account_by_handle(l->data, JABBER_SERVICE_ID);
		jad = ea->protocol_account_data;
		if(jad->status!=JABBER_OFFLINE && jlad->JConn==jad->JConn) {
			buddy_logoff(ea);
			jad->status=JABBER_OFFLINE;
			buddy_update_status(ea);
		}
	}
	dprintf("Calling JABBER_Logout\n");
	JABBER_Logout(jlad->JConn);
	jlad->JConn=NULL;
	jlad->status=JABBER_OFFLINE;
	account->connected = 0;
	ref_count--;
	dprintf("Leaving\n");
}

void eb_jabber_send_im( eb_local_account * from, eb_account * account_to, 
					 gchar * message)
{
	eb_jabber_account_data * jad = account_to->protocol_account_data;

    JABBER_SendMessage(jad->JConn, account_to->handle, message);
}

eb_local_account * eb_jabber_read_local_account_config( GList * values )
{
	char buff[255];
	char * c;

	eb_local_account * ela = g_new0(eb_local_account,1);
	eb_jabber_local_account_data *  jlad = g_new0( eb_jabber_local_account_data, 1);

	ela->handle = strdup( value_pair_get_value( values, "SCREEN_NAME" ));
	strcpy( jlad->password, value_pair_get_value( values, "PASSWORD") );

	/*the alias will be the persons login minus the @hotmail.com */
	strcpy( buff, ela->handle );
	c = strtok( buff, "@" );
	strcpy(ela->alias, buff );

	jlad->status = JABBER_OFFLINE;
	ela->protocol_local_account_data = jlad;
	
	ela->service_id = JABBER_SERVICE_ID;

	return ela;
}

GList * eb_jabber_write_local_config( eb_local_account * account )
{
	value_pair * val;
	GList * vals = NULL;
	eb_jabber_local_account_data * jlad = account->protocol_local_account_data;

	val = g_new0( value_pair, 1 );
	strcpy(val->key, "SCREEN_NAME" );
	strcpy(val->value, account->handle );
	vals = g_list_append( vals, val );

	val = g_new0( value_pair, 1 );
	strcpy(val->key, "PASSWORD");
	strcpy(val->value, jlad->password );
	vals = g_list_append( vals, val );

	return vals;
}

eb_account * eb_jabber_read_account_config( GList * config, struct contact * contact)
{
	eb_account * ea = g_new0(eb_account, 1);
	eb_jabber_account_data * jad = g_new0( eb_jabber_account_data, 1 );

	jad->status = JABBER_OFFLINE;
	jad->JConn = NULL;
	strncpy(ea->handle, value_pair_get_value( config, "NAME"), 255 );
	
	ea->service_id = JABBER_SERVICE_ID;
	ea->protocol_account_data = jad;
	ea->account_contact = contact;
	ea->list_item = NULL;
	ea->online = 0;
	ea->status = NULL;
	ea->pix = NULL;
	ea->icon_handler = -1;
	ea->status_handler = -1;

	eb_jabber_add_user(ea);

	return ea;
}

GList * eb_jabber_get_states()
{
	GList * list = NULL;

	dprintf("Entering\n");
	list = g_list_append( list, "Online" );
	list = g_list_append( list, "Away" );
	list = g_list_append( list, "Do Not Disturb" );
	list = g_list_append( list, "Extended Away" );
	list = g_list_append( list, "Chat" );
	list = g_list_append( list, "Offline" );

	dprintf("Exiting\n");
	return list;
}

gint eb_jabber_get_current_state( eb_local_account * account )
{
	eb_jabber_local_account_data * jlad = account->protocol_local_account_data;
	dprintf("Returning: %i\n", jlad->status);
	return jlad->status;
}

void eb_jabber_set_current_state( eb_local_account * account, gint state )
{
	eb_jabber_local_account_data * jlad = account->protocol_local_account_data;

	dprintf("Entering: state%i jlad->status: %i\n", state, jlad->status);
	if(state == JABBER_OFFLINE && jlad->status != JABBER_OFFLINE) {
		dprintf("Calling eb_jabber_logout\n");
		eb_jabber_logout(account);
	}
	else if(jlad->status == JABBER_OFFLINE && state != JABBER_OFFLINE) {
		eb_jabber_login(account);
		if(!account->connected)
			return;
		dprintf("Calling JABBER_ChangeState\n");
		JABBER_ChangeState(jlad->JConn, state);
	}
	else {
		dprintf("Calling JABBER_ChangeState\n");
		JABBER_ChangeState(jlad->JConn, state);
	}
	jlad->status=state;
}

void eb_jabber_terminate_chat(eb_account * account )
{
	eb_jabber_account_data *jad=account->protocol_account_data;

    JABBER_EndChat(jad->JConn, account->handle);
}

void eb_jabber_add_user(eb_account * account )
{
	eb_jabber_account_data *jad=account->protocol_account_data;

    jabber_contacts = g_list_append(jabber_contacts, account->handle);
    JABBER_AddContact(jad->JConn, account->handle);
}

void eb_jabber_del_user(eb_account * account )
{
	eb_jabber_account_data *jad=account->protocol_account_data;

    jabber_contacts = g_list_remove(jabber_contacts, account->handle);
    JABBER_RemoveContact(jad->JConn, account->handle);
}

eb_account * eb_jabber_new_account( gchar * account )
{
	eb_account * ea = g_new0(eb_account, 1);
	eb_jabber_account_data * jad = g_new0( eb_jabber_account_data, 1 );
	
	ea->protocol_account_data = jad;
	strncpy(ea->handle, account, 255 );
	ea->service_id = JABBER_SERVICE_ID;
	jad->status = JABBER_OFFLINE;

	return ea;
}

static gint pixmaps = 0;
static GdkPixmap * eb_jabber_pixmap[JABBER_OFFLINE+1];
static GdkBitmap * eb_jabber_bitmap[JABBER_OFFLINE+1];

void eb_jabber_init_pixmaps()
{
	gint i;
	gchar ** xpm;
	
	for (i=JABBER_ONLINE; i<=JABBER_OFFLINE; i++) {
		switch(i) {
		case JABBER_AWAY:
		case JABBER_XA:
		case JABBER_DND:
		case JABBER_OFFLINE:
			xpm = jabber_away_xpm;
			break;
		case JABBER_ONLINE:
		default:
			xpm = jabber_online_xpm;
			break;
		}
		eb_jabber_pixmap[i] = gdk_pixmap_create_from_xpm_d(statuswindow->window,
			&eb_jabber_bitmap[i], NULL, xpm);
	}
	pixmaps = 1;
}

void eb_jabber_get_status_pixmap( eb_account * account, GdkPixmap ** pm, GdkBitmap ** bm )
{
	eb_jabber_account_data * jad;
	
	if (!pixmaps)
		eb_jabber_init_pixmaps();
	
	jad = account->protocol_account_data;
	
	*pm = eb_jabber_pixmap[jad->status];
	*bm = eb_jabber_bitmap[jad->status];
}


gchar * eb_jabber_get_status_string( eb_account * account )
{
	eb_jabber_account_data * jad = account->protocol_account_data;
	return jabber_status_strings[jad->status];
}

void eb_jabber_set_idle( eb_local_account * account, gint idle )
{
    if ((idle == 0) && eb_jabber_get_current_state(account) == JABBER_AWAY)
    {
        if(account->status_menu)
        {
            gtk_check_menu_item_set_active
            (
                GTK_CHECK_MENU_ITEM
                (
                    g_slist_nth(account->status_menu, JABBER_ONLINE)->data
                ), TRUE
            );

        }

    }
    if( idle >= 600 && eb_jabber_get_current_state(account) == JABBER_ONLINE )
    {
        if(account->status_menu)
        {
            gtk_check_menu_item_set_active
            (
                GTK_CHECK_MENU_ITEM
                (
                    g_slist_nth(account->status_menu, JABBER_AWAY)->data
                ), TRUE
            );

        }
    }

}

void eb_jabber_set_away( eb_local_account * account, char * message )
{
    if(message)
    {
        if(account->status_menu)
        {
            gtk_check_menu_item_set_active
            (
                GTK_CHECK_MENU_ITEM
                (
                    g_slist_nth(account->status_menu, JABBER_AWAY)->data
                ), TRUE
            );

        }
    }
    else
    {
        if(account->status_menu)
        {
            gtk_check_menu_item_set_active
            (
                GTK_CHECK_MENU_ITEM
                (
                    g_slist_nth(account->status_menu, JABBER_ONLINE)->data
                ), TRUE
            );

        }

    }

}

void eb_jabber_send_chat_room_message( eb_chat_room * room, gchar * message )
{
	dprintf("Empty function\n");
}

void eb_jabber_join_chat_room( eb_chat_room * room )
{
	dprintf("Empty function\n");
}

void eb_jabber_leave_chat_room( eb_chat_room * room )
{
	dprintf("Empty function\n");
}

eb_chat_room * eb_jabber_make_chat_room( gchar * name, eb_local_account * account )
{
	dprintf("Empty function\n");
	return NULL;
}

void eb_jabber_send_invite( eb_local_account * account, eb_chat_room * room,
						  char * user, char * message )
{
	dprintf("Empty function\n");
}

void eb_jabber_get_info( eb_local_account * reciever, eb_account * sender)
{
   gchar buff[1024];

   dprintf("Not implemented yet\n");
   if(sender->infowindow == NULL){
     sender->infowindow = eb_info_window_new(reciever, sender);
     gtk_widget_show(sender->infowindow->window);
   }

   if(sender->infowindow->info_type == -1 || sender->infowindow->info_data == NULL){
      if(sender->infowindow->info_data == NULL) {
        sender->infowindow->info_data = malloc(sizeof(jabber_info_data));
        ((jabber_info_data *)sender->infowindow->info_data)->profile = NULL;
        sender->infowindow->cleanup = jabber_info_data_cleanup;
      }
      sender->infowindow->info_type = JABBER_SERVICE_ID;
    }
    if(sender->infowindow->info_type != JABBER_SERVICE_ID) {
       /*hmm, I wonder what should really be done here*/
       return; 
    }
    sprintf(buff,"THIS_IS_NOT_IMPLEMENTED YET(%s)",sender->handle);
    if( ((jabber_info_data *)sender->infowindow->info_data)->profile != NULL)
      free(((jabber_info_data *)sender->infowindow->info_data)->profile);
    ((jabber_info_data *)sender->infowindow->info_data)->profile = malloc(strlen(buff)+1);
    strcpy(((jabber_info_data *)sender->infowindow->info_data)->profile,buff);

    jabber_info_update(sender->infowindow);
}


void jabber_info_update(info_window *iw) {
  gchar buff[1024];
  jabber_info_data * mid = (jabber_info_data *)iw->info_data;

  dprintf("Not implemented yet\n");
  clear_info_window(iw);
  sprintf(buff,"Profile for <B>%s</B><BR><HR>",iw->remote_account->handle);
  gtk_eb_html_add(GTK_SCTEXT(iw->info),buff,0,0,0);
  sprintf(buff,"<a href=\"%s\">%s</a>",mid->profile,mid->profile);
  gtk_eb_html_add(GTK_SCTEXT(iw->info),buff,0,0,0);
}

void jabber_info_data_cleanup(info_window *iw){
  jabber_info_data * mid = (jabber_info_data *)iw->info_data;
  dprintf("ENtering and leaving\n");
  if(mid->profile != NULL) free(mid->profile);
}

input_list * eb_jabber_get_prefs()
{
	return jabber_prefs;
}

void eb_jabber_read_prefs_config(GList * values)
{
	char * c;
	c = value_pair_get_value(values, "server");

	if(c)
	{
		strcpy(jabber_server, c);
	}
	c = value_pair_get_value(values, "port");
	if(c)
	{
		strcpy(jabber_port, c);
	}
}

GList * eb_jabber_write_prefs_config()
{
	GList * config  = NULL;

	config = value_pair_add(config, "server", jabber_server);
	config = value_pair_add(config, "port", jabber_port);

	return config;
}


struct service_callbacks * eb_jabber_query_callbacks()
{
	struct service_callbacks * sc;

	sc = g_new0( struct service_callbacks, 1 );
	
	sc->query_connected = eb_jabber_query_connected;
	sc->login = eb_jabber_login;
	sc->logout = eb_jabber_logout;
	sc->send_im = eb_jabber_send_im;
	sc->read_local_account_config = eb_jabber_read_local_account_config;
	sc->write_local_config = eb_jabber_write_local_config;
	sc->read_account_config = eb_jabber_read_account_config;
	sc->get_states = eb_jabber_get_states;
	sc->get_current_state = eb_jabber_get_current_state;
	sc->set_current_state = eb_jabber_set_current_state;
	sc->add_user = eb_jabber_add_user;
	sc->del_user = eb_jabber_del_user;
	sc->new_account = eb_jabber_new_account;
	sc->get_status_string = eb_jabber_get_status_string;
	sc->get_status_pixmap = eb_jabber_get_status_pixmap;
	sc->set_idle = eb_jabber_set_idle;
	sc->set_away = eb_jabber_set_away;
	sc->send_chat_room_message = eb_jabber_send_chat_room_message;
	sc->join_chat_room = eb_jabber_join_chat_room;
	sc->leave_chat_room = eb_jabber_leave_chat_room;
	sc->make_chat_room = eb_jabber_make_chat_room;
	sc->send_invite = eb_jabber_send_invite;
	sc->terminate_chat = eb_jabber_terminate_chat;
        sc->get_info = eb_jabber_get_info;
	sc->get_prefs = eb_jabber_get_prefs;
	sc->read_prefs_config = eb_jabber_read_prefs_config;
	sc->write_prefs_config = eb_jabber_write_prefs_config;

	{
		input_list * il = g_new0(input_list, 1);
		jabber_prefs = il;
		il->widget.entry.value = jabber_server;
		il->widget.entry.name = "Default Server:";
		il->type = EB_INPUT_ENTRY;

		il->next = g_new0(input_list, 1);
		il = il->next;
		il->widget.entry.value = jabber_port;
		il->widget.entry.name = "Default Port:";
		il->type = EB_INPUT_ENTRY;

	}

	
	return sc;
}

void JABBERDelBuddy(void *data)
{
	eb_account *ea;
	char *jid=data;

	if(!data) {
		dprintf("called null argument\n");
		return;
	}

	ea = find_account_by_handle(jid, JABBER_SERVICE_ID);
	if(!ea) {
		dprintf("Unable to find %s to remove\n", jid);
		return;
	}
	eb_jabber_del_user(ea);
}

/*
** Name:    JABBERAddBuddy
** Purpose: This function is a callback that is called to ensure that
**          everybuddy knows about our new buddies.
** Input:   data - data passed to contact
** Output:  none
*/

void JABBERAddBuddy(void *data)
{
    struct jabber_buddy *jb;
    eb_account *ea;
	eb_jabber_account_data *jad;

    if(!data)
        return;
    jb = (struct jabber_buddy *)data;
    dprintf("Entering - %s\n", jb->jid);

    ea = find_account_by_handle(jb->jid, JABBER_SERVICE_ID);
    if (!ea) {	/* Add an unknown account */
	ea = eb_jabber_new_account(jb->jid);
        if ( !find_grouplist_by_name("Unknown" )) {
          add_group("Unknown");
        }
        add_unknown(ea);
    }
	jad=ea->protocol_account_data;
	/* Add the connection so we know which account a buddy is tied to */
	jad->JConn=jb->JConn;
}

/*
** Name:     JABBERInstantMessage
** Purporse: This function acts as the gateway between the libjabber and the 
**           gtk interface
** Input:    data    - data needed for instant message
** Output:   none
*/

void JABBERInstantMessage(void *data)
{
    JABBER_InstantMessage_PTR im;
    eb_account *sender = NULL;
    eb_account *ea;

    dprintf("Entering\n");
    im = (JABBER_InstantMessage_PTR)data;
    sender = find_account_by_handle(im->sender, JABBER_SERVICE_ID);
    if (sender == NULL) {
	ea = eb_jabber_new_account(im->sender);

        add_unknown(ea);
        sender = ea;
    }

    eb_parse_incomming_message(jabber_local_account, sender, im->msg);
}

/*
** Name:    JABBERStatusChange
** Purpose: This function is a callback that is called to update the
**          status of a contact in the forward list
** Input:   data - data passed to contact
** Output:  none
*/

void JABBERStatusChange(void *data)
{
    struct jabber_buddy *jb;
    eb_account *ea;
    eb_jabber_account_data *jad;

    if(!data)
        return;
    dprintf("Entering\n");
    jb = (struct jabber_buddy *)data;

    ea = find_account_by_handle(jb->jid, JABBER_SERVICE_ID);
    if (!ea) {	/* Add an unknown account */
	ea = eb_jabber_new_account(jb->jid);
        if ( !find_grouplist_by_name("Unknown" )) {
          add_group("Unknown");
        }
        add_unknown(ea);
    }
    jad = ea->protocol_account_data;

    dprintf( "JABBERStatusChange for %s to %i\n", jb->jid, jb->status);
    if (jb->status != JABBER_OFFLINE && jad->status==JABBER_OFFLINE) {
       jad->status = jb->status;
       buddy_login(ea);
    } else if (jb->status == JABBER_OFFLINE && jad->status!=JABBER_OFFLINE) {
       jad->status = jb->status;
       buddy_logoff(ea);
    }
    jad->status = jb->status;
	jad->JConn=jb->JConn;
    buddy_update_status(ea); 
}

void JABBERListDialog(char **list, void *data)
{
    JABBER_Dialog_PTR jd;

    if(!data || !list)
        return;

    jd = (JABBER_Dialog_PTR)data;
    do_list_dialog(jd->message, jd->heading, list, jabber_list_dialog_callback, (gpointer)jd);

}

/*
** Name:    JABBERDialog
** Purpose: This function is a callback that is called to ask for authorization
** Input:   data - data passed to contact
** Output:  none
*/

void JABBERDialog(void *data)
{
    JABBER_Dialog_PTR jd;

    if(!data)
        return;
    dprintf("Entering\n");
    jd = (JABBER_Dialog_PTR)data;
    do_dialog(jd->message, jd->heading, jabber_dialog_callback, (gpointer)jd);
              
    return;
}

/*
** Name:    JABBERLogout
** Purpose: This function is called when a user is logged out automatically
**          by the server
** Input:   data - date to be passed
** Output:  none
*/

void JABBERLogout(void *data)
{
    ref_count--;
    is_setting_state = 1;

    dprintf("Entering\n");
    jabber_local_account->connected = 0;
    if(jabber_local_account->status_menu) {
        dprintf("Setting menu to JABBER_OFFLINE\n");
        gtk_check_menu_item_set_active( 
             GTK_CHECK_MENU_ITEM (
                  g_slist_nth(jabber_local_account->status_menu, 
                  JABBER_OFFLINE)->data), TRUE);
    }
    is_setting_state = 0;
}

void JABBERError(char* title, char *message)
{
	do_error_dialog(title, message);
}
