#!/usr/bin/perl -w
#
#   Everybuddy Account File Format Updater Thingy
#
#   * Reads old file and converts it into the new format
#   * Makes a backup Just In Case (~/.everybuddy/account-backup)
#
#	Ben Rigas (ben@everybuddy.com) 
#______________________________________________________________________


### path to account file

if ( $ENV{"HOME"} )
{
	$path = $ENV{"HOME"} . "/.everybuddy";
}
else
{
	chomp ( $whoami = `whoami` );
	$path     = "/home/$whoami/.everybuddy";
}

$filename = "accounts";

### read lines from old account file

open (OLD, "$path/$filename") 
   or die "Cant open old account file: $!\n";

@lines = <OLD>;

close (OLD);

### Check to see if account file is already updated

if ($lines[0] =~ /^<ACCOUNT/) {
    exit;
# this is old news to most
#	die "Already Converted!\n";
}

### Make backup of account file

open (BACKUP, ">$path/$filename-backup")
   or die "Can't write backup file: $!\n";

print BACKUP @lines;

close (BACKUP);

### Open file for writing the new format 

chomp(@lines);

open (NEW, ">$path/$filename")
   or die "Cant open new account file: $!\n";

while ($i < $#lines) {

   unless(!defined($lines[$i])) {

      print NEW "<ACCOUNT $lines[$i]>\n";
      $i++;
      print NEW "        SCREEN_NAME=\"$lines[$i]\"\n";
      $i++;
      print NEW "        PASSWORD=\"$lines[$i]\"\n";
      $i++;
      print NEW "</ACCOUNT>\n";
   }
}  print "Account file now updated. A backup of the old file has been created as well.\n";

close (NEW);


### End of script, nothing to see here, move along
