/*
 *   Copyright (c) International Business Machines  Corp., 2001
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or 
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software 
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: lvmregmgr
 * File: lvm_pv.h
 */ 

#ifndef _LVM_PV_H_
#define _LVM_PV_H_ 1

// Functions exported from lvm_pv.c
extern lvm_physical_volume_t * lvm_allocate_physical_volume(storage_object_t	* segment,
								pv_disk_t	* pv );
extern int lvm_deallocate_physical_volume( lvm_physical_volume_t * pv_entry );
extern boolean lvm_check_segment_for_pv(void	* segment_pointer,
					TAG	segment_tag,
					uint	segment_struct_size,
					void	* segment_handle,
					void	* pv_buffer_pointer,
					boolean	* free_memory,
					uint	* error_code );
extern int lvm_find_free_pv_number( lvm_volume_group_t * group );
extern lvm_physical_volume_t * lvm_create_pv_from_segment( storage_object_t * segment );
extern int lvm_check_segment_for_pe_size(storage_object_t	* segment,
					u_int32_t		* pe_size );
extern lvm_physical_volume_t * lvm_get_pv_for_segment( storage_object_t * segment );
extern lvm_physical_volume_t * lvm_get_pv_for_name(char			* name,
						lvm_volume_group_t	* group );
extern int lvm_update_pv_for_group(	lvm_physical_volume_t	* pv_entry,
					lvm_volume_group_t	* group );
extern int lvm_update_pv_for_no_group( lvm_physical_volume_t * pv_entry );
extern u_int64_t lvm_get_pe_start(	pv_disk_t		* pv,
					lvm_volume_group_t	* group );
extern int lvm_remove_pvs_from_kernel( void );
extern int lvm_add_pv_to_removal_list( lvm_physical_volume_t	* pv_entry,
					lvm_volume_group_t	* group );
extern int lvm_get_available_stripes( lvm_volume_group_t * group );
extern int lvm_verify_segment( storage_object_t * segment );

#endif

