/*
 *
 *   Copyright (c) International Business Machines  Corp., 2001
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: screener.h
 */
 
/*
 * Change History:
 *
 * 6/2001  B. Rafanello  Initial version.
 *
 */

#include "token.h"  /* TokenCharacterizations, TokenType */

#ifndef SCREENER_H

#define SCREENER_H 1


/* For ease of parsing, all tokens characterized as KeyWord are converted so that
   their TokenText pointers point to one of the following standard keywords:       */

#ifdef SCREENER_C

char *   AcceptableStr    =  "ACCEPTABLE";
char *   AddStr           =  "ADD";
char *   AllStr           =  "ALL";
char *   AllocateStr      =  "ALLOCATE";
char *   AssignStr        =  "ASSIGN";
char *   AutoStr          =  "AUTO";
char *   CheckStr         =  "CHECK";
char *   ChildrenStr      =  "CHILDREN";
char *   ClusterStr       =  "CLUSTER";
char *   CMStr            =  "CM";
char *   CompatibilityStr =  "COMPATIBILITY";
char *   ContainerStr     =  "CONTAINER";
char *   ContainersStr    =  "CONTAINERS";
char *   CreateStr        =  "CREATE";
char *   DefragmentStr    =  "DEFRAGMENT";
char *   DeleteStr        =  "DELETE";
char *   DeviceStr        =  "DEVICE";
char *   DiskStr          =  "DISK";
char *   DisksStr         =  "DISKS";
char *   DistributedStr   =  "DISTRIBUTED";
char *   DLMStr           =  "DLM";
char *   EIStr            =  "EI";
char *   EQStr            =  "EQ";
char *   EndStr           =  "END";
char *   EPStr            =  "EP";
char *   ExpandStr        =  "EXPAND";
char *   ExpandableStr    =  "EXPANDABLE";
char *   ExtendedStr      =  "EXTENDED";
char *   FeatureStr       =  "FEATURE";
char *   FileStr          =  "FILE";
char *   FilesystemStr    =  "FILESYSTEM";
char *   FSIMStr          =  "FSIM";
char *   FormatStr        =  "FORMAT";
char *   FreespaceStr     =  "FREESPACE";
char *   GigabyteStr      =  "GB";
char *   GTStr            =  "GT";
char *   HelpStr          =  "HELP";
char *   HoursStr         =  "HOURS";
char *   InfoStr          =  "INFO";
char *   InterfaceStr     =  "INTERFACE";
char *   KilobyteStr      =  "KB";
char *   ListStr          =  "LIST";
char *   LockStr          =  "LOCK";
char *   LOStr            =  "LO";
char *   LTStr            =  "LT";
char *   ManagementStr    =  "MANAGEMENT";
char *   ManagerStr       =  "MANAGER";
char *   ManualStr        =  "MANUAL";
char *   MegabyteStr      =  "MB";
char *   MicrosecondsStr  =  "MICROSECONDS";
char *   MillisecondsStr  =  "MILLISECONDS";
char *   MinutesStr       =  "MINUTES";
char *   ModuleStr        =  "MODULE";
char *   NameStr          =  "NAME";
char *   ObjectStr        =  "OBJECT";
char *   ObjectsStr       =  "OBJECTS";
char *   OptionsStr       =  "OPTIONS";
char *   ParentStr        =  "PARENT";
char *   PluginStr        =  "PLUGIN";
char *   PluginsStr       =  "PLUGINS";
char *   PointsStr        =  "POINTS";
char *   ProbeStr         =  "PROBE";
char *   QueryStr         =  "QUERY";
char *   RegionStr        =  "REGION";
char *   RegionsStr       =  "REGIONS";
char *   RemoveStr        =  "REMOVE";
char *   RenameStr        =  "RENAME";
char *   RevertStr        =  "REVERT";
char *   SecondsStr       =  "SECONDS";
char *   SectorsStr       =  "SECTORS";
char *   SegmentStr       =  "SEGMENT";
char *   SegmentsStr      =  "SEGMENTS";
char *   SetStr           =  "SET";
char *   ShrinkStr        =  "SHRINK";
char *   ShrinkableStr    =  "SHRINKABLE";
char *   SizeStr          =  "SIZE";
char *   SPStr            =  "SP";
char *   StartStr         =  "START";
char *   TerrabyteStr     =  "TB";
char *   TypeStr          =  "TYPE";
char *   UnclaimedStr     =  "UNCLAIMED";
char *   UnformatStr      =  "UNFORMAT";
char *   VolumeStr        =  "VOLUME";
char *   VolumesStr       =  "VOLUMES";
     
#else 
        
extern char *   AcceptableStr;
extern char *   AddStr;
extern char *   AllStr;
extern char *   AllocateStr;
extern char *   AssignStr;
extern char *   AutoStr;
extern char *   CheckStr;
extern char *   ChildrenStr;
extern char *   ClusterStr;
extern char *   CMStr;
extern char *   CompatibilityStr;
extern char *   ContainerStr;
extern char *   ContainersStr;
extern char *   CreateStr;
extern char *   DefragmentStr;
extern char *   DeleteStr;
extern char *   DeviceStr;
extern char *   DiskStr;
extern char *   DisksStr;
extern char *   DistributedStr;
extern char *   DLMStr;
extern char *   EIStr;
extern char *   EQStr;
extern char *   EndStr;
extern char *   EPStr;
extern char *   ExpandStr;
extern char *   ExpandableStr;
extern char *   ExtendedStr;
extern char *   FeatureStr;
extern char *   FileStr;
extern char *   FilesystemStr;
extern char *   FSIMStr;
extern char *   FormatStr;
extern char *   FreespaceStr;
extern char *   GigabyteStr;
extern char *   GTStr;
extern char *   HelpStr;
extern char *   HoursStr;
extern char *   InfoStr;
extern char *   InterfaceStr;
extern char *   KilobyteStr;
extern char *   ListStr;
extern char *   LockStr;
extern char *   LOStr;
extern char *   LTStr;
extern char *   ManagementStr;
extern char *   ManagerStr;
extern char *   ManualStr;
extern char *   MegabyteStr;
extern char *   MicrosecondsStr;
extern char *   MillisecondsStr;
extern char *   MinutesStr;
extern char *   ModuleStr;
extern char *   NameStr;
extern char *   ObjectStr;
extern char *   ObjectsStr;
extern char *   OptionsStr;
extern char *   ParentStr;
extern char *   PluginStr;
extern char *   PluginsStr;
extern char *   PointsStr;
extern char *   ProbeStr;
extern char *   QueryStr;
extern char *   RegionStr;
extern char *   RegionsStr;
extern char *   RemoveStr;
extern char *   RenameStr;
extern char *   RevertStr;
extern char *   SectorsStr;
extern char *   SecondsStr;
extern char *   SegmentStr;
extern char *   SegmentsStr;
extern char *   SetStr;
extern char *   ShrinkStr;
extern char *   ShrinkableStr;
extern char *   SizeStr;
extern char *   SPStr;
extern char *   StartStr;
extern char *   TerrabyteStr;
extern char *   TypeStr;
extern char *   UnclaimedStr;
extern char *   UnformatStr;
extern char *   VolumeStr;
extern char *   VolumesStr;

#endif
               
   
/*********************************************************************/
/*                                                                   */
/*   Function Name: GetScreenedToken                                 */
/*                                                                   */
/*   Descriptive Name: Repeatedly calls the scanner for a token until*/
/*                     it gets EOF, Error, or a token which is       */
/*                     something other than a space or tab.  This    */
/*                     function will also recharacterize some tokens */
/*                     currently marked as KeyWords.                 */
/*                                                                   */
/*   Input: None.                                                    */
/*                                                                   */
/*   Output: The function return value is a token.                   */
/*                                                                   */
/*   Error Handling:                                                 */
/*                                                                   */
/*   Side Effects: None.                                             */
/*                                                                   */
/*   Notes:                                                          */
/*                                                                   */
/*********************************************************************/                                          
TokenType * GetScreenedToken(void);                                                             
                                                             
               
#endif                   
