/*
 *   Copyright (c) International Business Machines  Corp., 2001
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or 
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software 
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: LvmUtils/helpers
 * File: is_lvm_container.c
 */ 

#ifndef _LVM_HELP_IS_LVM_CONTAINER_
#define _LVM_HELP_IS_LVM_CONTAINER_ 1

/* Function: is_lvm_container
 *
 *	Determine if the specified container belongs to LVM.
 *	Return non-zero if true, zero if false.
 */
int is_lvm_container( object_handle_t container )
{
	handle_object_info_t	* container_info = NULL;
	handle_object_info_t	* plugin_info = NULL;
	int			rc;

	if ( evms_get_info(container, &container_info) ||
	     ! container_info ) {
		return FALSE;
	}

	if ( evms_get_info(container_info->info.container.plugin, &plugin_info) ||
	     ! plugin_info ) {
		evms_free(container_info);
		return FALSE;
	}
	evms_free(container_info);

	rc = ( plugin_info->info.plugin.id == SetPluginID( EVMS_OEM_IBM,
							EVMS_REGION_MANAGER,
							0x01) );
	evms_free(plugin_info);
	return rc;
}

#endif

