/*
 *   (C) Copyright IBM Corp. 2001, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/**
 * struct hdparm_info
 * @read_ahead:		-a, Filesystem read-ahead sectors.
 * @bus_state:		-b, 0 for off, 1 for on, 2 for tristate
 * @io_support:		-c, 0 for 16-bit, 1 for 32-bit, 3 for 32-bit w/ sync
 * @drive_state:	-C, 0 for "unknown", 1 for "active/idle",
 *			    2 for "standby", 3 for "sleeping"
 * @using_dma:		-d, DMA on or off
 * @keep_settings:	-k, Keep-settings-over-reset
 * @acoustic:		-M, Automatic Acoustic Management. 128=quiet, 254=fast
 * @multi_count:	-m, Multiple sector I/O.
 * @ignore_errors:	-n, Ignore write errors. yes or no.
 * @unmask_irq:		-u, Unmask interrupts while processing a drive interrupt.
 *
 * Info that can be retrieved or set using the "hdparm" command.
 **/
typedef struct hdparm_info {
	int read_ahead;
	int bus_state;
	int io_support;
	int drive_state;
	int using_dma;
	int keep_settings;
	int acoustic;
	int multi_count;
	int ignore_errors;
	int unmask_irq;
} hdparm_info_t;

extern int get_basic_info(storage_object_t * disk,
			  extended_info_array_t ** info);
extern int get_ide_info(storage_object_t * disk,
			extended_info_array_t ** info);
extern int get_scsi_info(storage_object_t * disk,
			 extended_info_array_t ** info);

