/*
 *
 *   (C) Copyright IBM Corp. 2002, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: list.h
 *
 */

#ifndef EVMS_LISTS_H_INCLUDED
#define EVMS_LISTS_H_INCLUDED 1

typedef struct links_s {
	struct links_s * next;
	struct links_s * prev;
} links_t;

typedef struct anchor_s {
	links_t links;
	uint    count;
} anchor_t;

typedef struct element_s {
	links_t    links;
	void     * thing;
	anchor_t * anchor;
} element_t;


/* For declaring and initializing static lists. */
#define STATIC_LIST_DECL(list_name) anchor_t list_name = {links: {next: &list_name.links,	\
								  prev: &list_name.links},	\
							  count: 0}

/* For initializing dynamic allocations of lists. */
#define LIST_INIT(list) {		\
	list.links.next = &list.links;	\
        list.links.prev = &list.links;	\
	list.count = 0;			\
}


/*
 * Since anchors and elements start with links, pointers to anchors, pointers
 * to elements and pointers to links are all pointing to the same thing.
 * Sometimes the code needs to cast from one to the other.  These macros
 * assist in doing that and make the code more readable.
 */
#define LINK_PTR(thing)    ((links_t *) (thing))
#define ANCHOR_PTR(thing)  ((anchor_t *) (thing))
#define ELEMENT_PTR(thing) ((element_t *) (thing))


extern anchor_t * allocate_list(void);

extern uint list_count(anchor_t * anchor);

extern boolean list_empty(anchor_t * anchor);

extern element_t * find_in_list(anchor_t         * anchor,
				void             * thing,
				compare_function_t compare,
				void             * user_data);

extern void delete_all_elements(anchor_t * anchor);

extern void destroy_list(anchor_t * anchor);

extern void * get_thing(element_t * element);

extern element_t * next_element(element_t * element);

extern void * next_thing(element_t * * element);

extern element_t * previous_element(element_t * element);

extern void * previous_thing(element_t * * element);

extern void * first_thing(anchor_t    * anchor,
			  element_t * * element);

extern void * last_thing(anchor_t    * anchor,
			 element_t * * element);

extern element_t * insert_element(anchor_t     * anchor,
				  element_t    * element,
				  insert_flags_t flags,
				  element_t    * ref_element);

extern element_t * insert_thing(anchor_t     * anchor,
				void         * thing,
				insert_flags_t flags,
				element_t    * ref_element);

extern void remove_element(element_t * element);

extern void delete_element(element_t * element);

extern void remove_thing(anchor_t * anchor,
			 void     * thing);

extern int replace_thing(anchor_t * anchor,
			 void     * thing,
			 void     * new_thing);

extern anchor_t * copy_list(anchor_t * anchor);

extern int concatenate_lists(anchor_t * anchor1,
			     anchor_t * anchor2);

extern int merge_lists(anchor_t         * anchor1,
		       anchor_t         * anchor2,
		       compare_function_t compare,
		       void             * user_data);

extern int sort_list(anchor_t         * anchor,
		     compare_function_t compare,
		     void             * user_data);

#endif
