/*
 *   (C) Copyright IBM Corp. 2004
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: lvm2
 * File: evms2/engine/plugins/lvm2/regions.h
 */

/**
 * Routines exported from regions.c
 **/
extern dm_target_t *build_target_list(storage_object_t *region);
extern int rename_region(storage_object_t *region);
extern void lv_name_to_region_name(char *lv_name, char *region_name,
				   char *container_name);
extern int region_name_to_lv_name(char *region_name, char *lv_name,
				  char *container_name);
extern void switch_region_name(storage_object_t *region);
extern void remove_old_region_name(storage_object_t *region);
extern void set_new_region_name(storage_object_t *region, char *lv_name);
extern void add_region_to_container(storage_object_t *region,
				    storage_container_t *container);
extern void remove_region_from_container(storage_object_t *region);

extern region_mapping_t *find_mapping_by_index(storage_object_t *region,
					       u_int32_t map_index);
extern void deallocate_le_map_stripe(logical_extent_t *le_map);
extern logical_extent_t *allocate_le_map_stripe(logical_extent_map_t *le_maps,
						u_int64_t extents_per_stripe);
extern void deallocate_region_mappings(storage_object_t *region);
extern void construct_region_mapping_stripe(logical_extent_t *le_map,
					    physical_extent_t *pe_map,
					    u_int64_t pe_index);
extern void deconstruct_region_mapping_stripe(logical_extent_t *le_map);
extern void deconstruct_region_mappings(storage_object_t *region);
extern void deallocate_region(storage_object_t *region);

extern int allocate_freespace_region(storage_container_t *container);
extern storage_object_t *get_freespace_region(list_anchor_t region_list);
extern int create_freespace_mappings(storage_container_t *container);
extern void delete_freespace_mappings(storage_container_t *container);

extern int discover_regions(list_anchor_t output_objects, boolean final_call);
extern int region_io(storage_object_t *region, lba_t lsn,
		     sector_count_t count, void *buffer, int rw);

extern storage_object_t *create_new_region(storage_container_t *container,
					   char *lv_name);
extern int prevalidate_extent_allocation(storage_container_t *container,
					 list_anchor_t objects,
					 u_int64_t size, u_int64_t stripes);
extern int allocate_extents_for_region(storage_object_t *region,
				       list_anchor_t objects,
				       u_int64_t size, u_int64_t stripes,
				       u_int64_t stripe_size);
extern int deallocate_extents_from_region(storage_object_t *region,
					  u_int64_t size);
extern int merge_region_mappings(storage_object_t *region);
extern int can_merge_region_mappings(storage_object_t *region);

extern int can_expand_region(storage_object_t *region);
extern int can_shrink_region(storage_object_t *region);

extern int can_split_region_mapping(region_mapping_t *r_map);
extern int can_split_a_region_mapping(storage_object_t *region);
extern int split_region_mapping(storage_object_t *region,
				option_array_t *options);
extern u_int64_t smallest_mapping_stripe(storage_object_t *region);

