/*
 *
 *   (C) Copyright IBM Corp. 2002, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * 	Module: rsct_internal.h
 */

#ifndef _RSCT_INTERNAL_H_
#define _RSCT_INTERNAL_H_

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/select.h>
#include <ha_gs.h>
#include <ece.h>
#include <plugin.h>
#include <assert.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include "eceinternal.h"
#include "rsct_mem_info.h"
#include "rsct_appcb_queue.h"

#define MASTER_INSTANCE_NUM          5524
#define SLAVE_INSTANCE_NUM           5525
#define RESPONSE_INTERVAL            2
#define RESPONSE_TIME_LIMIT          2
#define JOIN_FAILURE_TIME_LIMIT      5
#define TIME_LIMIT                   1
#define ACK_INSTANCE_NUM             5526

extern pthread_t                gl_rsct_ack_thread;
extern pthread_t                gl_rsct_thread;

typedef struct frag_s {
  unsigned char 	*seq_bmap;
  char 	*datastr;
  uint	frag_size;
  uint	tot_size;
  uint  msg_count;  
} frag_t;


typedef struct registercb_s {
  ece_callback_type_t     reg_type;
  ece_cb_t                reg_callback;
} registercb_t;

typedef enum  
  {RSCT_MSG,RSCT_ACK}rsct_msg_type;

typedef struct rsct_msg_s{
  rsct_msg_type  type;
  unsigned long seqno;
  unsigned long flen;
  unsigned long tlen;

  unsigned long data_length;
  ece_msg_t ecemsg;  
  unsigned long msg_count;
  int send_node_number;
} rsct_msg_t;



void RSCT_INTERNAL_cb_init();
void RSCT_INTERNAL_cb_cleanup();


void RSCT_INTERNAL_delayed_error_cb(const ha_gs_delayed_error_notification_t *block) ;

void RSCT_INTERNAL_n_phase_cb(const ha_gs_n_phase_notification_t *block);

void RSCT_INTERNAL_approved_cb(const ha_gs_approved_notification_t *block);

void RSCT_INTERNAL_rejected_cb(const ha_gs_rejected_notification_t *block);

void RSCT_INTERNAL_announcement_cb(const ha_gs_announcement_notification_t *block);
void RSCT_INTERNAL_subscriber_cb(const ha_gs_subscription_notification_t*);

int RSCT_get_proposal_id();

#endif
