/*************************************************************
*  This file is part of the Surface Evolver source code.     *
*  Programmer:  Ken Brakke, brakke@susqu.edu                 *
*************************************************************/


/**********************************************************************
*
* The ultimate structure for a whole surface , including all global
* variables needed to export for distributed computing.
*/

/* structure type name different from structure variable name since
   Visual C is incompetent at distinguishing in debugger. */

struct webstruct {
     struct skeleton skel[NUMELEMENTS];
     int sizes[NUMELEMENTS];
     int sdim;  /* dimension of ambient space */
     int dimension;    /* where tension resides */
     int representation; /* STRING, SOAPFILM, or SIMPLEX */
     int modeltype;    /* quadratic or linear, see defines below */
     int lagrange_order; /* polynomial order of elements */
     int headvnum;  /* number of head vertex in edge list */
     int maxparam;    /* maximum number of parameters in any boundary */
     int constraint_addr[MAXCON]; /* allocated in dymem as needed */
     int concount;     /* number of constraints */
     conmap_t con_global_map[MAXCONPER]; /* global vertex constraints */
     int con_global_count;  /* number of global vertex constraints */
     REAL tolerance;      /* constraint error tolerance */
     REAL target_tolerance; /* error tolerance for extensive constraints */
     struct boundary boundaries[BDRYMAX]; /* for free boundaries */
     struct surf_energy surfen[SURFENMAX]; /* facet energy integrands */
     MAP surf_global_map; /* bitmap for global surface energies */
     int surfen_count;     /* number of surface energy integrands */
     struct quantity quants[QUANTMAX]; /* facet quantity integrands */
     MAP quant_global_map; /* bitmap for global quantities */
     int quantity_count;     /* number of quantities */
     int diffusion_flag;  /* whether diffusion in effect */
     REAL diffusion_const;  /* coefficient for diffusion */
     REAL simplex_factorial; /* content correction factor for determinant */
     int torus_clip_flag;
     int torus_body_flag;
     int symmetric_content; /* 1 if volumes use symmetric divergence */
     int h_inverse_metric_flag; /* for laplacian of curvature */
     REAL meritfactor;    /* for multiplying figure of merit */
     int gravflag;         /* whether gravity is on */
     REAL grav_const;      /* multiplier for gravitational force */
     int convex_flag;     /* whether any convex boundaries present */
     int pressflag;        /* whether prescribed pressures present */
     int constr_flag;     /* set if there are any one-sided constraints */
     int hide_flag;        /* set for hidden surface removal */
     int motion_flag;     /* set for fixed scale of motion;
                                          otherwise seek minimum. */
     int symmetry_flag;  /* whether symmetry group in effect */
     int torus_flag;     /* whether working in toroidal domain */
     int full_flag;     /* whether torus solidly packed with bodies */
     int pressure_flag;  /* whether pressure used dynamically */
     int projection_flag; /* whether to project */
     int area_norm_flag; /* whether to normalize force by area surrounding vertex */
     int norm_check_flag;  /* whether area normalization checks normal deviation */
     REAL norm_check_max;  /* maximum allowable deviation */
     int vol_flag;         /* whether body volumes up to date */
     int jiggle_flag;     /* whether to jiggle vertices at each move */
     int homothety;        /* flag for homothety adjustment each iteration */
     int wulff_flag;      /* whether we are using wulff shapes for energy */
     int wulff_count;     /* number of Wulff vectors read in */
     char wulff_name[60]; /* Wulff file or keyword */
     vertex_id  zoom_v;    /* vertex to zoom on */
     REAL zoom_radius;     /* current zoom radius */
     REAL total_area;
     REAL total_energy;
     REAL spring_energy;
     int total_facets;
     int bodycount;  /* number of bodies */
     body_id outside_body;  /* a body surrounding all others */
     REAL scale;     /* force to motion scale factor */
     REAL scale_scale;     /* over-relaxation factor */
     REAL maxscale;     /* upper limit on scale factor */
     REAL pressure;    /* ambient pressure */
     REAL min_area;        /* criterion on weeding out small triangles */
     REAL min_length;     /* criterion on weeding out small triangles */
     REAL max_len;         /* criterion for dividing long edges */
     REAL max_angle;      /* max allowed deviation from parallelism */
     REAL temperature;  /* "temperature" for jiggling */
     REAL spring_constant;  /* for forcing edges to conform to boundary */
     int  gauss1D_order;        /* order for gaussian 1D integration */
     int  gauss2D_order;        /* order for gaussian 2D integration */
     REAL torusv;                 /* unit cell volume or area */
     REAL torus_period[MAXCOORD][MAXCOORD];
     REAL **inverse_periods;/* inverse matrix of torus periods */
     int  metric_flag;      /* set if background metric in force */
     int  conformal_flag;  /* set for conformal metrics */
     struct expnode metric[MAXCOORD][MAXCOORD]; /* metric component functions */
      
     /* some counters */
     int equi_count; 
     int weed_count; 
     int delete_count; 
     int refine_count; 
     int notch_count; 
     int dissolve_count; 
     int pop_count; 
     int where_count; 

     /* here follows stuff moved from independent globals to inside web
         so as to be easily exported.  Previous global names are defined
         to web fields elsewhere.
         */
     DY_OFFSET dy_gen_quants_w;
     int gen_quant_count_w;
     int gen_quant_alloc_w;
     int global_count;
     int maxglobals;  /* number allocated */

     DY_OFFSET dy_meth_inst_w; /* for storing instance structures */
     int meth_inst_alloc_w;  /* number allocated */
     int meth_inst_count_w;  /* number defined    */

     /* global method instances, applying to every element of type */
     int global_meth_inst_flags_w[NUMELEMENTS];
     int global_meth_inst_w[NUMELEMENTS][MAXGLOBINST]; /* lists */
     int global_meth_inst_count_w[NUMELEMENTS];

     /* flags telling which quantity calculations necessary */
     /* flag set for Q_ENERGY,Q_FIXED, or Q_INFO if any element
         needs a quantity calculated */
     int quant_flags_w[NUMELEMENTS];

     DY_OFFSET dy_freestart_w;  /* initial block of freelist, 0 if none */
     DY_OFFSET dy_globals_w;
     #define dy_freestart web.dy_freestart_w

     /* "extra attribute" numbers of expandable or optional attributes */
     /* common */
     int meth_attr[NUMELEMENTS] ; /* method instances list */
  };

extern struct webstruct web;

