/*
    tst.c -- test ext2 fs creation
    Copyright (C) 1998, 1999, 2000 Lennert Buytenhek <buytenh@gnu.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

static const char _tst_c[] = "$Id: tst.c,v 1.6 2000/09/27 07:25:54 adilger Exp $";

#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <getopt.h>
#include "ext2.h"

struct ext2_fs *fs;

int main(int argc, char *argv[])
{
	struct ext2_dev_handle	*handle;

	handle = ext2_make_dev_handle_from_file(argv[1], argv[0]);
	if (handle == NULL) {
		fprintf(stderr, "can't open %s\n", argv[1]);
		return 1;
	}

	fs = ext2_mkfs(handle, -1, -1, -1, -1, -1, -1);
	ext2_close(fs);

	return 0;
}
