/*
 * dynbuff.h
 *
 */

#ifndef __dynbuff_h
#  define __dynbuff_h


typedef unsigned long u_long; 

class dynbuff 
{
private:
    char * contents;                 // data
    unsigned int min,                // min size buffer will be kept at 
               max,
               bytes_in,             // how much stored right now
               alloced;              // bytes allocated for it right now
      
public:
    dynbuff(u_long, u_long);
    ~dynbuff();

    /* 
     * Adds data to buffer. if len is not given,
     * strlen() is used on it. First arg can be 
     *  fd to a file. 
     */
    long add(const char *, u_long len = 0);       
    long add(int fd, u_long len = 0);

    long peek(char *, u_long);               // peek at data w/o removing from buff
    long get(char *, u_long);                // get and remove from buff
    u_long   have_char(char) const;          // return number of chars found
    long     get_line(unsigned, char *, u_long, bool = 0, bool = 0);
    long     flush(int, unsigned int = 0);   // dump all contents to an fd
    bool     flush(void);                
    bool     reset(void);                    // dump all, force realloc
    long     get_pos(char ) const;
    u_long   optimize(void);

    u_long get_size(void) const
    {
       return bytes_in;
    }
    u_long get_alloced(void) const
    {
       return alloced;
    }
     
protected:
    long remove(u_long start, u_long howmuch);
    long append(const char *, u_long);
    void clear(void)
    {
        bytes_in = 0;
    }
};


const short DYNBUFF_ERR_FULL    = -1;
const short DYNBUFF_ERR_READ    = -2;        // call to read() failed
const short DYNBUFF_ERR_WRITE   = -3;        // call to write() failed
const short DYNBUFF_ERR_MEM     = -4;     
const short DYNBUFF_ERR_EMPTY   = -5;
#endif
