import re
import string

from globals import *
import config
import mail
import template

rx_url = re.compile(r'([^\s\"]+://[^\s\"]+)')
def markup_urls(str): return rx_url.sub(r'<a href="\1">\1</a>', str)

rx_addr1 = re.compile(r'<[^>@]+@[^>]+>')
rx_addr2 = re.compile(r'\S+@\S+\.\S+')
def mask_email(str):
	return rx_addr2.sub('####@####.####', str)

exports = {
	'config': config,
	'mail': mail,
	'markup_urls': markup_urls,
	'mask_email': mask_email,
	}
