#!/usr/bin/python
import cgi
import os
import os
import string
import sys

import globals
from globals import *
import config
import ezmlm
import functions
import template

def load_form():
	if not os.environ['QUERY_STRING']:
		return { }
	cgi.maxlen = 64*1024
	cgiform = cgi.FieldStorage()
	form = { }
	for key in cgiform.keys():
		item = cgiform[key]
		if type(item) is not type([]) and \
		   not item.file:
			form[key] = item.value
	return form

def open_read(basename):
	path = os.path.join(sys.path[0], config.htmldir, basename + '.html')
	return open(path).read()

def make_cmdlink(list):
	def cmdlink(command,_list_=list,**args):
		args[COMMAND] = command
		args[LIST] = _list_
		return apply(template.functions.relink, (), args)
	return cmdlink

def main():
	print "Content-Type: text/html"
	print

	try:
		form = load_form()
		try:
			cmdname = form[COMMAND]
			if '.' in cmdname or '/' in cmdname:
				cmdname = 'illegal-command'
		except:
			cmdname = 'menu'
		if form.has_key(LIST):
			list = form[LIST]
			form.update(config.archives[list])
			eza = ezmlm.EzmlmArchive(form[LISTDIR])
			eza.set_months(form)
			form['ezmlm'] = eza
			form['cmdlink'] = make_cmdlink(list)
		else:
			cmdname = 'menu'
		template.context.global_context.update(functions.exports)
		template.context.global_context.update(globals.__dict__)
		template.path[0] = config.htmldir
		content = open_read(cmdname)
		template.parser.format(content, form)
	except:
		cgi.print_exception()
