/***************************************************************************
                          FLApplication.h  -  description
                             -------------------
    begin                : Mon Jul 2 2001
    copyright            : (C) 2001,2002 by Federico Albujer Zornoza
    email                : mail@infosial.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef FLAAPPLICATION_H
#define FLAAPPLICATION_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qapp.h>
#include <qworkspace.h>
#include <qwhatsthis.h>
#include <qtooltip.h>
#include <qmsgbox.h>
#include <qstring.h>
#include <qpixmap.h>
#include <qlist.h>
#include <qsqldatabase.h>
#include <qpopmenu.h>
#include <qtoolbar.h>
#include <qaction.h>
#include <qstatusbar.h>
#include <qvbox.h>
#include <qlabel.h>
#include <qwidgetfactory.h>
#include <qsignalmapper.h>
#include <qdict.h>
#include <qstylefactory.h>
#include <qstyle.h>
#include <qfontdialog.h>
#include <qmenubar.h>
#include <qsettings.h>
#include <qpainter.h>
#include <qimage.h>
#include <qtimer.h>

/** Objeto apllicacin para FacturaLUX.

    @author  Federico Albujer Zornoza
    @version 0.4 */
class FLApplication:public QApplication
{
    Q_OBJECT

    public:

    /** construtor */
    FLApplication(int & argc, char ** argv);

    /** destructor */
    ~FLApplication();

    /** Para obtener el espacio de trabajo */
    QWorkspace *workspace() const
    {
        return pWorkspace;
    }

    /** Muestra la pantalla de presentacion */
    QLabel *showSplash();

    /** Oculta la pantalla de presentacion */
    static void closeSplash();

    /** Muestra una cadena de texto en la pantalla de presentacion */
    void set_splash_status( const QString &txt );

    /** Establece la base de datos FLApplication::generalDB

        @param  db  Objeto QSqlDatabase con la base de datos */
    void setGeneralDB(QSqlDatabase * db);

    /** Para obtener la base de datos por defecto.

        @return Objeto  QsqlDatabase con la base de datos po defecto */
    QSqlDatabase *generalDB() const
    {
        return generalDB_;
    }

    /** Para establecer el widget pricipal.

        @param  w Widget principal. */
    void setMainWidget(QWidget *w);

    /** Para obtener el widget principal del formulario.

        return Objeto QWidget que corresponde con el widget principal del formulario. */
    QWidget *mainWidget () const
    {
    		return mainWidget_;
    }

    public slots:

    /** Para confimar salir de la aplicacion */
    bool queryExit();

     /** Cambia el mensaje de estado en toda la barra de estado temporalmente */
    void statusHelpMsg(const QString & text);

    protected:

    /** Guarda el estado actual de la ventanas de la aplicacin */
    void writeState();

    /** Lee el estado guardado de la ventanas de la aplicaci */
    void readState();

    /** Abre en el MDI el formulario maestro del tipo FLFormDB asociado a una accion.

        @param  n   Nombre de la accion asociada al formulario maestro.
        @param  p   Imagen QPixmap que sirve de icono para el formulario. */
    void openMasterForm( const QString & n,  const QPixmap & p );

    private slots:

    /** Sale de la aplicacion, pidiendo confirmacin. */
    void generalExit();
	
    /** Abre el formulario por defecto para una accion.

        El uso normal es conectar la seal activated() de una accion de FLWidgetApplication.ui
        a este slot. El nombre de esa accin debe tener correspondencia en actions.xml. */
    void openDefaultForm();

    /** Conmuta la barra de herramientas entre visible y oculta */
    void toggleToolBar(bool toggle);

    /** Conmuta la barra de estado entre visible y oculta */
    void toggleStatusBar(bool toggle);

    /** Muestra el dialogo "Acerca de" */
    void helpAbout();

    /** Muestra la venta de ayuda con el ndice */
    void helpIndex();
   
    /** Llamado cuando el menu Ventana es activado; regenera el menu ventana con todas
        las ventanas abiertas */
    void windowMenuAboutToShow();

    /** Activa el hijo MDI que se ha seleccionado en el menu Ventana */
    void windowMenuActivated(int id);

    /** Cierra a ventana activa en el espacio de trabajo */
    void windowClose();

    /** Establece un stilo para la apariencia de la aplicacin */
    void makeStyle(const QString &);

    /** Establece el tipo de fuente para la aplicacin */
    void chooseFont();

    private:

    /** Inicia las acciones */
    void initActions();

    /** Inicia la barra de menus */
    void initMenuBar();

    /** Inicia la barra de herramientas */
    void initToolBar();

    /** Inicia la barra de estado */
    void initStatusBar();

    /** Inicia el espacio de trabajo */
    void initView();

    /** Inicia el submenu de estilos */
    void initStyles();

    /** Comprueba si una tabla ya est abierta, mediante su formulario, en el MDI.
        Recorre la lista de formularios del MDI, tambin llamado espacio de trabajo (QWorkspace),
        y comprueba si el formulari ya est abierto, en tal caso devuelve TRUE, y restaura el formulario.

        @param id Identificador del  formulario. Corresponde con el nombre de la accion que lo abre.
        @return CIERTO si el formulario ya est abierto y FALSO en caso contrario. */
	bool existsFormInMDI(const QString & id);

    /** Marco MDI frame que engancha los widget hijo MDI, inicalizado en FLApplication::initView() */
    QWorkspace *pWorkspace;

    /** Almacena la base de datos para la aplicacion. */
    QSqlDatabase *generalDB_;

    /** Widget principal del formulario */
    QWidget *mainWidget_;
};

#endif
