/***************************************************************************
                          FLFieldDB.h  -  description
                             -------------------
    begin                : Wed Jul 4 2001
    copyright            : (C) 2001,2002 by Federico Albujer Zornoza
    email                : mail@infosial.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef FLFIELDDB_H
#define FLFIELDDB_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qapplication.h>
#include <qvariant.h>
#include <qstring.h>
#include <qwidget.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qspinbox.h>
#include <qlineedit.h>
#include <qfiledialog.h>
#include <qpainter.h>
#include <qvalidator.h>
#include <qdatetime.h>
#include <qdatetimeedit.h>
#include <qtextedit.h>
#include <qcheckbox.h>
#include <qpixmapcache.h>
#include <qwidgetfactory.h>
#include <qtoolbutton.h>
#include <qframe.h>

#include "FLWidgetFieldDB.h"

class FLSqlCursor;

/** PLUGIN que enlaza con el campo de una tabla.

    Esta clase es utilizada como plugin y solo debe insertarse
    como componente en una ventana (widget) que sea de la clase
    FLFormDB, o que uno de sus padres se un objeto FLFormDB.
    Es decir solo tiene sentido insertarlo en una ventana
    que est enlazada con una tabla de la base de datos.

    Este componente es utilizado en los formularios y
    se autoconfigura, a partir de los metadatos. Adems
    de servir de edicin de un campo del registro actual del
    cursor, permite mediante el botn de bsqueda buscar su valor
    en la tabla de bsqueda asociada, o en un fichero del disco
    (como por ejemplo un pixmap) segn corresponda.

    La tabla de busqueda asociada viene	a ser la tabla con la
    que se relaciona la tabla origen de este campo y que
    precisamente esta relacionada por dicho campo.

    Por ejemplo;
    si el campo es el de DIVISA de la tabla CLIENTES, el valor
    de DIVISA	se deber buscar en la tabla de DIVISAS, ya que
    la tabla CLIENTES est relacionada con la tabla DIVISAS, y
    la cardinalidad de la relacion sera

    CLIENTES <-M----1-> DIVISAS,

    (un cliente tiene una divisa y una divisa	puede estar en muchos
    clientes). Cuando queramos asignar una divisa a un cliente
    no vale cualquier valor si no uno de los que tenemos en la tabla
    divisa, entonces con el botn de busqueda del componente se nos
    abre la tabla divisas donde podemos escoger el valor oportuno.

    @author   Federico Albujer Zornoza
    @version  0.4 */
class FLFieldDB:public FLWidgetFieldDB
{
	Q_OBJECT
	Q_PROPERTY (QCString fieldName READ fieldName WRITE setFieldName)
	Q_PROPERTY (QCString tableName READ tableName WRITE setTableName)
 	Q_PROPERTY (QCString foreignField READ foreignField WRITE setForeignField)
   Q_PROPERTY (QCString fieldRelation READ fieldRelation WRITE setFieldRelation)
   Q_PROPERTY (QCString actionName READ actionName WRITE setActionName)

	public:

	/** constructor */
  	FLFieldDB (QWidget * parent = 0, const char *name = 0);

	/** desctructor */
   	~FLFieldDB ();

   /** Para obtener el nombre de la accion.

      @return Nombre de la accion */
  	QCString actionName () const;

	/** Para establecer el nombre de la accion.

      @param aN Nombre de la accion */
  	void setActionName (const QCString & aN);

	/** Para obtener el nombre del campo.

      @return Nombre del campo */
  	QCString fieldName () const;

	/** Para establecer el nombre del campo.

      @param fN Nombre del campo */
  	void setFieldName (const QCString & fN);

	/** Para obtener el nombre de la tabla fornea.

      @return Nombre de la tabla */
  	QCString tableName () const;

	/** Para establecer el nombre de la tabla fornea.

      @param fT Nombre de la tabla */
  	void setTableName (const QCString & fT);

	/** Para obtener el nombre del campo forneo.

      @return Nombre del campo */
  	QCString foreignField () const;

	/** Para establecer el nombre del campo forneo.

      @param fN Nombre del campo */
  	void setForeignField (const QCString & fN);

	/** Para obtener el nombre del campo relacionado.

      @return Nombre del campo */
  	QCString fieldRelation () const;

  	/** Para obtener el widget editor.
  	
  	@return Objeto con el editor del campo */
  	QWidget *editor() const
  	{
  		return editor_;
  	}
  	
	/** Para establecer el nombre del campo relacionado.

      @param fN Nombre del campo */
  	void setFieldRelation(const QCString & fN);
	
  	public slots:

	/** Refresca el contenido del campo con los valores del cursor de la tabla origen.
	
		Si se indica el nombre de un campo slo "refresca" si el campo indicado
		coincide con la propiedad fieldRelation, tomando como filtro el valor del campo
		fieldRelation de la tabla relacionada. Si no se indica nign nombre de
		campo el refresco es llevado a cabo siempre.
		
		@param fN Nombre de un campo*/
  	void refresh (QString fN=QString::null);

	/** Inicia el cursor segun este campo sea de la tabla origen o de
      una tabla relacionada */
  	void initCursor ();

	/** Crea e inicia el editor apropiado para editar el tipo de datos
      contenido en el campo (p.e: si el campoe contiene una fecha crea
      e inicia un QDataEdit) */
  	void initEditor ();

 	protected slots:

	/** Abre un dialogo para buscar en una tabla o en ficheros
      el valor del campo */
  	void searchValue ();

	/** Actualiza el valor del campo con una cadena de texto.

      @param  t   Cadena de texto para actualizar el campo */
  	void updateValue (const QString & t);

	/** Actualiza el valor del campo con una fecha.

      @param  d   Fecha para actualizar el campo */
  	void updateValue (const QDate & d);

	/** Actualiza el valor del campo con una hora.

      @param  t   Hora para actualizar el campo */
  	void updateValue (const QTime & t);

	/** Actualiza el valor del campo con un valor logico.

      @param  b   Valor logico para actualizar el campo */
  	void updateValue (bool b);

	/** Actualiza el valor del campo con un texto, si el componente
      es del tipo QTextEdit */
  	void updateValue ();

	private:

	/** Editor para el contenido del campo que representa el componente */
    	QWidget * editor_;

	/** Nombre del campo de la tabla al que esta asociado este componente */
  	QString fieldName_;

	/** Nombre de la tabla franea */
  	QString tableName_;

        /** Nombre de la accion*/
  	QString actionName_;

	/** Nombre del campo forneo */
  	QString foreignField_;

	/** Nombre del campo de la relacin */
	QString fieldRelation_;
  	
	/** Cursor con los datos de la tabla origen para el componente */
  	FLSqlCursor *cursor_;

	/** Cursor auxiliar de uso interno para almacenar los registros de la tabla
	    relacionada con la de origen */
  	FLSqlCursor *cursorAux;
  	
  	/** Este atributo se pone a TRUE cuando se el campo ya ha sido refrescado por
  	    lo menos una vez.  */
  	bool refreshOne;

       /** Indica que si ya se ha inicializado el cursor */
       bool cursorInit;

        /** Indica que si ya se ha inicializado el cursor auxiliar */
       bool cursorAuxInit;
};

/* Uso interno */
class FLLineEdit : public QLineEdit
{
    Q_OBJECT

    public:
    FLLineEdit( QWidget * parent, const char * name = 0 );

    protected:
    void keyPressEvent ( QKeyEvent * e );

    signals:
    void key_F2_Pressed();
};

class PixmapView:public QScrollView, public QFilePreview
{
public:

  PixmapView (QWidget * parent = 0);
  void setPixmap (const QPixmap & pix);
  void drawContents (QPainter * p, int, int, int, int);
  void previewUrl (const QUrl & u);

private:

    QPixmap pixmap;
};

class FLDoubleValidator : public QDoubleValidator
{
public:
    FLDoubleValidator(QObject *parent, const char *name=0);
    FLDoubleValidator(double bottom, double top, int decimals, QObject * parent, const char *name=0);
    QValidator::State validate(QString & input, int &) const;

};

#endif
