# This file is part of Fail2Ban.
#
# Fail2Ban is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Fail2Ban is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Fail2Ban; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# Author: Cyril Jaquier
# 
# $Revision: 458 $

__author__ = "Cyril Jaquier"
__version__ = "$Revision: 458 $"
__date__ = "$Date: 2006-11-12 15:52:36 +0100 (Sun, 12 Nov 2006) $"
__copyright__ = "Copyright (c) 2004 Cyril Jaquier"
__license__ = "GPL"

import logging
from configreader import ConfigReader

# Gets the instance of the logger.
logSys = logging.getLogger("fail2ban.client.config")

class FilterReader(ConfigReader):
	
	def __init__(self, fileName, name):
		ConfigReader.__init__(self)
		self.__file = fileName
		self.__name = name
	
	def setFile(self, fileName):
		self.__file = fileName
	
	def getFile(self):
		return self.__file
	
	def setName(self, name):
		self.__name = name
	
	def getName(self):
		return self.__name
	
	def read(self):
		return ConfigReader.read(self, "filter.d/" + self.__file)
	
	def getOptions(self, pOpts):
		opts = [["string", "timeregex", None],
				["string", "timepattern", None],
				["string", "ignoreregex", ""],
				["string", "failregex", ""]]
		self.__opts = ConfigReader.getOptions(self, "Definition", opts, pOpts)
	
	def convert(self):
		stream = list()
		for opt in self.__opts:
			if opt == "timeregex":
				stream.append(["set", self.__name, "timeregex", self.__opts[opt]])
			elif opt == "timepattern":
				stream.append(["set", self.__name, "timepattern", self.__opts[opt]])
			elif opt == "failregex":
				stream.append(["set", self.__name, "failregex", self.__opts[opt]])
			elif opt == "ignoreregex":
				stream.append(["set", self.__name, "ignoreregex", self.__opts[opt]])		
		return stream
		