/*
 * Farsight Voice+Video library
 * Copyright (c) 2005 Philippe Khalaf <burger@speedy.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __MSNAVCONF_H__
#define __MSNAVCONF_H__

#include <glib.h>
#include <glib-object.h>

#include <farsight/farsight-protocol.h>

G_BEGIN_DECLS

/* TYPE MACROS */
#define FARSIGHT_TYPE_MSNAVCONF \
  (farsight_msnavconf_get_type())
#define FARSIGHT_MSNAVCONF(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), FARSIGHT_TYPE_MSNAVCONF, FarsightMsnAVConf))
#define FARSIGHT_MSNAVCONF_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass), FARSIGHT_TYPE_MSNAVCONF, FarsightMsnAVConfClass))
#define FARSIGHT_IS_MSNAVCONF(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), FARSIGHT_TYPE_MSNAVCONF))
#define FARSIGHT_IS_MSNAVCONF_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE((klass), FARSIGHT_TYPE_MSNAVCONF))
#define FARSIGHT_MSNAVCONF_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), FARSIGHT_TYPE_MSNAVCONF, FarsightMsnAVConfClass))

typedef struct _FarsightMsnAVConf      FarsightMsnAVConf;
typedef struct _FarsightMsnAVConfClass FarsightMsnAVConfClass;

struct _FarsightMsnAVConfClass {
    FarsightProtocolClass parent_class;
};

struct _FarsightMsnAVConf {
    FarsightProtocol parent;

    gchar *remote_sip_host;
    guint remote_sip_port;

    gchar *remote_host;
    guint remote_audio_port;
    guint remote_video_port;
};

GType farsight_msnavconf_get_type   (void);

G_END_DECLS

#endif
