/* $Id: TypeMismatch.hpp 4323 2009-01-27 13:48:12Z potyra $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __TYPE_MISMATCH_HPP_INCLUDED
#define __TYPE_MISMATCH_HPP_INCLUDED

#include "frontend/reporting/AmbiguousTypes.hpp"

namespace ast {

//! Types mismatch.
/** FIXME: almost identical to AmbiguousTypes! */
class TypeMismatch : public AmbiguousTypes {
public:
	//! c'tor
	/** @param ambigousNode node which resolves to ambigous types.
	 *  @param possibleTypes possible type declarations for this node.
	 *  @param msg message.
	 */
	TypeMismatch(
		const AstNode &ambigousNode,
		std::list<const TypeDeclaration*> possibleTypes,
		std::string msg);

protected:
	/** output error to stream
	 *  @param stream stream to write error to.
	 */
	virtual void put(std::ostream &stream) const;
};

}; /* namespace ast */

#endif /* __TYPE_MISMATCH_HPP_INCLUDED */
