#include "config.h"

#include <stdio.h>
#include <stdlib.h>

#include "loader.h"

/* ----------------------------------------------------------------------- */

void load_gray(unsigned char *dst, unsigned char *src, int width)
{
    int i;

    for (i = 0; i < width; i++) {
	dst[0] = src[0];
	dst[1] = src[0];
	dst[2] = src[0];
	dst += 3;
	src += 1;
    }
}

void load_graya(unsigned char *dst, unsigned char *src, int width)
{
    int i;

    for (i = 0; i < width; i++) {
	dst[0] = src[0];
	dst[1] = src[0];
	dst[2] = src[0];
	dst += 3;
	src += 2;
    }
}

void load_rgba(unsigned char *dst, unsigned char *src, int width)
{
    int i;

    for (i = 0; i < width; i++) {
	dst[0] = src[0];
	dst[1] = src[1];
	dst[2] = src[2];
	dst += 3;
	src += 4;
    }
}

/* ----------------------------------------------------------------------- */

struct ida_loader *loaders[] = {
    &ppm_loader,
    &pgm_loader,
    &bmp_loader,
#ifndef X_DISPLAY_MISSING
    &xwd_loader,
#endif
#ifdef HAVE_LIBPCD
    &pcd_loader,
#endif
#ifdef HAVE_LIBJPEG
    &jpeg_loader,
#endif
#ifdef HAVE_LIBUNGIF
    &gif_loader,
#endif
#ifdef HAVE_LIBPNG
    &png_loader,
#endif
#ifdef HAVE_LIBTIFF
    &tiff1_loader,
    &tiff2_loader,
#endif
#ifdef HAVE_LIBMAGICK
    &magick_loader,
#endif
#ifdef USE_X11
    &xpm_loader,
    &xbm1_loader,
    &xbm2_loader,
#endif
    NULL
};

#ifdef USE_X11
struct ida_writer *writers[] = {
    &ppm_writer,
    &ps_writer,
#ifdef HAVE_LIBJPEG
    &jpeg_writer,
#endif
#ifdef HAVE_LIBTIFF
    &tiff_writer,
#endif
#ifdef HAVE_LIBPNG
    &png_writer,
#endif
    NULL
};
#endif
