"""Tooltip message window"""


from Tkinter import *

from ..constants import MESSAGE_BG_COL, TOOLTIP_DELAY


class ToolTip(object):

    def __init__(self, master=None, text=None):
        self.master = master
        self.text = text
        self.window = None
        self.id = None
        self.x, self.y = 0, 0
        self.bindToMasterWidget()

    def bindToMasterWidget(self):
        self.master.bind('<Enter>', self.sheludeToolTip)
        self.master.bind('<Leave>', self.destroyToolTip)
        self.master.bind('<Button>', self.destroyToolTip)

    def sheludeToolTip(self, event=None):
        if not self.window:
            self.id = self.master.after(TOOLTIP_DELAY, self.createToolTip)

    def createToolTip(self):
        if not self.window:
            try:
                self.createWindow()
                self.withdrawAndUpdateWindow()
                self.getPosition()
                self.setPosition()
                self.window.deiconify()
            except AttributeError:
                self.destroyToolTip()

    def withdrawAndUpdateWindow(self):
        """Withdraw and update tooltip window

        it must to be done to get correct tooltip measurements.
        """
        self.window.withdraw()
        self.window.update()

    def createWindow(self):
        self.window = Toplevel(self.master)
        self.window.overrideredirect(True)
        label = Label(self.window, text=self.text, justify=LEFT, 
                      bg=MESSAGE_BG_COL)
        label.pack()

    def getPosition(self):
        """Get master widget position 

        and offset tooltip to be centered benith it
        """
        self.x = self.master.winfo_rootx() + self.findCenter()
        self.y = self.master.winfo_rooty() + self.master.winfo_height() + 2

    def findCenter(self):
        return  (self.master.winfo_width() - self.window.winfo_reqwidth()) // 2

    def setPosition(self):
        self.window.geometry('+{0}+{1}'.format(self.x, self.y))

    def destroyToolTip(self, event=None):
        self.cancelWindow()
        self.cancelId()

    def cancelWindow(self):
        if self.window:
            self.window.destroy()
            self.window = None

    def cancelId(self):
        if self.id:
            self.master.after_cancel(self.id)
            self.id = None
