/*
 *      fhist - file history and comparison tools
 *      Copyright (C) 1993, 1994, 1998, 1999, 2002, 2008 Peter Miller
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 3 of the License, or
 *      (at your option) any later version.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with this program. If not, see
 *      <http://www.gnu.org/licenses/>.
 */

#ifndef SUBROUTINE_H
#define SUBROUTINE_H

#include <ac/stdio.h>

#include <main.h>

#define OHF_READ 1
#define OHF_WRITE 2

int history_file_exists(void);
FILE *openhistoryfile(int mode);
long findeditnumber(FILE *fp, char *editname);
POS *readpostable(FILE *fp);
void startedit(FILE *fp, long num, char *infoline);
FILE *opensourcefile(void);
int renamefiles(char *extension);
int checknewfile(char *name);
int queryuser(void);
char *get_a_line(FILE *fp, long pos, int type, const char *filename);
char *getnumber(char *cp, long *value);
int pathconf_name_max(char *path);

#endif /* SUBROUTINE_H */
