#!/bin/sh
#
#	fhist - file history and comparison tools
#	Copyright (C) 2000 Peter Miller;
#	All rights reserved.
#
#	This program is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with this program; if not, write to the Free Software
#	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
#
# MANIFEST: Test the fhist -bin functionality
#

work=/tmp/$$
PAGER=cat
export PAGER

fail()
{
	set +x
	echo 'FAILED test of the fhist -bin functionality' 1>&2
	cd $here
	rm -rf $work
	exit 1
}
pass()
{
	set +x
	echo PASSED 1>&2
	cd $here
	rm -rf $work
	exit 0
}
trap "fail" 1 2 3 15

here=`pwd`
if test $? -ne 0 ; then exit 1; fi
mkdir $work
if test $? -ne 0 ; then exit 1; fi
cd $work
if test $? -ne 0 ; then fail; fi

if [ "$1" != "" ]; then bin=$here/$1/bin; else bin=$here/bin; fi

#
# test the fhist -bin functionality
#
mkdir FHIST
if test $? -ne 0 ; then fail; fi

cat > test.uue << 'fubar'
begin 644 test
-2&5L;&\L`%=O<FQD(0``
`
end
fubar
if test $? -ne 0 ; then fail; fi

cat > test.ok << 'fubar'
B 1
Hello,=00World!=
fubar
if test $? -ne 0 ; then fail; fi

uudecode test.uue
if test $? -ne 0 ; then fail; fi

$bin/fhist -cr test -bin -r > LOG 2>&1
if test $? -ne 0 ; then cat LOG; fail; fi

diff test.ok FHIST/test.s
if test $? -ne 0 ; then fail; fi

$bin/fhist test -extract -o test.out -bin > LOG 2>&1
if test $? -ne 0 ; then cat LOG; fail; fi

cmp test test.out
if test $? -ne 0 ; then fail; fi

#
# Only definite negatives are possible.
# The functionality exercised by this test appears to work,
# no other guarantees are made.
#
pass
