#ifndef FIGURINE_EXTERN_H
#define FIGURINE_EXTERN_H

/* COPYRIGHT (C) 2000 THE VICTORIA UNIVERSITY OF MANCHESTER and John Levon
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details. 
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA. 
 */
/*
 * $Log: extern.h,v $
 * Revision 1.3  2000/12/17 00:57:44  moz
 * examples, filled open splines, highlight_objects
 *
 * Revision 1.2  2000/12/06 20:56:08  moz
 * GPL stuff.
 *
 * Revision 1.1.1.1  2000/08/21 01:05:32  moz
 *
 *
 * Revision 1.1.1.1  2000/07/19 22:45:32  moz
 * CVS Import
 *
 * Revision 1.15  2000/02/27 21:28:54  moz
 * Removed unused and non-global variables.
 *
 * Revision 1.14  2000/01/21 11:46:49  moz
 * Removed un-needed GCs.
 *
 * Revision 1.13  2000/01/21 11:21:39  moz
 * last_mouse_movement isn't used.
 *
 * Revision 1.12  1999/11/15 02:13:19  moz
 * Name change.
 *
 * Revision 1.11  1999/05/23 00:28:04  moz
 * Pedantic changes.
 *
 * Revision 1.10  1999/05/22 15:08:43  moz
 * compound_outlines and guide_lines added.
 *
 * Revision 1.9  1999/05/19 17:11:40  moz
 * 1.0 Checkin.
 *
 * Revision 1.8  1999/05/05 12:29:19  moz
 * Print dialog.
 *
 * Revision 1.7  1999/05/03 06:21:49  moz
 * FIG files only windows added for save and insert.
 *
 * Revision 1.6  1999/04/29 22:57:37  moz
 * redostack added.
 *
 * Revision 1.5  1999/04/29 00:26:32  moz
 * Removed nodebox_icon.
 *
 * Revision 1.4  1999/04/27 21:15:28  moz
 * Store hpw Window and tooltips status.
 *
 * Revision 1.3  1999/04/23 01:06:13  moz
 * Fig files only window.
 *
 * Revision 1.2  1999/04/04 01:50:31  moz
 * Export dialog windows.
 *
 * Revision 1.1  1999/03/30 00:10:03  moz
 * Initial revision
 *
 */

#include "figurine.h" 
#include "stk.h" 
 
/* see globals.c for documentation for these variables  */  
 
  
   
extern List undostack;
extern List redostack; 
extern int undolevels; 

extern Boolean tooltips;
extern Boolean compound_outlines;
extern Boolean highlight_objects;
extern Boolean guide_lines;
extern Atom windelete;
extern Atom winproto; 

extern List freelist; 
extern Window file_dialog;
extern Window lfile_text;
extern Window rfile_text;
extern Window file_figfiles; 
extern Window file_entry; 
extern Window file_ok;
extern Window file_cancel;
extern Window savefile_dialog;
extern Window savelfile_text;
extern Window saverfile_text;
extern Window savefile_figfiles; 
extern Window savefile_entry; 
extern Window savefile_ok;
extern Window savefile_cancel;
extern Window insertfile_dialog;
extern Window insertlfile_text;
extern Window insertrfile_text;
extern Window insertfile_figfiles; 
extern Window insertfile_entry;
extern Window insertfile_ok;
extern Window insertfile_cancel; 
extern Window exportfile_dialog;
extern Window exportlfile_text;
extern Window exportrfile_text;
extern Window exportformat_text;
extern Window exportfile_entry;
extern Window exportfile_ok;
extern Window exportfile_cancel;
extern Window printfile_dialog;
extern Window printfile_entry;
extern Window printfile_choice;
extern Window printfile_print;
extern Window printfile_cancel; 
extern Window view_dialog;
extern Window view_gridx_entry;
extern Window view_gridy_entry;
extern Window view_ok;
extern Window view_apply; 
extern Window view_cancel;            
extern Window view_mm;
extern Window view_inch;
extern Window view_units; 
extern Window view_guides;
extern Window view_highlight;
extern Window view_compounds;

extern Window lw_dialog;
extern Window lw_entry;
extern Window lw_ok;
extern Window lw_apply;
extern Window lw_cancel;

extern Window roundbox_dialog;
extern Window roundbox_choice;
extern Window roundbox_entry;
extern Window roundbox_ok;
extern Window roundbox_apply;
extern Window roundbox_cancel;   

extern Window polygon_dialog;
extern Window polygon_choice;
extern Window polygon_entry;
extern Window polygon_ok;
extern Window polygon_apply;
extern Window polygon_cancel;

extern Window spline_dialog;
extern Window spline_choice;
extern Window spline_slider;
extern Window spline_entry; 
extern Window spline_ok;
extern Window spline_apply;
extern Window spline_cancel;  

extern Window font_dialog;
extern Window font_typeface_text;
extern Window font_size_text;
extern Window font_entry;
extern Window font_close;

extern Window arrow_dialog;
extern Window larrow_choice;
extern Window larrow_fillchoice;
extern Window larrow_type;
extern Window larrow_width;
extern Window larrow_height;
extern Window larrow_thickness;
extern Window rarrow_choice;
extern Window rarrow_fillchoice;
extern Window rarrow_type;
extern Window rarrow_width;
extern Window rarrow_height;
extern Window rarrow_thickness;  
extern Window arrow_ok;
extern Window arrow_apply;
extern Window arrow_cancel;

extern State state; 

extern VColour cols[];
extern VColour fillcols[];
extern int numcols;
extern int fillnumcols; 
extern GC backgc;
extern GC fillgc; 
extern GC blackxorgc; 
extern GC handlegc; 
extern GC whitegc; 
extern GC ugc;
extern GC dashgc; 
extern GC rulergc;

extern unsigned long ob_ticket; 
extern int mouse_x; 
extern int mouse_y; 
extern int last_mouse_x; 
extern int last_mouse_y; 
extern double screen_ppi;
extern List docs;
extern List wins;
extern WindowStruct toolWindow;

extern Display *display;
extern int screen;
extern XFontStruct *font; 
extern XFontStruct *rulerfont; 

extern Boolean quitting; 
extern stkMenuBar main_menu; 
extern stkMenu file_menu;
extern stkMenu options_menu;
extern Window hpw; 
extern stkMenu view_menu; 
extern Window vmw; 
extern stkMenu edit_menu;
extern Window emw;
extern stkIconPanel icon_panel;
extern stkIconMenu icon_float; 
extern stkIconMenu linestyle_float; 
extern stkIconMenu endstyle_float;
extern stkIconMenu joinstyle_float;
extern stkIconMenu fillstyle_float; 
extern stkIconMenu setarcellipse_float; 
extern stkIcon eye_icon; 
extern stkIcon grid_icon; 
extern stkIcon showgrid_icon; 
extern stkIcon zoomin_icon; 
extern stkIcon zoomout_icon; 
extern stkIcon linestyle_icon; 
extern stkIcon fillstyle_icon; 
extern stkIcon colour_icon; 
extern stkIcon fillcolour_icon; 
extern stkIcon arrow_icon;
extern stkIcon setpolygon_icon;
extern stkIcon endstyle_icon;
extern stkIcon joinstyle_icon;
extern stkIcon font_icon;
extern stkIcon linewidth_icon;
extern stkIcon setspline_icon;
extern stkIcon setarcellipse_icon; 
extern stkIcon roundbox_icon;
extern stkIcon justification_icon;
extern stkIcon icons[];
extern int icon_number; 
extern stkIcon floaticons[];
extern int floaticon_number;
extern Window float_menu; 
extern stkIcon linestyleicons[];
extern int linestyleicon_number;
extern stkIcon endstyleicons[];
extern int endstyleicon_number;
extern stkIcon setarcellipseicons[];
extern int setarcellipseicon_number;
extern stkIcon joinstyleicons[];
extern int joinstyleicon_number;
extern Window linestyle_menu;
extern Window endstyle_menu;
extern Window joinstyle_menu;
extern Window setarcellipse_menu; 
extern stkIcon *fillstyleicons;
extern int fillstyleicon_number;
extern Window fillstyle_menu;
extern Window colour_menu; 
extern Window fillcolour_menu; 
extern Pixmap fills[]; 
extern Pixmap bfills[]; 
extern Pixmap nofill; 
extern char *filltags[]; 
extern char *fontnames[40][2]; 
int numfontnames; 
extern List afonts; 

extern uint justificationicon_number;
extern stkIcon justificationicons[];
extern stkIconMenu justification_float;
extern Window justification_menu;    
extern Papersize sizes[14]; 

extern XrmDatabase XresourceDatabase; 
extern int XcommandLineTableEntries;
extern XrmDatabase XcommandLineDatabase;
extern XrmOptionDescRec XcommandLineTable[];  
#endif
