/* load.c  */ 
/* COPYRIGHT (C) 2000 THE VICTORIA UNIVERSITY OF MANCHESTER and John Levon
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details. 
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA. 
 */
/*
 * $Log: load.c,v $
 * Revision 1.2  2000/12/06 20:56:02  moz
 * GPL stuff.
 *
 * Revision 1.1.1.1  2000/08/21 01:05:31  moz
 *
 *
 * Revision 1.1.1.1  2000/07/19 22:45:30  moz
 * CVS Import
 *
 * Revision 1.36  2000/03/13 02:47:28  moz
 * Fill in useless text Object parameters.
 *
 * Revision 1.35  2000/03/13 00:05:55  moz
 * Finally fixed compound-in-compound depth bug.
 *
 * Revision 1.34  2000/03/11 19:09:51  moz
 * Compile fix for previous change.
 *
 * Revision 1.33  2000/03/07 21:13:56  moz
 * Compile fixes.
 *
 * Revision 1.32  2000/03/04 23:33:50  moz
 * Handle huge fonts more gracefully.
 *
 * Revision 1.31  2000/03/04 17:38:32  moz
 * Remarkable simple fix for rot+not left just bug.
 *
 * Revision 1.30  2000/03/04 17:18:33  moz
 * Rotated text just!=LEFT fix part 1 - don't adjust when rotated.
 *
 * Revision 1.29  2000/02/18 21:18:31  moz
 * polyline.pic usage changed.
 *
 * Revision 1.28  2000/02/04 01:54:12  moz
 * switch_icons() needs view
 *
 * Revision 1.27  2000/01/28 17:31:15  moz
 * Skip ###FIGURINE correctly.
 *
 * Revision 1.26  2000/01/26 18:18:08  moz
 * Don't use ++ in call to add_to_list (may be a ammacro).
 *
 * Revision 1.25  1999/11/17 01:14:52  moz
 * Cut down foliage a little.
 *
 * Revision 1.24  1999/11/15 02:08:38  moz
 * Use rounded trig.
 * Name change.
 *
 * Revision 1.23  1999/06/17 19:09:12  moz
 * Load saved attachment information and calculate the correct derries.
 *
 * Revision 1.22  1999/06/17 15:49:05  moz
 * Plug text with NULL.
 *
 * Revision 1.21  1999/06/16 00:56:41  moz
 * Slight change to error message for clarity.
 *
 * Revision 1.20  1999/05/23 21:20:08  moz
 * Fixed fill style for black/white objects.
 *
 * Revision 1.19  1999/05/22 23:39:09  moz
 *  Pedantic ANSI.
 *
 * Revision 1.18  1999/05/22 15:31:09  moz
 * Handle text justifications other than LEFT
 *
 * Revision 1.17  1999/05/22 04:18:37  moz
 * Slight improvement in compound depth handling.
 *
 * Revision 1.16  1999/05/22 04:12:09  moz
 * Fixed 3dhouse.fig. Needed to reverse depth list.
 *
 * Revision 1.15  1999/05/22 03:53:12  moz
 * Implicit depth ordering handled for normal objects.
 * Still very broken for compounds (contrast transit.fig and greenpig.fig).
 *
 * Revision 1.14  1999/05/19 17:08:55  moz
 * 1.0 Checkin.
 *
 * Revision 1.13  1999/05/04 18:16:54  moz
 * Tints approximated.
 *
 * Revision 1.12  1999/04/29 03:57:46  moz
 * Should delete font ascent from y1, not x1.
 *
 * Revision 1.11  1999/04/29 01:34:37  moz
 * Correctly calculate the x,y topleft corner of the text.
 *
 * Revision 1.10  1999/04/28 20:14:26  moz
 * Removed unused variables.
 *
 * Revision 1.9  1999/04/28 16:53:22  moz
 * Fixed bbox calculation of rottext.
 *
 * Revision 1.8  1999/04/27 20:46:04  moz
 * Fix ob.polyline.pic bug.
 *
 * Revision 1.7  1999/04/27 16:00:10  moz
 * Flip text angle on load.
 *
 * Revision 1.6  1999/04/27 06:46:00  moz
 * When on cmdline, create new document instead of rejecting filename.
 *
 * Revision 1.5  1999/04/27 04:11:05  moz
 * Bug tagged FIX ME.
 *
 * Revision 1.4  1999/04/24 22:23:45  moz
 * Load user-defined colours and store them.
 *
 * Revision 1.3  1999/04/20 03:13:48  moz
 * Removed old code.
 *
 * Revision 1.2  1999/04/20 03:07:29  moz
 * Changes to fix arcellipse loading.
 *
 * Revision 1.1  1999/03/30 00:05:21  moz
 * Initial revision
 *
 */    

#include <ctype.h> 
#include <string.h> 
#include <math.h> 
#include "include/figurine.h"
#include "include/extern.h"

/* list of all objects loaded  */  
List obs=NULL;

/* temporary list of derry hosts - ob is host ob */ 
static List pderries=NULL;
/* temporary list of derry sources - ob is source ob  */ 
static List underried=NULL; 

/* maximum size of a line  */  
#define MLINE 16384

static FILE *fl=NULL;  
static Document *doc;
static Boolean in_mm; 
static char empty[] = ""; 
/* this is a pointer to a string
	containing the current line of the file */  
static char *cp; 
static ulong ob_depth=ULONG_MAX; 
 
/* fluff in a file is ignored  */   
Boolean 
is_fluff(char *c)
{ 
	if (is_vcomment(c))
		return FALSE;

 	return (c==NULL || *c=='\n' || *c=='#' || *c=='\0');  
} 
 
/* returns up to end of line  */   
char *
get_whole_line()
{
	static char str[MLINE];
	 
	strcpy(str,"\n");  
	  
	while (is_fluff(str) && fgets(str,MLINE,fl)!=NULL)
		;

	while (strlen(str) && isspace(str[strlen(str)-1]))
		str[strlen(str)-1] = '\0';
		 
	while (str[0]!='\0' && isspace(str[0]))
		strcpy(str,str+1);

	if (is_fluff(str))
		cp = empty;
	else
		cp = str;
		 
	return cp;
}
  
/* read in paper size of document  */  
void 
parse_papersize()
{
	char s[MLINE];
	int i; 

	strcpy(s,cp);
	
	for (i=0; i<14; i++)
		{
		if (streq(s,sizes[i].fname))
			{
			strcpy(doc->canvas_name,sizes[i].fname);
			doc->width_in_inches = sizes[i].w;
			doc->height_in_inches = sizes[i].h;
			break;
			};
		};

	if (i==14)
		{
		/* could be "Ledger" apparently  */ 
		/* assume Letter anyway  */  
		strcpy(doc->canvas_name,sizes[0].fname);
		doc->width_in_inches = sizes[i].w;
		doc->height_in_inches = sizes[i].h;
		};
}

/* convenience function  */  
Boolean 
string_eq(char *str)
{
	Boolean b; 

	b = streq(cp,str);
	get_whole_line();
	return b; 
}

void 
skip_to_space()
{
	while (*cp!='\0' && !isspace(*cp))
		cp++;
	
	while (*cp!='\0' && isspace(*cp))
		cp++;
}

double 
get_double()
{
	double d;

	if (*cp=='\0')
		cp = get_whole_line();

	sscanf(cp,"%lf",&d);
	skip_to_space(); 
	 
	return d;
}

int 
get_int()
{
	int i;

	if (*cp=='\0')
		cp = get_whole_line();

	if (*cp=='\0') 
		return -1; 
		 
	if (!sscanf(cp,"%d",&i))
		i = -1; 
	skip_to_space();

	return i;
}

/* The following get routines pick out values as according
	to the file Doc/FORMAT3.2 for each object */  
int 
get_arc_open()
{
	int i; 
	/* NB xfig docs are WRONG. it is 1 for open and 2 for closed  */ 
	/* if we find a 0 it defaults to closed anyway  */  
	
	i = get_int();
	return (i==0 || i==2) ? FALSE : TRUE;
}

int 
get_line_style()
{
	int i;

	i = get_int();

	if (i==-1)
		i=0;
	
	/* our defines match with the file settings */  
	return i;
}

int 
get_fcolour()
{
	int i;

	i = get_int();

	if (i==-1)
		i=0;
	
	if (i>31 && !is_in_list(doc->cols, (uint)i))
		i=0;

	return i+=STARTOFCOLOURS; /* move up into figurine style numbering */  
}

int 
get_fill_fcolour()
{ 
	int i;

	i = get_int();

	if (i==-1)
		i=0;
	
	if (i>31 && !is_in_list(doc->cols, (uint)i))
		i=0;

	return i+=STARTOFFILLCOLOURS; /* move up into figurine style numbering */ 
}

ulong 
get_depth()
{
	ulong i;

	i = get_int();
	/* push depth to the back of our depth */  
	i = 1000 - i;
	/* save depth for RAISE when loaded */  
	ob_depth = min(ULONG_MAX-i,ob_depth); 
	return ULONG_MAX - i;
}

int 
get_fillstyle(Object *ob)
{
	int i;

	i = get_int();

	if (ob->fillcolour==FILLCWHITE)	
		{
		if (i==-1) return NONE;
		if (i==0)
			{
			ob->fillcolour = FILLCBLACK;
			return 0;
			};
		if (i<20) return 20-i;
		if (i==20) return SOLID;
		if (i<41) return 0;

		return i-20;
		}
	else if (ob->fillcolour==FILLCBLACK)
		{
		if (i==-1) return NONE;
		if (i==0)
			{
			ob->fillcolour = FILLCWHITE;
			return 0;
			};
		if (i<20)
			{ 
			ob->fillcolour = FILLCWHITE; 
			return i;
			}; 
		if (i==20) return SOLID;
		if (i<41) return 0;

		return i-20;
		}
	else
		{
		if (i==-1) return i;
		if (i==0) return 20;
		if (i==20) return SOLID;
		if (i==40)
			{
			ob->fillcolour = FILLCWHITE;
			return SOLID;
			};
		if (i>40) return i-20;
		if (i>0 && i <20) return 20-i;
		if (i>20 && i<40)
			{
			/* better than nothing  */  
			ob->colour = ob->fillcolour-(STARTOFFILLCOLOURS-STARTOFCOLOURS);
			ob->fillcolour = FILLCWHITE;
			return 20-(i-20);
			};

		return 0; 
		}; 
}

int 
get_capstyle()
{
	switch (get_int())
		{
		case 0: return(CapButt); break;
		case 1: return(CapRound); break;
		case 2: return(CapProjecting); break;
		};
	return(CapRound);
}

int 
get_joinstyle()
{
	switch (get_int())
		{
		case 0: return(JoinMiter); break;
		case 1: return(JoinBevel); break;
		case 2: return(JoinRound); break;
		};
	return(JoinMiter); 
}

/* read in a point and unrelativise  */  
VPoint *
parse_point(Object *ob)
{
	VPoint *v;

	v = (VPoint *)malloc(sizeof(VPoint));

	v->x = get_int() - ob->bbox.x1;
	v->y = get_int() - ob->bbox.y1;
	v->derried = FALSE; 
	return v; 

}
 
/* read in a control point and unrelativise  */  
SPoint *
parse_spoint(Object *ob)
{
	SPoint *v;

	v = (SPoint *)malloc(sizeof(SPoint));

	v->x = get_int() - ob->bbox.x1;
	v->y = get_int() - ob->bbox.y1;
	v->derried = FALSE; 
	return v; 

} 

/* parse an arrow definition  */  
Arrow *
parse_arrow()
{
	Arrow *a;

	a = (Arrow *)malloc(sizeof(Arrow));

	a->type = get_int();
	a->filled = get_int();
	a->lw = (long)get_double();
	a->w = (long)(80.0*get_double()/doc->ppi);
	a->h = (long)(80.0*get_double()/doc->ppi);
	return a;
}

/* user-defined colour object  */  
void 
parse_colour_object()
{
	unsigned long planes[1];
	unsigned long colors[1];
	UColour *uc;
	XColor xcol;
	XVisualInfo xvi; 
	
	uc = (UColour *)malloc(sizeof(UColour));
	uc->tag = get_int();
  	strcpy(uc->name,cp);
	get_whole_line(); 
	 
	if (!XMatchVisualInfo(display, screen, DefaultDepth(display,screen), PseudoColor, &xvi)
	    && !XMatchVisualInfo(display, screen, DefaultDepth(display,screen), DirectColor, &xvi))
	    	{ 
		if (!XMatchVisualInfo(display, screen, DefaultDepth(display,screen), TrueColor, &xvi))
			{ 
			fprintf(stderr,"figurine: wrong Visual: can't allocate read/write colorcell.\n"); 
			return;
			}; 
		/* TrueColor, so just parse the color, so get_colour for read-only */
		get_colour(&uc->colour,FALSE,"figurine.dummyargk","Figurine.Dummyargk", uc->name); 
		doc->cols = add_to_list(doc->cols,(ulong)uc->tag,(ulong)uc->tag,(void *)uc);
		return; 
		};
	
	if (!XAllocColorCells(display, DefaultColormap(display,screen), False, planes,
								 1, colors, 1))
		{
		fprintf(stderr,"figurine: no colorcells left.\n"); 
		return;
		}; 
				 
	if (!XParseColor(display,DefaultColormap(display,screen), uc->name, &xcol)) 
		{ 
		fprintf(stderr,"figurine: couldn't allocate document colour %s\n", uc->name);
		return;
		}; 
	
	xcol.flags = DoRed | DoGreen | DoBlue;
	xcol.pixel = colors[0];
	uc->colour = colors[0]; 

	XStoreColor(display,DefaultColormap(display,screen),&xcol);
	 
 	doc->cols = add_to_list(doc->cols,(ulong)uc->tag,(ulong)uc->tag,(void *)uc);
}

void
parse_vcomment(Object *ob)
{
	PDerry *pd;
	int ci; 

	if (streq(cp,""))
		get_whole_line();

	while (is_vcomment(cp))
		{
		ci = 0;

		cp += 12; /* skip "###FIGURINE "  */
		if (numstreq(cp,"DERRY_SOURCE ",13))
			{ 
			cp += 13; 
			 
			/* add to list of source derries */  
			pd = (PDerry *)malloc(sizeof(PDerry));

			pd->ob = ob;
			while (*cp!=' ')
				pd->tag[ci++] = *(cp++);
			pd->tag[ci]='\0'; 
			sscanf(cp,"%ld %ld",&pd->x,&pd->y);

			underried = add_to_list(underried,0,0,(void *)pd); 
			} 
		else if (numstreq(cp,"DERRY ",6))
			{ 
			cp += 6; 
			 
			/* add to list of host derries */  
			pd = (PDerry *)malloc(sizeof(PDerry));

			pd->ob = ob;
			while (*cp!=' ')
				pd->tag[ci++] = *(cp++);
			pd->tag[ci]='\0'; 
			sscanf(cp,"%ld %ld",&pd->x,&pd->y);

			pderries = add_to_list(pderries,0,0,(void *)pd); 
			}; 

		get_whole_line(); 
		};
}

Object *
parse_arc_ellipse()
{
	Object *ob;
	Boolean farrow,barrow;
	char fooch=0;
	long x1,y1,x2,y2,x3,y3;
	double theta1,phi1,theta2,phi2,theta3,phi3; 

	ob = (Object *)malloc(sizeof(Object));

	ob->type = ARCELLIPSE;
	ob->ticket = ob_ticket++;
	ob->derries = NULL; 
	ob->ob.arcellipse.open = get_arc_open(); 
	ob->ls = get_line_style(); 
	ob->lw = get_int();
	ob->colour = get_fcolour();
	ob->fillcolour = get_fill_fcolour();
	ob->depth = get_depth();
	get_int(); /* pen_style, not used  */  
	ob->fs = get_fillstyle(ob); 
	get_double(); /* dash and dot, don't care  */  
	ob->es = get_capstyle(); 
	ob->js = JoinRound; /* irrelevant  */  
	get_int();  /* direction ...  */ 
	farrow = get_int(); 
	barrow = get_int();
	ob->ob.arcellipse.centre.x = (long)get_double(); 
	ob->ob.arcellipse.centre.y = (long)get_double(); 
	ob->ob.arcellipse.xradius = 1;
	ob->ob.arcellipse.yradius = 1; 
	/* now xfig format gives three points on the circle. the first and last are
		end points of the arc, the middle point is for specifying the sweep direction
		*/  
	x1 = get_int() - ob->ob.arcellipse.centre.x; y1 = get_int() - ob->ob.arcellipse.centre.y; 
	x2 = get_int() - ob->ob.arcellipse.centre.x; y2 = get_int() - ob->ob.arcellipse.centre.y; 
	x3 = get_int() - ob->ob.arcellipse.centre.x; y3 = get_int() - ob->ob.arcellipse.centre.y; 
 
 	/* determine the correct start and end angles  */  
	theta1 = atan2(((double)-y1),((double)x1)); 
	phi1 = atan(((double)-y1)/((double)x1)); 
	if (cosround(phi1)!=0)
		ob->ob.arcellipse.xradius = abs((long)(((double)x1)/cosround(phi1)));
	if (sinround(phi1)!=0)
		ob->ob.arcellipse.yradius = abs((long)(((double)-y1)/sinround(phi1)));
		 
	theta2 = atan2(((double)-y2),((double)x2)); 
	phi2 = atan(((double)-y2)/((double)x2)); 
	if (cosround(phi2)!=0)
		ob->ob.arcellipse.xradius = abs((long)(((double)x2)/cosround(phi2)));
	if (sinround(phi2)!=0)
		ob->ob.arcellipse.yradius = abs((long)(((double)-y2)/sinround(phi2)));
		 
	theta3 = atan2(((double)-y3),((double)x3)); 
	phi3 = atan(((double)-y3)/((double)x3)); 
	if (cosround(phi3)!=0)
		ob->ob.arcellipse.xradius = abs((long)(((double)x3)/cosround(phi3)));
	if (sinround(phi3)!=0)
		ob->ob.arcellipse.yradius = abs((long)(((double)-y3)/sinround(phi3)));

   while (theta1<0.0)
	   {
	   theta1+=2.0*PI;
		fooch=fooch | 1;
		};
		
   while (theta2<0.0)
	   {
	   theta2+=2.0*PI;
		};
		
   while (theta3<0.0)
	   {
	   theta3+=2.0*PI;
		fooch=fooch | 2; 
		};

   if (!between(theta2,min(theta1,theta3),max(theta1,theta3)))
	   {
		switch(fooch) 
			{
		   case(0):
			case(3): 
				if (min(theta1,theta3)==theta1)
					theta1 += 2.0*PI; 
				else
					theta3 += 2.0*PI;
				break;
			case(1): theta3+=2.0*PI; break;
			case(2): theta1+=2.0*PI; break;
			};
		}; 
		 
	ob->ob.arcellipse.start = (64.0*theta1*(180.0/PI)); 
	ob->ob.arcellipse.end = (64.0*theta3*(180.0/PI)); 

	(farrow) ? (ob->farrow = parse_arrow()) : (ob->farrow = NULL);
	(barrow) ? (ob->barrow = parse_arrow()) : (ob->barrow = NULL);
	
	ob->bbox.x1 = ob->ob.arcellipse.centre.x - ob->ob.arcellipse.xradius;
	ob->bbox.y1 = ob->ob.arcellipse.centre.y - ob->ob.arcellipse.yradius;
	ob->bbox.x2 = ob->ob.arcellipse.centre.x + ob->ob.arcellipse.xradius;
	ob->bbox.y2 = ob->ob.arcellipse.centre.y + ob->ob.arcellipse.yradius;
	ob->ob.arcellipse.centre.x -= ob->bbox.x1; 
	ob->ob.arcellipse.centre.y -= ob->bbox.y1; 
	 
	normalise_rectangle(&ob->bbox.x1, &ob->bbox.y1, &ob->bbox.x2, &ob->bbox.y2);
	ob->bbox.x2++;
	ob->bbox.y2++;

	obs = add_to_list_neq(obs,ULONG_MAX-ob->depth,0,(void *)ob); 
	 
	parse_vcomment(ob);
	 
	return ob; 
}

Object *
parse_compound(View *view)
{
	int i; 
	Object *ob;
	Object *mob; 
	List l=NULL,l2=NULL; 
	unsigned long de; 
	 
	ob = (Object *)malloc(sizeof(Object));

	ob->type = COMPOUND;
	ob->ticket = ob_ticket++;
	ob->derries = NULL; 
	ob->depth = ULONG_MAX; 
	ob->ob.compound.obs = NULL; 
	ob->farrow = NULL;
	ob->barrow = NULL;
	/* these are changed anyway, as they might be untrustworthy  */  
	ob->bbox.x1 = get_int(); 
	ob->bbox.y1 = get_int();
	ob->bbox.x2 = get_int(); 
	ob->bbox.y2 = get_int();
	normalise_rectangle(&ob->bbox.x1, &ob->bbox.y1, &ob->bbox.x2, &ob->bbox.y2);

	/* for each object, we parse it then immediately delete it
		from the document, to add to the compound. */  
	while ((i = get_int())!=-6)
		{ 
		switch (i)
			{
			case 0: /* means broken fig file */
				parse_colour_object();
				break;
			
			case 5:
				mob = parse_arc_ellipse();
				obs = delete_from_list_v(obs,(void *)mob); 
				ob->bbox = merge_boxes(mob->bbox,ob->bbox); 
				if (mob->depth<ob->depth)
					ob->depth = mob->depth-1;
				l = add_to_list_neq(l,ULONG_MAX-mob->depth,0,(void *)mob);  
				break;

			case 1:
				mob = parse_ellipse();
				ob->bbox = merge_boxes(mob->bbox,ob->bbox); 
				obs = delete_from_list_v(obs,(void *)mob); 
				if (mob->depth<ob->depth)
					ob->depth = mob->depth-1;
				l = add_to_list_neq(l,ULONG_MAX-mob->depth,0,(void *)mob);  
				break;

			case 2:
				mob = parse_polyline();
				ob->bbox = merge_boxes(mob->bbox,ob->bbox); 
				obs = delete_from_list_v(obs,(void *)mob); 
				if (mob->depth<ob->depth)
					ob->depth = mob->depth-1;
				l = add_to_list_neq(l,ULONG_MAX-mob->depth,0,(void *)mob);  
				break;
				
			case 3:
				mob = parse_spline();
				ob->bbox = merge_boxes(mob->bbox,ob->bbox); 
				obs = delete_from_list_v(obs,(void *)mob); 
				if (mob->depth<ob->depth)
					ob->depth = mob->depth-1;
				l = add_to_list_neq(l,ULONG_MAX-mob->depth,0,(void *)mob);  
				break;

			case 4:
				mob = parse_text(view);
				/* could cop out */
				if (!mob)
					break;
				ob->bbox = merge_boxes(mob->bbox,ob->bbox); 
				obs = delete_from_list_v(obs,(void *)mob); 
				if (mob->depth<ob->depth)
					ob->depth = mob->depth-1;
				l = add_to_list_neq(l,ULONG_MAX-mob->depth,0,(void *)mob);  
				break;
			
			case 6:
				mob = parse_compound(view);
				ob->bbox = merge_boxes(mob->bbox,ob->bbox); 
				obs = delete_from_list_v(obs,(void *)mob); 
				/* DON'T change depth for compounds-in-compounds (it's
				   meaningless). With all this we get sensible greenpig.fig
				   AND transit.fig :) */ 
				l = add_to_list_neq(l,ULONG_MAX-mob->depth,0,(void *)mob);  
				break;
			};
		};
 
 	/* recalculate the depths  */
 	de = ob_depth--;
	l2=l; 
	while (l2!=NULL)
		{
		OB(l2)->depth = de--;
		ob->ob.compound.obs = add_to_list(ob->ob.compound.obs,ULONG_MAX-OB(l2)->depth,0,(void *)OB(l2)); 
		l2=l2->next;
		}; 
	delete_list(l);
	 
	obs = add_to_list_neq(obs,ULONG_MAX-ob->depth,0,(void *)ob); 
 	return ob; 
}

Object *
parse_ellipse()
{
	Object *ob;

	ob = (Object *)malloc(sizeof(Object));

	ob->type = ELLIPSE;
	ob->ticket = ob_ticket++;
	ob->derries = NULL; 
	get_int(); /* don't care about subtype  */ 
	ob->ls = get_line_style();
	ob->lw = get_int();
	ob->colour = get_fcolour();
	ob->fillcolour = get_fill_fcolour();
	ob->depth = get_depth();
	get_int(); /* pen style, not used  */ 
	ob->fs = get_fillstyle(ob);
	get_double(); /* dash dot  */ 
	get_int(); /* direction always 1  */  
	get_double(); /* this is rotation angle which we can't handle  */  
	ob->farrow = NULL;
	ob->barrow = NULL;
	ob->ob.ellipse.centre.x = get_int(); 
	ob->ob.ellipse.centre.y = get_int(); 
	ob->ob.ellipse.xradius = get_int(); 
	ob->ob.ellipse.yradius = get_int(); 
	get_int(); get_int(); /* points entered  */ 
	get_int(); get_int(); 
	ob->bbox.x1 = ob->ob.ellipse.centre.x - ob->ob.ellipse.xradius; 
	ob->bbox.y1 = ob->ob.ellipse.centre.y - ob->ob.ellipse.yradius; 
	ob->bbox.x2 = ob->ob.ellipse.centre.x + ob->ob.ellipse.xradius; 
	ob->bbox.y2 = ob->ob.ellipse.centre.y + ob->ob.ellipse.yradius; 
	ob->ob.ellipse.centre.x -= ob->bbox.x1; 
	ob->ob.ellipse.centre.y -= ob->bbox.y1; 
   normalise_rectangle(&ob->bbox.x1, &ob->bbox.y1, &ob->bbox.x2, &ob->bbox.y2);

	obs = add_to_list_neq(obs,ULONG_MAX-ob->depth,0,(void *)ob); 
	
   parse_vcomment(ob);

	return ob;
}

Object *
parse_polyline()
{
	Object *ob;
	int subtype; 
	Boolean farrow,barrow; 
	int num; 
	int radius; 
	char *s; 
	uint c=0; 
	List l=NULL; 

	ob = (Object *)malloc(sizeof(Object));

	subtype = get_int();

	ob->ticket = ob_ticket++;
	ob->derries = NULL; 
	ob->ls = get_line_style();
	ob->lw = get_int();
	ob->colour = get_fcolour();
	ob->fillcolour = get_fill_fcolour();
	ob->depth = get_depth();
	get_int(); /* pen_style  */ 
	ob->fs = get_fillstyle(ob);
	get_double(); /* dash dot  */ 
	ob->js = get_joinstyle(); 
	ob->es = get_capstyle();
	radius = get_int();
	farrow = get_int();
	barrow = get_int(); 
	num = get_int(); 
	
	(farrow) ? (ob->farrow = parse_arrow()) : (ob->farrow = NULL);
	(barrow) ? (ob->barrow = parse_arrow()) : (ob->barrow = NULL);
		 
	/* use this temporarily for use in recalc_polyline_bbox  */ 
	ob->ob.polyline.points=NULL;
	/* need initial bbox */ 
	ob->bbox.x1 = 0;
	ob->bbox.y1 = 0;
	ob->bbox.x2 = 10;
	ob->bbox.y2 = 10;
	 
	if (subtype==5)
		{
		get_int(); 
		s = (char *)malloc(strlen(cp)+1); 
		strcpy(s,cp); 
		ob->ob.polyline.pic = s;
		get_whole_line(); 
		}
	else
		ob->ob.polyline.pic = NULL;

	while (num>0)
		{
		ob->ob.polyline.points = add_to_list(ob->ob.polyline.points,c,0,(void *)parse_point(ob));
		c++; 
		num--;
		};
	
	recalc_polyline_bbox(ob,FALSE);

	switch (subtype)
		{
		case 1: /* polyline  */ 
			if (ob->fs!=NONE) 
				ob->type = POLYGON; 
			else 
				ob->type = POLYLINE;
			break;

		case 5: /* imported pic bbox  */  
			ob->type = POLYGON;
			break;

		case 2: /* rectangle  */ 
		case 3: /* polygon */  
			ob->type = POLYGON;
			/* remove last point coincident with first */  
			l = ob->ob.polyline.points;
			while (l->next!=NULL)
				l = l->next;
			if (l->prev!=NULL)
				l->prev->next = NULL;
			free(POINT(l));
			free(l);
			break;

		case 4: /* roundbox  */ 
			ob->type = ROUNDBOX;
			/* remove list, not used  */ 
			l = ob->ob.polyline.points;
			while (l!=NULL)
				{
				free (POINT(l));
				l = l->next;
				};
			delete_list(ob->ob.polyline.points);
			/* now use it as roundbox  */ 
			ob->ob.roundbox.radius = radius;
			break;
		}; 
	
	obs = add_to_list_neq(obs,ULONG_MAX-ob->depth,0,(void *)ob); 
	
	parse_vcomment(ob);
		 
	return ob;
}

Object *
parse_spline()
{
	Object *ob;
	Boolean farrow,barrow; 
	int subtype; 
	int num; 
	uint c=0; 
	List l=NULL; 

	ob = (Object *)malloc(sizeof(Object));

	ob->type = SPLINE;
	ob->ticket = ob_ticket++;
	ob->derries = NULL; 
	subtype = get_int();
	switch(subtype)
		{
		case 1:
		case 3:
		case 5: 
			ob->ob.spline.closed = TRUE;
			break;

		default:
			ob->ob.spline.closed = FALSE;
		};
		
	ob->ls = get_line_style();
	ob->lw = get_int();
	ob->colour = get_fcolour();
	ob->fillcolour = get_fill_fcolour();
	ob->depth = get_depth();
	get_int(); /* pen_style  */ 
	ob->fs = get_fillstyle(ob);
	get_double(); /* dash dot  */ 
	ob->js = JoinRound;
	ob->es = get_capstyle();
	farrow = get_int();
	barrow = get_int(); 
	num = get_int(); 
	
	(farrow) ? (ob->farrow = parse_arrow()) : (ob->farrow = NULL);
	(barrow) ? (ob->barrow = parse_arrow()) : (ob->barrow = NULL);
		 
	/* need initial bbox */ 
	ob->bbox.x1 = 0;
	ob->bbox.y1 = 0;
	ob->bbox.x2 = 10;
	ob->bbox.y2 = 10;
	ob->ob.spline.cache = NULL; 
	ob->ob.spline.points = NULL; 
	 
	while (num>0)
		{
		ob->ob.spline.points = add_to_list(ob->ob.spline.points,c,0,(void *)parse_spoint(ob));
		c++; 
		num--;
		};
	
	l = ob->ob.spline.points; 
	 
	/* get our shape factors  */   
	while (l!=NULL)
		{
		SPOINT(l)->s = get_double();
		l = l->next;
		};


	/* fill the cache  */  
	ob->ob.spline.cache = compute_spline_segment(ob->ob.spline.points,ob->ob.spline.closed);
	recalc_polyline_bbox(ob,TRUE);
	 
	obs = add_to_list_neq(obs,ULONG_MAX-ob->depth,0,(void *)ob); 
	 
	parse_vcomment(ob);
	return ob;
}

Object *
parse_text(View *view)
{
	Object *ob;
	TextLine *tl; 
	TextSection *ts=NULL; 
	int fontnum; 
	int fontsize; 
	int charpos = 0; 
	long w,h; 
	long x,y; 
	uint is=0;
	Boolean more=TRUE; 
	VFont *vf; 
	char str[MLINE]; 

	ob = (Object *)malloc(sizeof(Object)); 
	ob->type = TEXT;
	ob->ticket = ob_ticket++;
	ob->derries = NULL; 
	
	ob->ob.text.node = FALSE;
	ob->ob.text.ellipse = FALSE;

	ob->farrow = NULL;
	ob->barrow = NULL;
	ob->ob.text.lines = NULL;
	tl = (TextLine *)malloc(sizeof(TextLine));
	tl->y = 0;
	tl->h = 0;
	tl->sections = NULL;
	ob->ob.text.lines = add_to_list(ob->ob.text.lines,0,0,(void *)tl); 

	switch (get_int())
		{
		case 1: tl->just = CENTRE; break;
		case 2: tl->just = RIGHT; break;
		default: tl->just = LEFT; break;
		};

	ob->colour = get_fcolour();
	ob->depth = get_depth();
	ob->ls = 0;
	ob->fs = 0;
	ob->es = CapButt;
	ob->lw = 0; 
	ob->js = JoinRound; 
	get_int(); /* pen_style  */
	fontnum = get_int();
	if (fontnum==-1) /* default ps */ 
		fontnum++;
	fontsize = (int)get_double();
	ob->ob.text.angle = get_double();
	ob->ob.text.angle = flip_angle_y(ob->ob.text.angle); 
	if (!(4 & get_int())) /* latex font  */ 
		{
		if (fontnum==0) /* default latex  */ 
			fontnum = 35;
		else
			fontnum += 34; 
		}; 

	h = (long)get_double();
	w = (long)get_double();
	x = get_int();
	y = get_int();

	ob->ob.text.bbox.x1 = x; 
	ob->ob.text.bbox.y1 = y;
	
	/* pick out characters delimited by \001  */  
	while (more) 
		{
		if (*cp=='\0')
			{
			fgets(str,MLINE,fl); 
			cp = &str[0]; 
			};
			
		if (*cp=='\n')
			{ 
			fgets(str,MLINE,fl); 
			cp = &str[0]; 
			}; 

		if (ts==NULL || strlen(ts->text)==18) 
			{
			TextSection *tsp;

			tsp = (TextSection *)malloc(sizeof(TextSection));
			tsp->x = 0;
			tsp->w = 10;
			tsp->isReturn = FALSE;
			tsp->num = fontnum;
			tsp->size = fontsize;

			charpos = 0; 
			tl->sections = add_to_list(tl->sections,is,0,(void *)tsp);
			is++; 
			ts = tsp; 
			}; 
	 
	 	if (*cp != '\\') 
			{ 
			ts->text[charpos] = *cp;
			ts->text[++charpos]='\0'; 
			}
		else
			{
			cp++;
			
			if (*cp!='\\') /* ie octal code  */ 
				{
				char a[10];
				int i;

				a[0] = *cp;
				cp++; 
				a[1] = *cp;
				cp++; 
				a[2] = *cp;
				a[3] = '\0';

				if (streq("001",a)) /* finish */ 
					more = FALSE;
				else			 
					{ 
					sscanf(a,"%o", &i);
				
					ts->text[charpos] = (unsigned char)i;
					ts->text[++charpos] = '\0';
					}; 
				}
			else /* escaped backslash */ 
				{
				ts->text[charpos] = '\\';
				ts->text[++charpos]='\0';
				};
			};
		 
		cp++;
		};

	ts->text[charpos] = '\0';

	/* calculate the text box  */  
	recalc_text_box(view,ob, FALSE, TRUE); 
	
	/* we need to subtract the .ascent  */ 
	/* if the text if rotated, the .ascent subtraction
		needs to be as well */
	vf = get_font(fontnum,ZPO(fontsize,view)); 
	if (vf==NULL)
		{
		List l,l2;

		l = ob->ob.text.lines;
		while (l!=NULL)
			{
			l2 = TEXTLINE(l)->sections;
			while (l2!=NULL)
				{
				free(TEXTSEC(l2)); 
				l2=l2->next;
				};
			delete_list(TEXTLINE(l)->sections); 
			free(TEXTLINE(l)); 
			l=l->next;
			};
		delete_list(ob->ob.text.lines);
		free(ob);
		return NULL; 
		};

	if (ob->ob.text.angle)
		{
		double sina,cosa;
		long cx,cy;
		long ox,oy; 

		sina=sinround(ob->ob.text.angle); 
		cosa=cosround(ob->ob.text.angle); 
		cx = (ob->ob.text.bbox.x2-ob->ob.text.bbox.x1)/2;
		cy = (ob->ob.text.bbox.y2-ob->ob.text.bbox.y1)/2;

		if (tl->just==CENTRE)
			ox = (ob->ob.text.bbox.x2-ob->ob.text.bbox.x1)/2;
		else if (tl->just==RIGHT) 
			ox = ob->ob.text.bbox.x2-ob->ob.text.bbox.x1;
		else
			ox = 0;
			 
		oy = P2D(vf->x->max_bounds.ascent,view); 
		 
 		ob->ob.text.bbox.x1 -= cx + cosa*(ox-cx)-sina*(oy-cy);
		ob->ob.text.bbox.y1 -= cy + sina*(ox-cx)+cosa*(oy-cy);
		
		}
	else
		{
		if (tl->just==CENTRE)
			{
			long dx;
			dx = (ob->ob.text.bbox.x2-ob->ob.text.bbox.x1)/2; 
			ob->ob.text.bbox.x1 -= dx; 
			ob->ob.text.bbox.x2 -= dx; 
			}
		else if (tl->just==RIGHT)
			{
			long dx;
			dx = ob->ob.text.bbox.x2-ob->ob.text.bbox.x1;
			ob->ob.text.bbox.x1 -= dx; 
			ob->ob.text.bbox.x2 -= dx; 
			};
	
		ob->ob.text.bbox.y1 -= P2D(vf->x->max_bounds.ascent,view);  
		};
		 
	recalc_text_box(view,ob, FALSE, TRUE); 
	 
	obs = add_to_list_neq(obs,ULONG_MAX-ob->depth,0,(void *)ob); 
	return ob; 
}

void 
load(char *file,Boolean cmdline)
{
	char s[FIGURINE_PATH_MAX]; 
	int c=strlen(file); 
	 
	Document *d; 
	d = new_doc(FALSE);

	strcpy(s,file);
	while (strlen(s) && s[strlen(s)-1]!='/')
		{ 
		s[strlen(s)-1] = '\0';
		c--;
		};

	if (streq("",s))
		strcpy(d->pathname,state.cwd);
	else
		strcpy(d->pathname,s);
		 
	strcpy(d->filename,file+c);
	new_view0(d); 
	 
	insert_file(d,file,TRUE,cmdline);
}

void insert_file(Document *d, char *file,Boolean isload,Boolean cmdline)
{
	static char s[MLINE];
	char *c; 
	List l,l2,l3;
	unsigned long de;
	Derry *der; 
	
	fl = fopen(file,"r");

	doc = d; 
	 
	c = &file[strlen(file)];
	while (*(c-1)!='/' && c>file)
		c--;
	
	if (isload)
		{
		strcpy(doc->filename,c);
		if (c==file)
			strcpy(doc->pathname,state.cwd);
		else 
			{ 
			strncpy(doc->pathname,file,(uint)(c-file));
			doc->pathname[c-file] = '\0';
			}; 
		}; 
		 
	if (fl==NULL)
		{
		if (cmdline)
			{
			/* specifically requested on cmdline, open new document  */  
			XMapWindow(display,VIEW(doc->views)->window.win);
			switch_icons(VIEW(doc->views));
			return;
			};
		strcpy(s,"File ");
		strncat(s,file,MLINE);
		strcat(s," could not be read.");
		stk_open_info(s);
		if (isload) 
			{ 
			really_close_view(VIEW(doc->views)); 
			docs = delete_from_list_v(docs,(void *)doc);
			free(doc); 
			}; 
		return;
		};
		 
	/* first line should be #FIG 3.2  */ 
	fgets(s,MLINE,fl);
	s[8] = '\0'; 
	if (!streq(s,"#FIG 3.2"))
		{
		strcpy(s,"File ");
		strncat(s,file,MLINE);
		strcat(s," is not a FIG 3.2 file");
		stk_open_info(s);
		if (isload) 
			{ 
			really_close_view(VIEW(doc->views)); 
			docs = delete_from_list_v(docs,(void *)doc);
			free(doc); 
			}; 
		fclose(fl);
		return;
  		}; 
	 
	get_whole_line(); 
	if (isload)
		{
		string_eq("Landscape") ? (doc->landscape=TRUE) : (doc->landscape=FALSE);
		string_eq("Center") ? (doc->centred=TRUE) : (doc->centred=FALSE);
		string_eq("Metric") ? (in_mm=TRUE) : (in_mm=FALSE);
		parse_papersize();
		} 
	else
		{
		get_whole_line();
		get_whole_line();
		get_whole_line();
		};

	get_whole_line(); 
	if (isload) 
		doc->magnify = get_double();
	else
		get_double();
	get_whole_line(); 
	if (isload) 
		{ 
		string_eq("Multiple") ? (doc->mpage=TRUE) : (doc->mpage=FALSE);
		doc->transcolour = get_int();
		doc->ppi = get_int();
		} 
	else
		{ 
		get_whole_line(); 
		get_int();
		get_int();
		}; 
		
	get_int(); /* second val on line is ignored here */  
	
	obs = NULL;
	 
	/* objects now */ 
	 
	while (!feof(fl))  
		{ 
		switch (get_int())
			{
			case 0: parse_colour_object(); break;
			case 5: parse_arc_ellipse(); break;
			case 1: parse_ellipse(); break;
			case 2: parse_polyline(); break;
			case 3: parse_spline(); break;
			case 4: parse_text(VIEW(doc->views)); break;
			case 6: parse_compound(VIEW(doc->views)); break;
			default: break;
			};
		};

	de = ULONG_MAX;
	l = obs;
	while (l!=NULL)
		{
		OB(l)->depth = de--;
		doc->o = add_object(doc->o, &doc->lo, OB(l));
		l=l->next;
		};

	doc->ob_depth = de;
	 
	if (isload) 
		{ 
		/* open the view window of loaded file  */  
		XMapWindow(display,VIEW(doc->views)->window.win);
		switch_icons(VIEW(doc->views));
		}; 
	delete_list(obs);
	doc = NULL; 
	fclose(fl); 
	
	/* now run through the derries list and match them up  */  
	
	l=pderries;

	while (l!=NULL)
		{
		l2=underried;
		while (l2!=NULL)
			{
			if (streq(PDERRY(l)->tag,PDERRY(l2)->tag) && 
			    PDERRY(l)->x == PDERRY(l2)->x &&
				 PDERRY(l)->y == PDERRY(l2)->y)
				{
				/* match: PDERRY(l)->ob is host, PDERRY(l2)->ob is source  */  
				der = (Derry *)malloc(sizeof(Derry));
				der->ticket = PDERRY(l2)->ob->ticket;

				if (PDERRY(l2)->ob->type==SPLINE || PDERRY(l2)->ob->type==ARC)
					l3 = PDERRY(l2)->ob->ob.spline.points;
				else
					l3 = PDERRY(l2)->ob->ob.polyline.points;

				while (l3!=NULL)
					{
					if (POINT(l3)->x+PDERRY(l2)->ob->bbox.x1==PDERRY(l)->x && 
						 POINT(l3)->y+PDERRY(l2)->ob->bbox.y1==PDERRY(l)->y)
						{
						/* found the matching point */  
						POINT(l3)->derried=TRUE; 
						der->point = POINT(l3); 
						break; 
						};
					l3=l3->next;
					};
				
				PDERRY(l)->ob->derries = add_to_list(PDERRY(l)->ob->derries,der->ticket,0,(void *)der);
				break; 
				};
				 
			l2=l2->next;
			};
		l=l->next;
		};

	l=pderries;
	while (l!=NULL)
		{
		free(l->data); 
		l=l->next; 
		};
		 
	l=underried;
	while (l!=NULL)
		{
		free(l->data); 
		l=l->next; 
		};
		 
	delete_list(pderries);
	delete_list(underried); 
	pderries=NULL;
	underried=NULL;
}
