/* mouse_motion.c  */ 
/* COPYRIGHT (C) 2000 THE VICTORIA UNIVERSITY OF MANCHESTER and John Levon
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details. 
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA. 
 */
/* For button motion */ 
/*
 * $Log: mouse_motion.c,v $
 * Revision 1.2  2000/12/06 20:56:03  moz
 * GPL stuff.
 *
 * Revision 1.1.1.1  2000/08/21 01:05:31  moz
 *
 *
 * Revision 1.1.1.1  2000/07/19 22:45:30  moz
 * CVS Import
 *
 * Revision 1.11  2000/03/08 01:13:22  moz
 * Compile fixes.
 *
 * Revision 1.10  2000/01/21 11:22:31  moz
 * last_mouse_movement isn't used.
 *
 * Revision 1.9  2000/01/21 11:02:21  moz
 * Actually we only need to SET_CLIP_WINDOW()
 * when busy drawing (or guidelines are on)
 *
 * Revision 1.8  2000/01/18 18:53:12  moz
 * Added comment about unfortunately necessary SET_CLIP_WINDOW().
 *
 * Revision 1.7  1999/11/15 02:07:30  moz
 * Name change.
 *
 * Revision 1.6  1999/05/22 02:54:24  moz
 * Don't jump when rotating regular polygon.
 *
 * Revision 1.5  1999/05/19 17:08:48  moz
 * 1.0 Checkin.
 *
 * Revision 1.4  1999/05/03 04:09:37  moz
 * Only redraw the guidelines when we've not done redraw_view_window.
 *
 * Revision 1.3  1999/04/27 19:50:57  moz
 * Use draw_window->w instead of WS(l)->w for move boundary of window.
 *
 * Revision 1.2  1999/04/23 00:39:56  moz
 * redraw_view_window change.
 *
 * Revision 1.1  1999/03/30 00:05:32  moz
 * Initial revision
 *
 */    

#include "include/figurine.h"
#include "include/extern.h"

int last_x=0, last_y=0;
static long x=0,y=0; 

void 
handle_motion(XEvent *report)
{
	List l,l2;
	Boolean keychange;
	int test=-1,test2=-1; /* func returns -1 if no change */
	 
	last_x = mouse_x;
	last_y = mouse_y;
	mouse_x = report->xmotion.x;
	mouse_y = report->xmotion.y;

	l = where_in_list(wins,report->xmotion.window);

	switch (l->type)
		{
		case DRAW_WIN:
			l2 = where_in_list(wins,WS(l)->parent);
			 
			/* if there's some kind of key change then we
				probably need to redraw any rubber-banding */   
			keychange =  (((report->xmotion.state & ShiftMask) && !state.shift_down)
							  || (!(report->xmotion.state & ShiftMask) && state.shift_down)
							  || ((report->xmotion.state & ControlMask) && !state.control_down)
							  || (!(report->xmotion.state & ControlMask) && state.control_down));
			
			if (keychange && state.busy_drawing && state.rubberon)
				toggle(VIEW(l2),last_x, last_y);
			 
			if (keychange && state.editing_point && (VIEW(l2)->edited_object->ob->type==SPLINE
				 || VIEW(l2)->edited_object->ob->type==ARC)) 
				toggle_point_spline(VIEW(l2),last_x, last_y);

			state.shift_down=(report->xmotion.state & ShiftMask);
			state.control_down=(report->xmotion.state & ControlMask);
			
			if (keychange && state.busy_drawing && state.rubberon)
				toggle(VIEW(l2),last_x, last_y);
			 
			if (keychange && state.editing_point && (VIEW(l2)->edited_object->ob->type==SPLINE
				 || VIEW(l2)->edited_object->ob->type==ARC)) 
				toggle_point_spline(VIEW(l2),last_x, last_y);

			if (state.busy_drawing)
				{
				if (state.busy_drawing && state.rubberon)
					toggle(VIEW(l2),last_x, last_y);
			 
			 	/* attempt to derry  */  
				if (state.shift_down && (state.current_icon==POLYLINEICON ||
					 (state.current_icon==POLYGONICON && !VIEW(l2)->regular) || state.current_icon==SPLINEICON ||
					 state.current_icon==ARCICON))
					{
					Object *rob=NULL; 
					if (get_nearest_point(VIEW(l2),VIEW(l2)->doc->o, XP2D(mouse_x,VIEW(l2)),YP2D(mouse_y,VIEW(l2)),&x,&y,&rob))
						{
						mouse_x = XD2P(x,VIEW(l2));
						mouse_y = YD2P(y,VIEW(l2));
						XWarpPointer(display, None, VIEW(l2)->draw_window->win, 0, 0, 1, 1, 
										 mouse_x,mouse_y);
						};
					};

				/* if by border, scroll view window  */  
				if (report->xmotion.x < MOVE_BOUNDARY) /* move left */  
					test = nudge_ruler_x(VIEW(l2)->ruler_x_window, VIEW(l2), LEFT);
				else if (report->xmotion.x >= ((int)VIEW(l2)->draw_window->w)-MOVE_BOUNDARY) /* move right */ 
					test = nudge_ruler_x(VIEW(l2)->ruler_x_window, VIEW(l2), RIGHT);
				
				if (report->xmotion.y < MOVE_BOUNDARY) /* move up */  
					test2 = nudge_ruler_y(VIEW(l2)->ruler_y_window, VIEW(l2), UP); 
				else if (report->xmotion.y >= ((int)VIEW(l2)->draw_window->h)-MOVE_BOUNDARY) /* move down */ 
					test2 = nudge_ruler_y(VIEW(l2)->ruler_y_window, VIEW(l2), DOWN); 
				
				if (test==-1 && test2==-1) /* i.e. not scrolled  */ 
 					toggle(VIEW(l2), mouse_x, mouse_y); 
				else
					redraw_view_window(VIEW(l2)); 
				}; 

			/* we unconditionally reclip whilst drawing, guidelines or not */  
			/* wasteful but we get droppings otherwise */  
			if (VIEW(l2)->guide_lines || state.busy_drawing) 
				SET_CLIP_WINDOW(blackxorgc,&VIEW(l2)->window);
			 
			/* rub out old guidelines, replace with new  */  
			if (VIEW(l2)->guide_lines && test==-1 && test2==-1)
				{
				if (VIEW(l2)->guide_lines_displayed)
					{
					XDrawLine(display,VIEW(l2)->draw_window->win, 
						blackxorgc, last_x, 0, last_x, last_y - GUIDE_LINE_GAP);
					XDrawLine(display,VIEW(l2)->draw_window->win, 
						blackxorgc, 0, last_y, last_x - GUIDE_LINE_GAP, last_y);
					XDrawLine(display,VIEW(l2)->draw_window->win, 
						blackxorgc, last_x + GUIDE_LINE_GAP, last_y, 
						((int)VIEW(l2)->draw_window->w)-1, last_y);
					XDrawLine(display,VIEW(l2)->draw_window->win, blackxorgc, 
						last_x, last_y + GUIDE_LINE_GAP, 
						(int)last_x, ((int)VIEW(l2)->draw_window->h)-1);       
					}; 

				VIEW(l2)->guide_lines_displayed = TRUE;
				toggle_guidelines(VIEW(l2));
				};

			/* could be editing an object  */  
			if (state.current_icon == POINTERICON)
				edit_motion(VIEW(l2),mouse_x, mouse_y);

			break; 
							 
		case RULER_X_WIN:
			/* scroll ruler around  */ 
			if (((WindowStruct *)l->data)->grabbed)
				{
						 
				l2 = where_in_list(wins, ((WindowStruct *)l->data)->parent);
								 
				if (last_mouse_x < mouse_x)
					{
					/* move ruler to right  */
					if (nudge_ruler_x(WS(l),VIEW(l2),RIGHT)!=-1)
						redraw_view_window(VIEW(l2)); 
					}
				else if (last_mouse_x > mouse_x)
					{
					/* move ruler to left */
					if (nudge_ruler_x(WS(l),VIEW(l2),LEFT)!=-1)	
						redraw_view_window(VIEW(l2)); 
					};
				};
			
			break;
		 
		case RULER_Y_WIN:
			/* scroll ruler around  */ 
			if (((WindowStruct *)l->data)->grabbed)
				{
				l2 = where_in_list(wins, ((WindowStruct *)l->data)->parent);
					 
				if (last_mouse_y < mouse_y)
					{
					/* move ruler down  */
					if (nudge_ruler_y(WS(l),VIEW(l2),DOWN)!=-1) 
						redraw_view_window(VIEW(l2)); 
					}
				else if (last_mouse_y > mouse_y)
					{
					/* move ruler up */
					if (nudge_ruler_y(WS(l),VIEW(l2),UP)!=-1) 
						redraw_view_window(VIEW(l2)); 
					};
				};
			break;
		};

		last_mouse_x = mouse_x;
		last_mouse_y = mouse_y;
}
