/* new_doc.c  */ 
/* COPYRIGHT (C) 2000 THE VICTORIA UNIVERSITY OF MANCHESTER and John Levon
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details. 
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA. 
 */
/* for creating a new document  */  
/*
 * $Log: new_doc.c,v $
 * Revision 1.3  2000/12/17 00:57:42  moz
 * examples, filled open splines, highlight_objects
 *
 * Revision 1.2  2000/12/06 20:56:03  moz
 * GPL stuff.
 *
 * Revision 1.1.1.1  2000/08/21 01:05:31  moz
 *
 *
 * Revision 1.1.1.1  2000/07/19 22:45:30  moz
 * CVS Import
 *
 * Revision 1.16  2000/03/07 21:46:18  moz
 * Compile fixes.
 *
 * Revision 1.15  2000/02/22 22:28:10  moz
 * Must use transparency value of -2 to stop fig2dev 3.2.3 crashing
 *
 * Revision 1.14  2000/02/18 01:17:01  moz
 * Unselect stuff on really_close_view().
 *
 * Revision 1.13  2000/02/04 01:54:36  moz
 * switch_icons() needs view
 *
 * Revision 1.12  2000/01/30 17:20:57  moz
 * Use check_dial to track close messages.
 * Remove unused View members.
 *
 * Revision 1.11  2000/01/25 01:36:16  moz
 * Removed border.
 *
 * Revision 1.10  2000/01/21 11:50:14  moz
 * Use rulergc instead of blackgc for relevant windows.
 *
 * Revision 1.9  1999/11/15 02:06:56  moz
 * Name change.
 *
 * Revision 1.8  1999/05/22 23:39:23  moz
 *  Pedantic ANSI.
 *
 * Revision 1.7  1999/05/22 02:53:37  moz
 * Allow -nocompoundoutlines and -guidelines.
 *
 * Revision 1.6  1999/05/19 17:08:44  moz
 * 1.0 Checkin.
 *
 * Revision 1.5  1999/04/29 00:26:07  moz
 * Removed nodebox icon.
 *
 * Revision 1.4  1999/04/28 00:37:15  moz
 * Don't draw desert.
 *
 * Revision 1.3  1999/04/24 22:23:59  moz
 * Start with empty list of user-defined colours.
 * Delete them when done.
 *
 * Revision 1.2  1999/04/12 19:05:16  moz
 * Change of default settings.
 *
 * Revision 1.1  1999/03/30 00:05:35  moz
 * Initial revision
 *
 */    

#include <stdlib.h>

#include "include/figurine.h"
#include "include/extern.h"
#include "include/stk.h"

static int val=1; 

void unselect_polygon(void);

Boolean 
close_view(View *v)
{
	/* if this is the last view, enter close-doc mode  */  
	if (v->doc->views->next==NULL)
		return close_doc(v->doc,v); /* TRUE  */ 
	else
		really_close_view(v);
		 
	return FALSE;
}

void 
really_close_view(View *v)
{

	/* get rid of everything  */  
 	if (v->text_object!=NULL)
		unselect_text(v);

	if (state.compound_selected)
		unselect_compound(v);

	if (state.current_icon==ARCICON)
		unselect_arc(v);

	if (state.current_icon==POLYGONICON)
		unselect_polygon();
		 
	/* hide while destroying for niceness  */
	XUnmapWindow(display,v->window.win); 
	stk_delete_icon(EYEICON,v->window.win); 
	stk_delete_icon(ARROWICON,v->view_icon_window->win );
	stk_delete_icon(SETPOLYGONICON,v->view_icon_window->win );
	stk_delete_icon(ENDSTYLEICON,v->view_icon_window->win );
	stk_delete_icon(JOINSTYLEICON,v->view_icon_window->win );
	stk_delete_icon(FONTICON,v->view_icon_window->win );
	stk_delete_icon(LINEWIDTHICON,v->view_icon_window->win );
	stk_delete_icon(SETSPLINEICON,v->view_icon_window->win );
	stk_delete_icon(ROUNDBOXICON,v->view_icon_window->win );
	stk_delete_icon(JUSTIFICATIONICON,v->view_icon_window->win );
	stk_delete_icon(GRIDICON,v->view_icon_window->win );
	stk_delete_icon(SHOWGRIDICON,v->view_icon_window->win );
	stk_delete_icon(ZOOMINICON,v->view_icon_window->win );
	stk_delete_icon(ZOOMOUTICON,v->view_icon_window->win );
	stk_delete_icon(LINESTYLEICON, v->view_icon_window->win);
	stk_delete_icon(FILLSTYLEICON, v->view_icon_window->win);
	stk_delete_icon(COLOURICON, v->view_icon_window->win);
	stk_delete_icon(FILLCOLOURICON, v->view_icon_window->win);
	stk_delete_icon(SETARCELLIPSEICON, v->view_icon_window->win); 
  
	wins = delete_from_list(wins, (ulong)v->ruler_x_window->win);
	XDestroyWindow(display,v->ruler_x_window->win); 
	free_list(v->ruler_x_window);
	wins = delete_from_list(wins, (ulong)v->ruler_y_window->win);
	XDestroyWindow(display,v->ruler_y_window->win); 
	free_list(v->ruler_y_window);
	wins = delete_from_list(wins, (ulong)v->draw_window->win);
	XDestroyWindow(display,v->draw_window->win); 
	free_list(v->draw_window);
	wins = delete_from_list(wins, (ulong)v->view_icon_window->win);
	XDestroyWindow(display,v->view_icon_window->win); 
	free_list(v->view_icon_window);
	wins = delete_from_list(wins, (ulong)v->window.win);
	XDestroyWindow(display,v->window.win); 
	 
	v->doc->views = delete_from_list_v(v->doc->views,v);

	state.views = delete_from_list_v(state.views,v);

	free_list(v); 
}

Boolean 
close_doc(Document *doc, View *view)
{
	static char a[400];

	if (doc->check_dial)
		return TRUE;

	/* check whether user wants to save  */  
	sprintf(a,"Save %s ?",doc->filename);
	stk_open_message(a, "Save", "Close unsaved", "Cancel", 
		  &doc->check_dial, &doc->check_save, &doc->check_close, &doc->check_cancel, (void *)view);
	return TRUE;
}

Boolean 
really_close_doc(Document *doc)
{
	List l;
	Object *ob; 

	/* user didn't save, so really close the document */  
	
	l = doc->views;

	while (l!=NULL)
		{
		really_close_view(VIEW(l));
		l = doc->views;
		};
		
	l = doc->lo;

	while (l!=NULL)
		{
		ob = OB(l); 
		doc->o = trash_object(doc->o, &doc->lo, ob);
		kill_object(ob);
		l = doc->lo;
		};
	
	delete_list(doc->views);

 	docs = delete_from_list_v(docs,doc);
	 
	l = doc->cols;
	while (l!=NULL)
		{
		XFreeColors(display,DefaultColormap(display,screen),&UCOLOUR(l)->colour,1,0);
		free (UCOLOUR(l));
		l = l->next;
		};
	
	delete_list(doc->cols);

	free_list(doc);  
	return FALSE; /* no doc now  */ 
}

/* create a new document  */  
Document *
new_doc(Boolean brandspanking)
{
	Document *dp; 
	 
	dp = (Document *)malloc(sizeof(Document));
	if (dp==NULL)
		return NULL;

	dp->ppi = 1200;  /* standard Xfig file res  */ 
	strcpy(dp->canvas_name,sizes[0].name);
	dp->width_in_inches = sizes[0].w;
	dp->height_in_inches = sizes[0].h;
	
	dp->landscape = FALSE;
	dp->centred = TRUE;
	dp->in_mm = FALSE; 
	dp->magnify = 100.0;
	dp->mpage = TRUE;
	/* we'd like to set -1 (background) but this crashes fig2dev 3.2.3 :( */  
	dp->transcolour = -2; 
	dp->views = NULL; 
	dp->o = NULL;
	dp->lo = NULL; 
	dp->cols = NULL; 
	dp->ob_depth = ULONG_MAX; 
	dp->check_dial = 0; 
	dp->check_save = 0; 
	dp->check_close = 0; 
	dp->check_cancel = 0; 
	if (brandspanking) 
		sprintf(dp->filename,"newfile%d.fig",val++); 
	else
		sprintf(dp->filename,"dummy.fig"); 
	strcpy(dp->pathname,state.cwd); 
	 
	docs = add_to_list(docs,(ulong)val,0,(void *)dp);  
	 
	return dp;
}

/* create a new view onto an existing document  */  
Window 
new_view0(Document *dp)
{
	View *vp; 
	WindowStruct *winp,*win2p,*dwinp,*iwinp; 
	char a[850]; 
	 
	if (dp==NULL)
		return 0;

	vp = (View *)malloc(sizeof(View));

	if (vp==NULL)
		return 0;

	/* fill out defaults  */  
	vp->zoom_factor = 1.0;
	vp->zoom_level = 10;
	vp->x_inches_offset = 0; 
	vp->y_inches_offset = 0; 
	vp->doc = dp;
	vp->window.x = 0;
	vp->window.y = 0;
	vp->window.w = (7*DisplayWidth(display,screen))/10;
	vp->window.h = (7*DisplayHeight(display,screen))/10;
	vp->window.cursor_num = XC_tcross; 
	vp->in_mm = FALSE;
	vp->guide_lines = guide_lines;
	vp->guide_lines_displayed = FALSE; 
	vp->guide_x = 0;
	vp->guide_y = 0;
	vp->colour = CBLACK;
	vp->fillcolour = FILLCWHITE;
	vp->linestyle = SOLID; 
	vp->linewidth = 1; 
	vp->endstyle = CapRound;
	vp->joinstyle = JoinRound;
	vp->fillon = TRUE; 
	vp->fillstyle = NONE;
	vp->window.gc = handlegc;
	vp->window.class_hints = NULL;
	vp->window.wm_hints = NULL;
	vp->window.size_hints = NULL;
	vp->highlighted_object = NULL;
	vp->selected_object = NULL;
	vp->edited_object = NULL; 
	vp->show_compounds = compound_outlines;
	vp->highlight_objects = highlight_objects;
	vp->justification = LEFT; 
	vp->farrow_on = FALSE;
	vp->barrow_on = FALSE;
	vp->barrow.type = ARROWSTICK;
	vp->barrow.filled = FALSE;
	vp->barrow.lw = 1;
	vp->barrow.w = 4;
	vp->barrow.h = 8;
	vp->farrow.type = ARROWSTICK;
	vp->farrow.filled = FALSE;
	vp->farrow.lw = 1;
	vp->farrow.w = 4;
	vp->farrow.h = 8;
	
	vp->sides = 5; 
	vp->side_angle = (PI*2.0)/vp->sides; /* radians !  */ 
	vp->regular = TRUE; 
	vp->gridon = FALSE;
	vp->showgrid = FALSE;
	vp->grid_x = 300;
	vp->grid_y = 300;
	vp->roundbox = FALSE;
	vp->roundsize = 8; 
	vp->fontnum = 0; 
	vp->text_object = NULL; 
	vp->fontsize = 12; 
	vp->closed = FALSE; 
	vp->openarc = FALSE; 
	vp->current_sfactor = 1.0; 

	if (!create_window(&(vp->window),RootWindow(display,screen), &wins, MAIN_VIEW_WIN, vp))
		{
		free(vp);
		return 0;
		};
	
	if (strlen(dp->pathname)<400) 
		strncpy(a, dp->pathname,400);
	strncat(a,dp->filename,400);
	strcat(a," (100.0%)");
	
	strcpy(vp->wname,a); 
	set_window_name(&(vp->window),vp->wname); 
	   
	/* our eye icon  */
	if (stk_create_icon(&eye_icon,vp->window.win,FALSE,-1)==FAIL)
		{
		free(vp);
		return 0;
		};
	
	 
	/* drawing area window  */
	dwinp = (WindowStruct *)malloc(sizeof(WindowStruct));

	if (dwinp==NULL)
		{
		free(vp);
		return 0;
		};
	
	 
	vp->draw_window = dwinp;
	dwinp->parent = vp->window.win;
	dwinp->x = RULER_PIXEL_SIZE+1;
	dwinp->y = RULER_PIXEL_SIZE+1;
	dwinp->w = vp->window.w-RULER_PIXEL_SIZE;
	dwinp->h = vp->window.h-RULER_PIXEL_SIZE-VIEW_ICON_SIZE;
	if (state.current_icon==TEXTICON)
		dwinp->cursor_num = XC_xterm;
	else 
		dwinp->cursor_num = XC_crosshair;
	dwinp->size_hints = NULL; 
	dwinp->gc = handlegc;
	dwinp->grabbed = FALSE; 
	
	if (!create_window(dwinp, vp->window.win, &wins, DRAW_WIN, (void *)dwinp))
		{
		free(dwinp); 
		free(vp);
		return 0;
		};
	 
	XMapWindow(display,dwinp->win);  
	 
	/* now we create our ruler windows  */

	winp = (WindowStruct *)malloc(sizeof(WindowStruct));

	if (winp==NULL)
		{
		free(vp);
		return 0;
		};
	
	winp->parent = vp->window.win;
	winp->x = RULER_PIXEL_SIZE+1;
	winp->y = 0;
	winp->w = vp->window.w-RULER_PIXEL_SIZE;
	winp->h = RULER_PIXEL_SIZE+1;
	winp->cursor_num = XC_sb_h_double_arrow;
	dwinp->size_hints = NULL; 
	winp->gc = rulergc; 
	winp->grabbed = FALSE; 
	
	if (!create_window(winp, vp->window.win, &wins, RULER_X_WIN, (void *)winp))
		{
		free(dwinp); 
		free(winp);
		free(vp);
		return 0;
		};
	
	vp->ruler_x_window = winp;

 	XMapWindow(display,winp->win); 
	 
	win2p = (WindowStruct *)malloc(sizeof(WindowStruct));

	if (win2p==NULL)
		{
		free(vp);
		free(dwinp); 
		free(winp); 
		return 0;
		};
		 
   win2p->parent = vp->window.win;
   win2p->x = 0;
   win2p->y = RULER_PIXEL_SIZE+1;
   win2p->w = RULER_PIXEL_SIZE+1;
   win2p->h = vp->window.h-RULER_PIXEL_SIZE-VIEW_ICON_SIZE;
   win2p->cursor_num = XC_sb_v_double_arrow;
	win2p->gc = rulergc; 
	win2p->grabbed = FALSE; 

   if (!create_window(win2p, vp->window.win, &wins, RULER_Y_WIN, (void *)win2p))
      {
      free(win2p);
      free(winp);
      free(vp);
		return 0;
      };

	vp->ruler_y_window = win2p;
 	XMapWindow(display,win2p->win);      
	
	iwinp = (WindowStruct *)malloc(sizeof(WindowStruct));
	
	if (iwinp==NULL)
		{
		free(vp);
		free(dwinp);
		free(winp);
		free(win2p);
		return 0;
		};
	
	iwinp->parent = vp->window.win;
	iwinp->x = 0;
	iwinp->y = vp->window.h-VIEW_ICON_SIZE;
	iwinp->w = vp->window.w;
	iwinp->h = VIEW_ICON_SIZE;
	iwinp->cursor_num = XC_left_ptr;
	iwinp->gc = rulergc;
	iwinp->grabbed = FALSE;

	if (!create_window(iwinp, vp->window.win, &wins, VIEW_ICON_WIN, (void *)iwinp))
		{
		free(vp);
		free(dwinp);
		free(winp);
		free(win2p);
		free(iwinp);
		return 0;
		};
		
	vp->view_icon_window = iwinp;
	XMapWindow(display,iwinp->win);
	 
	if (stk_create_icon(&arrow_icon,vp->view_icon_window->win,FALSE,-1)==FAIL
		|| (stk_create_icon(&setpolygon_icon,vp->view_icon_window->win,FALSE,-1)==FAIL)
		|| (stk_create_icon(&endstyle_icon,vp->view_icon_window->win,FALSE,-1)==FAIL)
		|| (stk_create_icon(&joinstyle_icon,vp->view_icon_window->win,FALSE,-1)==FAIL)
		|| (stk_create_icon(&font_icon,vp->view_icon_window->win,FALSE,-1)==FAIL)
		|| (stk_create_icon(&linewidth_icon,vp->view_icon_window->win,FALSE,-1)==FAIL)
		|| (stk_create_icon(&setspline_icon,vp->view_icon_window->win,FALSE,-1)==FAIL)
		|| (stk_create_icon(&roundbox_icon,vp->view_icon_window->win,FALSE,-1)==FAIL)
		|| (stk_create_icon(&justification_icon,vp->view_icon_window->win,FALSE,-1)==FAIL)
		|| (stk_create_icon(&grid_icon,vp->view_icon_window->win,FALSE,-1)==FAIL)
		|| (stk_create_icon(&showgrid_icon,vp->view_icon_window->win,FALSE,-1)==FAIL)
		|| (stk_create_icon(&zoomin_icon,vp->view_icon_window->win,FALSE,-1)==FAIL)
		|| (stk_create_icon(&zoomout_icon,vp->view_icon_window->win,FALSE,-1)==FAIL)
		|| (stk_create_icon(&linestyle_icon, vp->view_icon_window->win, FALSE,-1)==FAIL)
		|| (stk_create_icon(&fillstyle_icon, vp->view_icon_window->win, FALSE,-1)==FAIL)
		|| (stk_create_icon(&colour_icon, vp->view_icon_window->win, FALSE,(long)cols[28].colour)==FAIL)
		|| (stk_create_icon(&fillcolour_icon, vp->view_icon_window->win, FALSE,(long)fillcols[29].colour)==FAIL)
		|| (stk_create_icon(&setarcellipse_icon, vp->view_icon_window->win, FALSE, -1)==FAIL) ) 
		{
		free(vp);
		free(dwinp);
		free(winp);
		free(win2p);
		free(iwinp);
		return 0;
		};

	if (vp->gridon)
	 	stk_select_icon(GRIDICON,vp->view_icon_window->win); 
		 
	if (vp->showgrid)
	 	stk_select_icon(SHOWGRIDICON,vp->view_icon_window->win); 
		 
	stk_attach_icon_menu(LINESTYLEICON, vp->view_icon_window->win, linestyle_menu);
	stk_attach_icon_menu(ENDSTYLEICON, vp->view_icon_window->win, endstyle_menu);
	stk_attach_icon_menu(JOINSTYLEICON, vp->view_icon_window->win, joinstyle_menu);
	stk_attach_icon_menu(SETARCELLIPSEICON, vp->view_icon_window->win, setarcellipse_menu);
	stk_attach_icon_menu(FILLSTYLEICON, vp->view_icon_window->win, fillstyle_menu);
	stk_attach_icon_menu(COLOURICON, vp->view_icon_window->win, colour_menu);
	stk_attach_icon_menu(FILLCOLOURICON, vp->view_icon_window->win, fillcolour_menu);
	stk_attach_icon_menu(JUSTIFICATIONICON, vp->view_icon_window->win, justification_menu);

	/* use -1 here as actually a text menu is attached */
	stk_attach_icon_menu(EYEICON, vp->window.win, (Window)-1);
	 
	state.views = add_to_list(state.views, 0, 0, (void *)vp);
	vp->doc->views = add_to_list(vp->doc->views, 0, 0, (void *)vp); 

	switch_icons(vp);
	return vp->window.win;
}

void 
new_view(Document *dp)
{
	XMapWindow(display,new_view0(dp)); 
}
