/* ruler.c */
/* COPYRIGHT (C) 2000 THE VICTORIA UNIVERSITY OF MANCHESTER and John Levon
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details. 
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA. 
 */
/* For ruler stuff */
/*
 * $Log: ruler.c,v $
 * Revision 1.2  2000/12/06 20:56:03  moz
 * GPL stuff.
 *
 * Revision 1.1.1.1  2000/08/21 01:05:31  moz
 *
 *
 * Revision 1.1.1.1  2000/07/19 22:45:30  moz
 * CVS Import
 *
 * Revision 1.6  2000/03/08 22:12:30  moz
 * Compile fixes.
 *
 * Revision 1.5  2000/01/30 17:21:41  moz
 * no_desert unused.
 *
 * Revision 1.4  1999/11/15 02:05:30  moz
 * Name change.
 *
 * Revision 1.3  1999/05/19 17:08:20  moz
 * 1.0 Checkin.
 *
 * Revision 1.2  1999/04/03 21:11:56  moz
 * Removed debug message.
 *
 * Revision 1.1  1999/03/30 00:05:55  moz
 * Initial revision
 *
 */    

#include "include/figurine.h"
#include "include/extern.h"

int 
nudge_ruler_x(WindowStruct *window, View *view, int direction)
{
	int factor; 
	double off;
	double orig; 
	 
	orig = view->x_inches_offset;

	if (view->in_mm)
		{
		if (view->zoom_factor >= 10.0)
			factor=1;
		else if (view->zoom_factor >=3.0) 
			factor=2; 
		else if (view->zoom_factor >= 0.9)
			factor=10;
		else
			factor=20;
		}
	else
		{
		if (view->zoom_factor >= 10.0) 
			factor=1; 
		else if (view->zoom_factor >= 4.0)
			factor=2;
		else if (view->zoom_factor >= 0.5)
			factor=8;
		else
			factor=16;
		};

	if (view->in_mm)
		off = direction * MM_TO_INCHES(1.0*factor);
	else
		off = direction * factor*1.0/32.0;

		if ((view->x_inches_offset+off)<0) 
		view->x_inches_offset = 0;
	else if (direction == LEFT) 
		view->x_inches_offset = max(view->x_inches_offset+off, -25.0);
	else
		view->x_inches_offset = min(view->x_inches_offset+off, 15.0 + view->doc->width_in_inches);
		
	if (I2D(orig,view)!=I2D(view->x_inches_offset,view))
		{
		if (view->in_mm) 
			draw_ruler_x_mm(window,view->zoom_factor, INCHES_TO_MM(view->x_inches_offset));     
		else 
			draw_ruler_x(window,view->zoom_factor, view->x_inches_offset);     

		return 1;
		}
	 else
	 	return -1;

}

int 
nudge_ruler_y(WindowStruct *window, View *view, int direction)
{
	int factor; 
	double off;
	double orig; 
	 
	orig = view->y_inches_offset;  
	 
	if (view->in_mm)
		{
		if (view->zoom_factor >= 10.0)
			factor=1;
		else if (view->zoom_factor >=3.0) 
			factor=2; 
		else if (view->zoom_factor >= 0.9)
			factor=10;
		else
			factor=20;
		}
	else
		{
		if (view->zoom_factor >= 10.0) 
			factor=1; 
		else if (view->zoom_factor >= 4.0)
			factor=2;
		else if (view->zoom_factor >= 0.5)
			factor=8;
		else
			factor=16;
		};

	if (view->in_mm)
		off = direction * MM_TO_INCHES(1.0*factor);
	else
		off = direction * factor*1.0/32.0;

	if ((view->y_inches_offset+off)<0)
		view->y_inches_offset = 0;
	else if (direction == UP) 
		view->y_inches_offset = max(view->y_inches_offset+off, -25.0);
	else
		view->y_inches_offset = min(view->y_inches_offset+off, 15.0 + view->doc->height_in_inches);
		
	if (I2D(orig,view)!=I2D(view->y_inches_offset,view))
		{
		if (view->in_mm) 
			draw_ruler_y_mm(window,view->zoom_factor, INCHES_TO_MM(view->y_inches_offset));     
		else 
			draw_ruler_y(window,view->zoom_factor, view->y_inches_offset);     
		return 1;
		}
	else
		return -1;

}

/* the draw routines attempt to leave out lines and numbers that would
	make the ruler look cluttered */  
	 
void 
draw_ruler_x(WindowStruct *window, double zoom_factor, double inches_offset)
{
	int count;
	int x=0;
	int max_height; 
	int height; 
	int initial; 
	int inch;  /* inch in screen pixels at current zoom  */ 
	double inc_offset=0; 
	char str[3]; 

	XClearWindow(display,window->win);

	set_clip(rulergc, 0, 0, (int)window->w, (int)window->h);            
	XDrawLine(display,window->win,rulergc,0,RULER_PIXEL_SIZE,((int)window->w)-1,RULER_PIXEL_SIZE);
	 
	inch = INCHES_TO_PIXELS(1.0*zoom_factor);

	if (inch<6)
		max_height = RULER_PIXEL_SIZE - 14;
	else if (inch<16)
		max_height = RULER_PIXEL_SIZE - 8;
	else if (inch<32)
		max_height = RULER_PIXEL_SIZE - 6;
	else if (inch<63)
		max_height = RULER_PIXEL_SIZE - 4;
	else if (inch<90)
		max_height = RULER_PIXEL_SIZE - 3;
	else
		max_height = RULER_PIXEL_SIZE - 2;

	count = (int)(inches_offset*32.0); /* offset is in 1/32 inch units */ 
	
	x = initial =  ((((double)count)/32.0) - inches_offset)*zoom_factor*screen_ppi; 

	do
		{
		if (count % 32 == 0)
			{
			/* draw every text line  */ 
			sprintf(str,"%d",count/32); 
			if (inch > XTextWidth(rulerfont,str,(int)strlen(str))+4) 
				XDrawString(display,window->win,rulergc, 
					x-XTextWidth(rulerfont,str,(int)strlen(str))-1,
					3+rulerfont->max_bounds.ascent, str, (int)strlen(str));
			height = RULER_PIXEL_SIZE - 14;
			}
		else if (count % 64 == 0)
			{
			/* draw every other text line if space */
			sprintf(str,"%d",count/32); 
			if ((2*inch) > XTextWidth(rulerfont,str,(int)strlen(str))+4) 
				XDrawString(display,window->win,rulergc, 
					x-XTextWidth(rulerfont,str,(int)strlen(str))-1,
					3+rulerfont->max_bounds.ascent, str, (int)strlen(str));
			height = RULER_PIXEL_SIZE - 14; 
			}
		else if (count % 16 == 0)
			height = RULER_PIXEL_SIZE - 8;
		else if (count % 8 == 0)
			height = RULER_PIXEL_SIZE - 6;
		else if (count % 4 == 0)
			height = RULER_PIXEL_SIZE - 4;
		else if (count % 2 == 0)
			height = RULER_PIXEL_SIZE - 3;
		else
			height = RULER_PIXEL_SIZE - 2;

		if (height <= max_height)
			XDrawLine(display,window->win,rulergc, x, height, x, RULER_PIXEL_SIZE); 
		
		count++;
		inc_offset += 1.0/32.0; 
		x = initial + INCHES_TO_PIXELS(inc_offset*zoom_factor);

		} while (x<((int)window->w));
}
 
void 
draw_ruler_x_mm(WindowStruct *window, double zoom_factor, double mm_offset)
{
	int count;
	int x=0;
	int max_height; 
	int height; 
	int initial; 
	int cm;  /* cm in screen pixels at current zoom  */ 
	double inc_offset=0; 
	char str[3]; 

	XClearWindow(display,window->win);

	set_clip(rulergc, 0, 0, (int)window->w, (int)window->h);            
	XDrawLine(display,window->win,rulergc,0,RULER_PIXEL_SIZE,(int)window->w-1,RULER_PIXEL_SIZE);
	 
	cm = INCHES_TO_PIXELS(MM_TO_INCHES(10)*zoom_factor);

	if (cm<25)
		max_height = RULER_PIXEL_SIZE - 14;
	else if (cm<32)
		max_height = RULER_PIXEL_SIZE - 8;
	else
		max_height = RULER_PIXEL_SIZE - 3;

	count = (int)(mm_offset*1.0); /* offset is in 1 mm units */ 

	x = initial =  ((((double)count)) - mm_offset)*zoom_factor*(screen_ppi/25.4);
	 
	do
		{
		if (count % 10 == 0)
			{
			/* draw every text line  */ 
			sprintf(str,"%d",count/10); 
			if (cm > XTextWidth(rulerfont,str,(int)strlen(str))+4) 
				XDrawString(display,window->win,rulergc, 
					x-XTextWidth(rulerfont,str,(int)strlen(str))-1,
					3+rulerfont->max_bounds.ascent, str, (int)strlen(str));
			height = RULER_PIXEL_SIZE - 14;
			}
		else if (count % 20 == 0)
			{
			/* draw every other text line if space */
			sprintf(str,"%d",count/10); 
			if ((2*cm) > XTextWidth(rulerfont,str,(int)strlen(str))+4) 
				XDrawString(display,window->win,rulergc, 
					x-XTextWidth(rulerfont,str,(int)strlen(str))-1,
					3+rulerfont->max_bounds.ascent, str, (int)strlen(str));
			height = RULER_PIXEL_SIZE - 14; 
			}
		else if (count % 5 == 0)
			height = RULER_PIXEL_SIZE - 8;
		else 
			height = RULER_PIXEL_SIZE - 3;

		if (height <= max_height)
			XDrawLine(display,window->win,rulergc, x, height, x, RULER_PIXEL_SIZE); 
		
		count++;
		inc_offset += 1.0; 
		x = initial + INCHES_TO_PIXELS(MM_TO_INCHES(inc_offset)*zoom_factor);

		} while (x<(int)window->w);
	
}
 
void 
draw_ruler_y(WindowStruct *window, double zoom_factor, double inches_offset)
{
	int count;
	int y=0;
	int max_height; 
	int height; 
	int initial; 
	int inch;  /* inch in screen pixels at current zoom  */ 
	double inc_offset=0; 
	char str[3]; 

	XClearWindow(display,window->win);
	set_clip(rulergc, 0, 0, (int)window->w, (int)window->h);            

	XDrawLine(display,window->win,rulergc,RULER_PIXEL_SIZE,0,RULER_PIXEL_SIZE,(int)window->h-1);
 
	inch = INCHES_TO_PIXELS(1.0*zoom_factor);

	if (inch<6)
		max_height = RULER_PIXEL_SIZE - 14;
	else if (inch<16)
		max_height = RULER_PIXEL_SIZE - 8;
	else if (inch<32)
		max_height = RULER_PIXEL_SIZE - 6;
	else if (inch<63)
		max_height = RULER_PIXEL_SIZE - 4;
	else if (inch<90)
		max_height = RULER_PIXEL_SIZE - 3;
	else
		max_height = RULER_PIXEL_SIZE - 2;

	count = (int)(inches_offset*32.0); /* offset is in 1/32 inch units */ 
	y = initial =  ((((double)count)/32.0) - inches_offset)*zoom_factor*screen_ppi; 

	do
		{
		if (count % 32 == 0)
			{
			/* draw every text line  */ 
			sprintf(str,"%d",count/32); 
			if (inch > rulerfont->max_bounds.ascent + rulerfont->max_bounds.descent + 3) 
				XDrawString(display,window->win,rulergc, 4,
						y-rulerfont->max_bounds.descent, str, (int)strlen(str)); 
			height = RULER_PIXEL_SIZE - 14;
			}
		else if (count % 64 == 0)
			{
			/* draw every other text line if space */
			sprintf(str,"%d",count/32); 
			if ((2*inch) > rulerfont->max_bounds.ascent + rulerfont->max_bounds.descent + 3) 
				XDrawString(display,window->win,rulergc, 4,
						y-rulerfont->max_bounds.descent, str, (int)strlen(str)); 
			height = RULER_PIXEL_SIZE - 14; 
			}
		else if (count % 16 == 0)
			height = RULER_PIXEL_SIZE - 8;
		else if (count % 8 == 0)
			height = RULER_PIXEL_SIZE - 6;
		else if (count % 4 == 0)
			height = RULER_PIXEL_SIZE - 4;
		else if (count % 2 == 0)
			height = RULER_PIXEL_SIZE - 3;
		else
			height = RULER_PIXEL_SIZE - 2;

		if (height <= max_height)
			XDrawLine(display,window->win,rulergc, height, y, RULER_PIXEL_SIZE, y); 
		
		count++;
		inc_offset += 1.0/32.0; 
		y = initial + INCHES_TO_PIXELS(inc_offset*zoom_factor);

		} while (y<(int)window->h);
	
}	
 
void 
draw_ruler_y_mm(WindowStruct *window, double zoom_factor, double mm_offset)
{
	int count;
	int y=0;
	int max_height; 
	int height; 
	int initial; 
	int cm;  /* cm in screen pixels at current zoom  */ 
	double inc_offset=0; 
	char str[3]; 

	XClearWindow(display,window->win);

	set_clip(rulergc, 0, 0, (int)window->w, (int)window->h);
	XDrawLine(display,window->win,rulergc,RULER_PIXEL_SIZE,0,RULER_PIXEL_SIZE,(int)window->h-1);
	 
	cm = INCHES_TO_PIXELS(MM_TO_INCHES(10)*zoom_factor);

	if (cm<25)
		max_height = RULER_PIXEL_SIZE - 14;
	else if (cm<32)
		max_height = RULER_PIXEL_SIZE - 8;
	else 
		max_height = RULER_PIXEL_SIZE - 3;

	count = (int)(mm_offset*1.0); /* offset is in 1 mm units */ 
	y = initial =  ((((double)count)) - mm_offset)*zoom_factor*(screen_ppi/25.4);

	do
		{
		if (count % 10 == 0)
			{
			/* draw every text line  */ 
			sprintf(str,"%d",count/10); 
			if (cm > rulerfont->max_bounds.ascent + rulerfont->max_bounds.descent + 3)
				XDrawString(display,window->win,rulergc, 4,
						y-rulerfont->max_bounds.descent, str, (int)strlen(str));  
			height = RULER_PIXEL_SIZE - 14;
			}
		else if (count % 20 == 0)
			{
			/* draw every other text line if space */
			sprintf(str,"%d",count/10); 
			if ((2*cm) > rulerfont->max_bounds.ascent + rulerfont->max_bounds.descent + 3)
				XDrawString(display,window->win,rulergc, 4,
						y-rulerfont->max_bounds.descent, str, (int)strlen(str));  
			height = RULER_PIXEL_SIZE - 14; 
			}
		else if (count % 5 == 0)
			height = RULER_PIXEL_SIZE - 8;
		else 
			height = RULER_PIXEL_SIZE - 3;

		if (height <= max_height)
			XDrawLine(display,window->win,rulergc, height, y, RULER_PIXEL_SIZE, y); 
		
		count++;
		inc_offset += 1.0; 
		y = initial + INCHES_TO_PIXELS(MM_TO_INCHES(inc_offset)*zoom_factor);

		} while (y<(int)window->h);
	
}
