/* stk_draw  */
/* COPYRIGHT (C) 2000 THE VICTORIA UNIVERSITY OF MANCHESTER and John Levon
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details. 
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA. 
 */
/* provides several functions for drawing  */ 
/*
 * $Log: stk_draw.c,v $
 * Revision 1.2  2000/12/06 20:56:04  moz
 * GPL stuff.
 *
 * Revision 1.1.1.1  2000/08/21 01:05:31  moz
 *
 *
 * Revision 1.1.1.1  2000/07/19 22:45:31  moz
 * CVS Import
 *
 * Revision 1.2  2000/03/09 00:56:35  moz
 * Compile fixes.
 *
 * Revision 1.1  1999/03/30 00:06:09  moz
 * Initial revision
 *
 */    

#include "include/stk_internal.h"
#include "include/stk_extern.h"
#include "include/stk.h"

#define IXDrawLine(a,b,c,d,e,f,g) XDrawLine((a),(b),(c),(int)(d),(int)(e),(int)(f),(int)(g))
void 
stk_outline(WindowStruct *window, uint x, uint y, uint w, uint h)
{
	IXDrawLine(stk_display, window->win, topleftgc, x, y, x+w-1, y); 
	IXDrawLine(stk_display, window->win, topleftgc, x, y, x, y+h-1); 
	IXDrawLine(stk_display, window->win, topleftgc, x+1, y+1, x+w-1, y+1); 
	IXDrawLine(stk_display, window->win, topleftgc, x+1, y+1, x+1, y+h-1); 
	IXDrawLine(stk_display, window->win, bottomrightgc, x+w-1,y+h-1, x+1, y+h-1); 
	IXDrawLine(stk_display, window->win, bottomrightgc, x+w-1,y+h-1, x+w-1, y+1); 
	IXDrawLine(stk_display, window->win, bottomrightgc, x+w-2, y+h-2, x+2, y+h-2);
	IXDrawLine(stk_display, window->win, bottomrightgc, x+w-2, y+h-2, x+w-2, y+2);
}
 
void 
stk_inverse_outline(WindowStruct *window, uint x, uint y, uint w, uint h)
{
	IXDrawLine(stk_display, window->win, bottomrightgc, x, y, x+w-1, y); 
	IXDrawLine(stk_display, window->win, bottomrightgc, x, y, x, y+h-1); 
	IXDrawLine(stk_display, window->win, bottomrightgc, x+1, y+1, x+w-1, y+1); 
	IXDrawLine(stk_display, window->win, bottomrightgc, x+1, y+1, x+1, y+h-1); 
	IXDrawLine(stk_display, window->win, topleftgc, x+w-1,y+h-1, x+1, y+h-1); 
	IXDrawLine(stk_display, window->win, topleftgc, x+w-1,y+h-1, x+w-1, y+1); 
	IXDrawLine(stk_display, window->win, topleftgc, x+w-2, y+h-2, x+2, y+h-2);
	IXDrawLine(stk_display, window->win, topleftgc, x+w-2, y+h-2, x+w-2, y+2);
}
 
void 
stk_thin_outline(WindowStruct *window, uint x, uint y, uint w, uint h)
{
	IXDrawLine(stk_display, window->win, topleftgc, x, y, x+w-1, y); 
	IXDrawLine(stk_display, window->win, topleftgc, x, y, x, y+h-1); 
	IXDrawLine(stk_display, window->win, bottomrightgc, x+w-1,y+h-1, x+1, y+h-1); 
	IXDrawLine(stk_display, window->win, bottomrightgc, x+w-1,y+h-1, x+w-1, y+1); 
} 
