/* zoom.c  */ 
/* COPYRIGHT (C) 2000 THE VICTORIA UNIVERSITY OF MANCHESTER and John Levon
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details. 
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA. 
 */
/*
 * $Log: zoom.c,v $
 * Revision 1.2  2000/12/06 20:56:07  moz
 * GPL stuff.
 *
 * Revision 1.1.1.1  2000/08/21 01:05:31  moz
 *
 *
 * Revision 1.1.1.1  2000/07/19 22:45:31  moz
 * CVS Import
 *
 * Revision 1.13  2000/03/14 22:42:53  moz
 * Fix for droppings when editing_object (see edit_ob.c)
 *
 * Revision 1.12  2000/03/14 02:48:48  moz
 * Slight xor improvement.
 *
 * Revision 1.11  2000/03/14 01:09:36  moz
 * Remove non-working xor stuff.
 *
 * Revision 1.10  2000/03/13 17:35:03  moz
 * Only leaves edit object droppings when zooming *in* now.
 *
 * Revision 1.9  2000/03/08 22:15:02  moz
 * Compile fixes.
 *
 * Revision 1.8  2000/02/27 21:28:32  moz
 * Movee zoom_levels to here.
 *
 * Revision 1.7  2000/01/30 17:23:45  moz
 * no_desert unused.
 *
 * Revision 1.6  1999/11/15 02:00:20  moz
 * Name change.
 *
 * Revision 1.5  1999/07/04 02:04:33  moz
 * Back to REDRAW_ALL_WINDOW(v->draw_window) to fix some rubber band droppings.
 *
 * Revision 1.4  1999/07/03 21:35:13  moz
 * If from a button, don't resize, and zoom from/to centre of figure.
 *
 * Revision 1.3  1999/06/30 14:28:06  moz
 * Redraw the window if the resizing has no effect.
 *
 * Revision 1.2  1999/04/23 00:40:26  moz
 * redraw_view_window change.
 *
 * Revision 1.1  1999/03/30 00:07:13  moz
 * Initial revision
 *
 */    

#include "include/figurine.h"
#include "include/extern.h"

static double zoom_levels[] =
        { 0.05, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0, 1.1, 1.2, 1.3, 1.4, 1.5, 1.7, 2.0, 3.0, 4.0,
	          5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 12.0, 15.0,17.0, 20.0, };
static int no_zoom_levels = sizeof(zoom_levels)/sizeof(double);

extern int disable_motion;

Boolean just_resized=FALSE;

void 
zoom_in(View *v,Boolean button)
{
	long x, y;
	ulong vw, vh;
	Boolean growx=FALSE, growy=FALSE; 
	char a[850]; 
	char a2[10]; 
	 
	if (v->zoom_level>=no_zoom_levels-1)
		return;

	x = XP2D(mouse_x,v);
	y = YP2D(mouse_y,v);

	v->zoom_factor = zoom_levels[++v->zoom_level];

	vw = v->window.w; 
	vh = v->window.h; 
	 
	if (strlen(v->doc->pathname)<400)
		strncpy(a, v->doc->pathname,400);
	strncat(a,v->doc->filename,400);
	strcat(a," (");
	sprintf(a2,"%.1f",v->zoom_factor*100);
	strcat(a,a2);
	strcat(a,"%)");

	strcpy(v->wname,a);
	set_window_name(&(v->window),v->wname);      
	 
	if (!button)
		{
		XEvent xev;

		growx = (RULER_PIXEL_SIZE + I2P(v->doc->width_in_inches,v))  < (7.0*DisplayWidth(display,screen)/10.0);
		growy = (VIEW_ICON_SIZE + RULER_PIXEL_SIZE + I2P(v->doc->height_in_inches,v)) < (7.0*DisplayHeight(display,screen)/10.0);
		 
		v->x_inches_offset = D2I(x,v) - (P2I(v->draw_window->w,v)/2.0);
		v->y_inches_offset = D2I(y,v) - (P2I(v->draw_window->h,v)/2.0);
		XWarpPointer(display, None, v->draw_window->win, 0, 0, 1, 1,
				 (int)v->draw_window->w/2, (int)v->draw_window->h/2);
		mouse_x = v->draw_window->w/2;
		mouse_y = v->draw_window->h/2;
		XSync(display,False); 
		while (XCheckTypedWindowEvent(display, v->draw_window->win, MotionNotify, &xev))
			;
		 
		if (growx)
			{ 
			vw = I2P(v->doc->width_in_inches,v) + 1 + RULER_PIXEL_SIZE;
			v->x_inches_offset = 0;
			};
		
		if (growy)
			{ 
			vh = I2P(v->doc->height_in_inches,v) + 1 + RULER_PIXEL_SIZE + VIEW_ICON_SIZE;
			v->y_inches_offset = 0;
			};

		if (growx || growy)
			XResizeWindow(display, v->window.win, vw, vh);
		} 
	else
		{
		v->x_inches_offset = (v->doc->width_in_inches - P2I(v->draw_window->w,v))/2.0;
		v->y_inches_offset = (v->doc->height_in_inches - P2I(v->draw_window->h,v))/2.0;
		}; 
	  
	/* bitmap fonts don't scale linearly  */  
	recalc_text_boxes(v);

	disable_motion=4;
	just_resized=TRUE; 
	if (button || (!growx && !growy) || (vw==v->window.w && vh==v->window.h)) 
		{ 
 		REDRAW_ALL_WINDOW(v->draw_window);
		REDRAW_ALL_WINDOW(v->ruler_x_window); 
		REDRAW_ALL_WINDOW(v->ruler_y_window); 
		};
}

void 
zoom_out(View *v,Boolean button)
{
	long x, y;
	ulong vw, vh; 
	Boolean shrinkx=FALSE, shrinky=FALSE; 
	char a[850]; 
	char a2[10]; 
	 
	if (v->zoom_level==0)
		return;

	x = XP2D(mouse_x,v);
	y = YP2D(mouse_y,v);

	v->zoom_factor = zoom_levels[--v->zoom_level];

	shrinkx = (RULER_PIXEL_SIZE + I2P(v->doc->width_in_inches,v))  < (7.0*DisplayWidth(display,screen)/10.0);
	shrinky = (RULER_PIXEL_SIZE + VIEW_ICON_SIZE + I2P(v->doc->height_in_inches,v)) < (7.0*DisplayHeight(display,screen)/10.0);

	v->x_inches_offset = D2I(x,v) - (P2I(v->draw_window->w,v)/2.0);
	v->y_inches_offset = D2I(y,v) - (P2I(v->draw_window->h,v)/2.0);

	if (strlen(v->doc->pathname)<400)
		strncpy(a, v->doc->pathname,400);
	strncat(a,v->doc->filename,400);
	strcat(a," (");
	sprintf(a2,"%.1f",v->zoom_factor*100);
	strcat(a,a2);
	strcat(a,"%)");

	strcpy(v->wname,a);
	set_window_name(&(v->window),v->wname);      

	vw = v->window.w; 
	vh = v->window.h; 
	 
	if (!button)
		{
		if (shrinkx)
			{ 
			vw = I2P(v->doc->width_in_inches,v) + 1 + RULER_PIXEL_SIZE;
			v->x_inches_offset = 0;
			};
		
		if (shrinky)
			{ 
			vh = I2P(v->doc->height_in_inches,v) + 1 + RULER_PIXEL_SIZE + VIEW_ICON_SIZE;
			v->y_inches_offset = 0;
			};
			 
		if (v->x_inches_offset<0)
			v->x_inches_offset = 0; 
		if (v->y_inches_offset<0)
			v->y_inches_offset = 0; 
			 
		if (shrinkx || shrinky)
			XResizeWindow(display, v->window.win, vw, vh);
		}
	else
		{
		v->x_inches_offset = (v->doc->width_in_inches - P2I(v->draw_window->w,v))/2.0;
		v->y_inches_offset = (v->doc->height_in_inches - P2I(v->draw_window->h,v))/2.0;
		};


	/* bitmap fonts don't scale linearly  */  
	recalc_text_boxes(v);
	 
	disable_motion=4;
	just_resized=TRUE; 
	/* only redraw again if the window hasn't been resized  */   
	if (button || (!shrinkx && !shrinky) || (vw==v->window.w && vh==v->window.h)) 
		{ 
		REDRAW_ALL_WINDOW(v->draw_window);
		REDRAW_ALL_WINDOW(v->ruler_x_window); 
		REDRAW_ALL_WINDOW(v->ruler_y_window); 
		};
}
