/*---[ service.c ]----------------------------------------------------
 * Copyright (C) 2000 Tomas Junnonen (majix@sci.fi)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Return the service used, based on the port and protocol given
 *--------------------------------------------------------------------*/

#include <netdb.h>
#include <netinet/in.h>
#include "service.h"

/* [ service ]
 * Return the service/exploit used, based on the port and protocol given
 */
gchar*
service (gint port, gint proto)
{
	struct servent *ent;

	if (port == 135) return ("ms-rpc");
	if (port == 31337) return ("borifice");
	if (port == 12345) return ("netbus");
	if (port == 12346) return ("netbus");
	if (port == 1524) return ("trin00");
	if (port == 27665) return ("trin00");
	if (port == 27444) return ("trin00");
	if (port == 31335) return ("trin00");
	if (port == 33270) return ("trinity");
	if (port == 1234) return ("subseven");
	if (port == 5000) return ("uPNP");
	if (port == 6711) return ("subseven");
	if (port == 16660) return ("stacheldraht");
	if (port == 60001) return ("stacheldraht");

	if (proto == 17)
		ent = getservbyport (htons (port), "udp");
	else if (proto == 51)
		ent = getservbyport (htons (port), "ah");
	else
		ent = getservbyport (htons (port), "tcp");

	if (ent)
		return (ent->s_name);
	else
		return _("unknown");
}
