// This file is part of fityk program. Copyright (C) Marcin Wojdyr
// Licence: GNU General Public License ver. 2+

#include "about.h"
#include <boost/version.hpp> // BOOST_VERSION
#include <xylib/xylib.h> // get_version()
#include <wx/hyperlink.h>
#include <wx/config.h>

#include "cmn.h" // pchar2wx, s2wx, GET_BMP
#include "../common.h" // VERSION
#include "img/fityk96.h"


AboutDlg::AboutDlg(wxWindow* parent)
    : wxDialog(parent, -1, wxT("About Fityk"), wxDefaultPosition,
               wxDefaultSize, wxDEFAULT_DIALOG_STYLE|wxRESIZE_BORDER)
{
    wxBoxSizer *sizer = new wxBoxSizer(wxVERTICAL);
    wxBoxSizer *hsizer = new wxBoxSizer(wxHORIZONTAL);
    hsizer->Add(new wxStaticBitmap(this, -1, GET_BMP(fityk96)),
                wxSizerFlags().Centre().Border());
    wxBoxSizer *name_sizer = new wxBoxSizer(wxVERTICAL);
    wxStaticText *name = new wxStaticText(this, -1,
                                          wxT("fityk ") + pchar2wx(VERSION));
    name->SetFont(wxFont(24, wxFONTFAMILY_DEFAULT, wxFONTSTYLE_NORMAL,
                         wxFONTWEIGHT_BOLD));
    name_sizer->Add(name, wxSizerFlags().Centre().Border());
    wxStaticText *desc = new wxStaticText(this, -1,
                            wxT("A curve fitting and data analysis program"));
    name_sizer->Add(desc, wxSizerFlags().Centre().Border(wxLEFT|wxRIGHT));
    wxString link = wxT("http://fityk.nieto.pl");
    wxHyperlinkCtrl *link_ctrl = new wxHyperlinkCtrl(this, -1, link, link);
    name_sizer->Add(link_ctrl, wxSizerFlags().Centre().Border());

    hsizer->Add(name_sizer, wxSizerFlags(1).Expand());
    sizer->Add(hsizer, wxSizerFlags());
    wxTextCtrl *txt = new wxTextCtrl(this, -1, wxT(""), wxDefaultPosition,
#ifdef __WXMSW__
                                     wxSize(-1,150),
#else
                                     wxSize(-1,200),
#endif
                         wxTE_MULTILINE|wxTE_RICH|wxNO_BORDER |wxTE_READONLY);
#ifdef __WXGTK__
    //wxColour bg_col = wxStaticText::GetClassDefaultAttributes().colBg;
    wxColour bg_col = name->GetDefaultAttributes().colBg;
#else
    wxColour bg_col = GetBackgroundColour();
#endif
    txt->SetBackgroundColour(bg_col);
    txt->SetDefaultStyle(wxTextAttr(wxNullColour, bg_col, *wxITALIC_FONT));
    txt->AppendText(wxT("powered by ") wxVERSION_STRING wxT("\n"));
    txt->AppendText(wxString::Format(wxT("powered by Boost %d.%d.%d\n"),
                                     BOOST_VERSION / 100000,
                                     BOOST_VERSION / 100 % 1000,
                                     BOOST_VERSION % 100));
    txt->AppendText(wxT("powered by xylib ") + pchar2wx(xylib_get_version())
                    + wxT("\n"));
    txt->SetDefaultStyle(wxTextAttr(wxNullColour, bg_col, *wxNORMAL_FONT));
    txt->AppendText(wxT("\nCopyright (C) 2001 - 2011 Marcin Wojdyr\n\n"));
    txt->AppendText(
   wxT("This program is free software; you can redistribute it and/or modify ")
   wxT("it under the terms of the GNU General Public License as published by ")
   wxT("the Free Software Foundation; either version 2 of the License, or ")
   wxT("(at your option) any later version.")
    );
    sizer->Add (txt, 1, wxALL|wxEXPAND|wxFIXED_MINSIZE, 5);

    //sizer->Add (new wxStaticLine(this, -1), 0, wxEXPAND|wxLEFT|wxRIGHT, 10);
    wxButton *button = new wxButton (this, wxID_CLOSE);
    SetEscapeId(wxID_CLOSE);
    //button->SetDefault();
    sizer->Add(button, wxSizerFlags().Right().Border());
    SetSizerAndFit(sizer);
}

AboutReleaseDlg::AboutReleaseDlg(wxWindow* parent)
    : wxDialog(parent, -1, wxT("About This Release"), wxDefaultPosition,
               wxDefaultSize, wxDEFAULT_DIALOG_STYLE|wxRESIZE_BORDER)
{
    wxBoxSizer *sizer = new wxBoxSizer(wxVERTICAL);
    wxBoxSizer *hsizer = new wxBoxSizer(wxHORIZONTAL);
    hsizer->Add(new wxStaticBitmap(this, -1, GET_BMP(fityk96)),
                wxSizerFlags().Centre().Border());
    wxBoxSizer *name_sizer = new wxBoxSizer(wxVERTICAL);
    wxStaticText *name = new wxStaticText(this, -1,
                                          wxT("fityk ") + pchar2wx(VERSION));
    name->SetFont(wxFont(24, wxFONTFAMILY_DEFAULT, wxFONTSTYLE_NORMAL,
                         wxFONTWEIGHT_BOLD));
    name_sizer->Add(name, wxSizerFlags().Centre().Border());
    wxStaticText *desc = new wxStaticText(this, -1,
                            wxT("A curve fitting and data analysis program"));
    name_sizer->Add(desc, wxSizerFlags().Centre().Border(wxLEFT|wxRIGHT));
    wxString link = wxT("http://fityk.nieto.pl");
    wxHyperlinkCtrl *link_ctrl = new wxHyperlinkCtrl(this, -1, link, link);
    name_sizer->Add(link_ctrl, wxSizerFlags().Centre().Border());

    hsizer->Add(name_sizer, wxSizerFlags(1).Expand());
    sizer->Add(hsizer, wxSizerFlags());
    wxTextCtrl *txt = new wxTextCtrl(this, -1, wxT(""), wxDefaultPosition,
#ifdef __WXMSW__
                                     wxSize(200, 200),
#else
                                     wxSize(300, 300),
#endif
                         wxTE_MULTILINE|wxTE_RICH|wxTE_READONLY);
    txt->AppendText(wxT("If this program helps you write an academic paper")
                    wxT(" you may cite:\n"));
    txt->SetDefaultStyle(
            wxTextAttr(wxNullColour, wxNullColour, *wxITALIC_FONT));
    txt->AppendText(wxT("M. Wojdyr, J. Appl. Cryst. 43, 1126 (2010)\n\n"));
    txt->SetDefaultStyle(
            wxTextAttr(wxNullColour, wxNullColour, *wxNORMAL_FONT));
    txt->AppendText(
   wxT("This is a bug fix release of old (0.9) Fityk version.\n\n")
   wxT("There are two reasons to use this version.\n")
   wxT("1. Binaries are free")
   wxT(" (the latest official binaries are available for subscribers only, ")
   wxT(" the payment supports further development).\n")
   wxT("2. It works with old wxWidgets library (2.8).\n\n")
   wxT("In many cases this version has all necessary features and if the ugly")
   wxT(" plots (no anti-aliasing) don't bother you, ")
   wxT("you may have no reason for upgrading.")
   wxT(" Anyway, if you've spent 100+ hours analysing data with Fityk,")
   wxT(" and if you think the analysis would take much more time without ")
   wxT("this program, please consider paying for a subscription.\n")
    );
    txt->ShowPosition(0);
    sizer->Add (txt, 1, wxALL|wxEXPAND|wxFIXED_MINSIZE, 5);

    wxCheckBox *cb =
        new wxCheckBox(this, -1, wxT("Show this message at startup"));
    bool c = cfg_read_bool(wxConfig::Get(), wxT("/ShowReleaseInfo"), true);
    cb->SetValue(c);
    sizer->Add (cb, 0, wxEXPAND|wxLEFT|wxRIGHT, 10);
    wxButton *button = new wxButton (this, wxID_CLOSE);
    SetEscapeId(wxID_CLOSE);
    //button->SetDefault();
    sizer->Add(button, wxSizerFlags().Right().Border());
    SetSizerAndFit(sizer);
    Connect(cb->GetId(), wxEVT_COMMAND_CHECKBOX_CLICKED,
            wxCommandEventHandler(AboutReleaseDlg::OnCheckbox));
    wxConfig::Get()->Write(wxT("/ReleaseInfoLastShown"), (double) time(0));
}

void AboutReleaseDlg::OnCheckbox(wxCommandEvent& event)
{
    bool checked = event.IsChecked();
    wxConfig::Get()->Write(wxT("/ShowReleaseInfo"), checked);
}
