.\" -*- nroff -*-
.\" $Id: fkiss.man,v 1.28 2000/10/17 05:01:58 yav Exp $
.\"
.\" Portions copyright 2006 Nathanael Nerode
.\"
.\" This program is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\" 
.\" This program is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\" 
.\" You should have received a copy of the GNU General Public License
.\" along with this program; if not, write to the Free Software
.\" Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
.\"
.TH fkiss 1 "Tue Nov 12, 2001"
.SH NAME
fkiss \- Freely enjoy childlike KISS, French\-KISS!
.SH SYNOPSIS
\fBfkiss\fP [\fIoption\fP...] [\fIfile.lzh\fP...] [\fIfile.cnf\fP]
.SH DESCRIPTION
.B French\-KISS!
(\fBfkiss\fP) is a sample implementation of
KISekae Set system (KISS) for X Window System.
KISS is a paper doll playing system for computers.
.br
.B fkiss
reads
.I file.cnf
(KISS configuration file),
and reads the color and cell files described in it.
If \fIfile.lzh\fP (LHa archive) is specified,
.B fkiss
calls \fBlha\fP to extract the archive
and searches for *.cnf in the archive.
One of
.I file.cnf
or
.I file.lha
must be specified.
.SH OPTIONS
.TP
.BI \-display " name"
Display connection.
.TP
.BI \-geometry " geom"
Window geometry.
.TP
.B \-debug
Print debug informations to stderr.
.TP
.B \-silent
Silent mode.
Warning messages are not displayed.
Sounds are not played.
.TP
.B \-verbose
Verbose mode.
.TP
.BI \-font " font"
Use a font named \fIfont\fP to print menu strings etc.
.TP
.BI \-font8 " font"
Use a font named \fIfont\fP to print comment strings.
By default "rk16" or "8x16" is used.
.TP
.BI \-font16 " font"
Use a font named \fIfont\fP to print Japanese comment strings.
By default "kanji16" or "k14" is used.
.TP
.BI \-fg " color"
Foreground color.
.TP
.BI \-bg " color"
Background color.
.TP
.BI \-bw " width"
Border width.
.TP
.BI \-cursor " n"
Cursor font control.
.br
.B 0
	(no control)
.br
.B 1
	hand   (null)
.br
.B 2
	undef  grip
.br
.B 3
	hand   grip	(*default)
.TP
.B \-s
Same as \fB\-cursor 1\fP.
.TP
.BI \-fixed " n"
Do not move a object its fix value is more than or equal to \fIn\fP.
If not specified, use maximum value described in configuration file.
.TP
.B \-scroll
Unlimited scroll.
.TP
.B \-gray
Convert RGB value to Gray scale brightness level.
(On GrayScale visual class server, This option is turned on automatically)
.TP
.B \-test
Automatically display all set, and print cell informations to stderr.
.TP
.B \-t
Execute time command with arguments "fkiss \-test ..." to report running time.
"fkiss \-t kissmars.lzh" is same as "time fkiss \-test kissmars.lzh".
.TP
.B \-nosound
Disable sound function. (same as \fB\-sound 0\fP)
.TP
.BI \-sound " n"
Select sound handling mode.
.br
.B 0
	Disable sound function.
.br
.B 1
	Use internal sound routine (cf. sound.c).
.br
.B 2
	Execute "play" command to play sound.
.TP
.BI \-soundcache " n[k|m]"
Change sound data cache buffer size limit \fIn\fP (kilo|mega) bytes.
By default, 256 kilobytes limit.
.TP
.B \-p
Use private color cells.
.TP
.B \-nocolormap
Disable to make new colormap.
.TP
.BI \-k " keyword"
Decode encrypted lzh archives (suffix .hes) with \fIkeyword\fP.
.TP
.BI \-randseed " n"
Use \fIn\fP for randomize seed.
If this option is not specified, use current time.
.TP
.B \-noevent
Disable fkiss event extension.
.TP
.B \-eventshell
Enable to execute shell command described in KISS configuration file.
Take care, this funciton makes a SECURITY HOLE!
.TP
.B \-wkiss
Emulate WKISS bug.
.TP
.BI \-transparency " n"
Set pseudo transparency mode.
.br
.B 0
	Disable pseudo transparency functions.
.br
.B 1
	Static dithered pseudo transparency mode.
.br
.B 2
	Under construnction. Buggy.
.TP
.BI \-comment " n"
Set cell comment display mode.
.br
.B 0
	Not display cell comment.
.br
.B 1
	Display pointed cell comment.
.br
.B 2
	Display all cell comment pointed object.
.TP
.B \-commentline
Display cell comment with cnf line number.
.TP
.BI \-button1 " n"
Assign function \fIn\fP to mouse button1 (left).
.br
.B 0
	No operation.
.br
.B 1
	Object catch, move and drop.
.br
.B 2
	Iconify window.
.br
.B 3
	Display cell comment.
.TP
.BI \-button2 " n"
Assign function \fIn\fP to mouse button2 (center).
.TP
.BI \-button3 " n"
Assign function \fIn\fP to mouse button3 (right).
.TP
.BI \-document " document_browse_command"
Execute \fIdocument_browse_command\fP to browse document.
By default, execute DOC_COMMAND defined in fkiss.c.
(Initial DOC_COMMAND defined "xemacs")
If the character % is not found in DOC_COMMAND,
Append " %P" string.
If the character at end of DOC_COMMAND is not &,
Append & character.
Following parameters in \fIdocument_browse_command\fP substitute.
.br
.B %A
	directory
.br
.B %P
	pathnames
.br
.B %F
	filenames
.br
Exmple:
.br
\-document "(cd %A; more %F) &"
.br
"(cd /tmp/fkiss123; more litks09.doc readme.txt) &"
.br
\-document "(emacs %P) &"
.br
"(emacs /tmp/fkiss123/litks09.doc /tmp/fkiss123/readme.txt) &"
.TP
.BI \-suffix " .foo"
Add suffix \fI.foo\fP into document suffix list.
.TP
.BI \-nosuffix " .foo"
Delete suffix \fI.foo\fP from document suffix list.
.TP
.BI \-autoadjust " n"
Automatic object position adjustment range \fIn\fP pixels.
4 pixels by default.
"\-autoadjust 0" to disable automatic object position adjustment.
.TP
.B \-nowarncase
Suppress CEL and Sound file case\-ignore warnings.
.TP
.BI \-maxaction " n"
Change maximum number of actions per event.
Default 256.
.TP
.BI \-maxtimer " n"
Change maximum number of timers.
Default 256.
.TP
.BI \-maxevent " n"
Change maximum number of events.
Default 256.
.TP
.BI \-maxsoundfile " n"
Change maximum number of sound files.
Default 256.
.TP
.BI \-alpha " n"
Change alpha channel tranparency level.
Add \fIn\fP to each pixel alpha level (0..255).
.br
.B \-255
	All pixels transparent.
.br
.B +255
	Not transparent.
.br
.TP
.BI \-esd " host"
Change EsounD server \fIhost\fP.
Default Localhost.
.TP
.B \-noesd
Not use EsounD, use /dev/dsp.
.TP
.BI \-midiplayer " program"
Set external MIDI player \fIprogram\fP.
Default "/usr/bin/midiplay" or
 "/usr/bin/playmidi" or
 "/usr/local/bin/timidity \-idq".
.SH "KEY BINDINGS"
.TP
.B Button1
Catch the object which is pointed.
If no objects or fixed object is pointed,
scroll the image with moving mouse.
.TP
.B Button2
Iconify window.
.TP
.B Button3
Display cell comment.
.TP
.B \-
Previous set.
.TP
.B =
Next set.
.TP
.B [
Previous color group.
.TP
.B ]
Next color group.
.TP
.B Space
Toggle upper/lower menu bar.
.TP
.B Escape
Iconify window.
.TP
.B Control\-S
Save cnf file.
Original cnf file is renamed *.cnf~.
.TP
.B q
Quit.
.TP
.B Control\-Button1
Unmap the cell which is pointed.
And register it for 'v' toggle mapping.
.br
For KISS data creaters ONLY.
Others must NOT use this function.
.TP
.B v
Toggle mapping/unmapping the cell which is unmapped by Contol\-Button1.
Don't forget mapping it again before next Control\-Button1.
.TP
.B d
Browse document files (*.doc *.txt *.hed).
Initial settings, use \fBxemacs\fP program.
.TP
.B r
Revert position of all objects in current set to initial.
If fkiss event extension is detected,
this function is disabled.
.SH FILES
.TP
*.cnf
KISS configuration file
.TP
*.kcf
KISS color file
.TP
*.cel
KISS cell file
.TP
*.lzh
LHa archive file
.TP
lha
LHa archiver
.TP
\fBTMPDIR\fP/fkiss*
temporary directory to extract files
.TP
\fBHOME\fP/.fkissrc
rc file for fkiss.
.TP
\fBHOME\fP/fkiss.au
startup sound file
.TP
play
command for playing sound file
.SH STANDARDS
.B fkiss
conforms to KISS/GS2, KISS/GS4 (draft).
See kissgs.doc \- KISS/GS (KISS General Specification) Manual.
.SH BUGS
Cannot enjoy colorful dresses on GrayScale and StaticGray visual
class server.
.br
TrueColor or DirectColor visual class server is required to display
True\-colored CEL data.
.br
Transrucent image operation is emulated with dither stipple pattern.
.br
Does not work with Network Audio System.
.br
\fBXdefaults\fP settings are ignored.
.SH "SEE ALSO"
gnomekiss(1)
.SH COPYING
.B French\-KISS! and this manual page
are free software, licensed under the GNU GPL.
.br
The original version by yav is at "http://www2s.biglobe.ne.jp/~yav/".
The version in Debian has been substantially modified to keep it functioning
half-decently, since
yav seems to have stopped development; please file bug reports with Debian.
.SH AUTHOR
yav <yav@bigfoot.com>
.br
Large portions of the manpage rewritten by Nathanael Nerode.
