/*
Copyright (c) 2004, 2005, 2006 The FlameRobin Development Team

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.


  $Id: table.h 1113 2006-05-14 17:32:35Z mbabuskov $

*/

//-----------------------------------------------------------------------------
#ifndef FR_TABLE_H
#define FR_TABLE_H

#include "metadata/collection.h"
#include "metadata/column.h"
#include "metadata/constraints.h"
#include "metadata/Index.h"
#include "metadata/relation.h"
#include "metadata/trigger.h"
//-----------------------------------------------------------------------------
class Table: public Relation
{
private:
    PrimaryKeyConstraint primaryKeyM;           // table can have only one pk
    bool primaryKeyLoadedM;
    bool loadPrimaryKey();

    std::vector<ForeignKey> foreignKeysM;
    bool foreignKeysLoadedM;
    bool loadForeignKeys();

    std::vector<CheckConstraint> checkConstraintsM;
    bool checkConstraintsLoadedM;
    bool loadCheckConstraints();

    std::vector<UniqueConstraint> uniqueConstraintsM;
    bool uniqueConstraintsLoadedM;
    bool loadUniqueConstraints();

    std::vector<Index> indicesM;
    bool indicesLoadedM;
    bool loadIndices();

public:
    Table();

    static bool tablesRelate(const std::vector<wxString>& tables, Table *table,
                             std::vector<ForeignKey>& list);

    virtual wxString getCreateSqlTemplate() const;

    virtual bool loadColumns();         // update the keys info too
    void invalidateIndices(const wxString& forIndex = wxEmptyString);

    PrimaryKeyConstraint *getPrimaryKey();
    std::vector<ForeignKey> *getForeignKeys();
    std::vector<CheckConstraint> *getCheckConstraints();
    std::vector<UniqueConstraint> *getUniqueConstraints();
    std::vector<Index> *getIndices();

    wxString getInsertStatement();
    //wxString getUpdateStatement();        // use primary key info
    //wxString getDeleteStatement();
    virtual const wxString getTypeName() const;
    virtual void acceptVisitor(MetadataItemVisitor* visitor);
};
//-----------------------------------------------------------------------------
#endif
